<?php
class AdminController extends Zend_Controller_Action {
	
	private $mess;		
    
    public function postDispatch()
    {    	
        $this->view->messages = $this->mess->getMessages(); //getCurrentMessages();
        if(empty($this->view->messages)){
        	$this->view->messages = array();
        }
    }
    
	public function init(){
		 $this->_helper->layout->setLayout('admin');
		 $this->mess = $this->_helper->FlashMessenger;
		 $auth = Zend_Auth::getInstance();
		 if($auth->hasIdentity()){
		 	$user = $auth->getStorage()->read();
		 	if($user->acl_id != 1){
		 		$this->_redirect('/');
		 	}
		 }else{
		 	$this->_redirect('/');
		 }
	}
	
	public function indexAction(){
		$page = $this->_request->getParam('strana');
		if(empty($page))
		  $page = 1;
		$clanky = new Model_DbTable_Clanky();
		$statement = $clanky->select()->limitPage($page, 10);
		$result = $clanky->fetchAll($statement);
    	$paginator = Zend_Paginator::factory($clanky->fetchAll());
    	$paginator->setItemCountPerPage(10);
    	$paginator->setCurrentPageNumber($page);
    	$this->view->paginator=$paginator;		
		$this->view->clanky = $result;
	}
	
	public function zobrazClanokAction(){
		$id = $this->_request->getParam('id');
		$clanok = new Model_DbTable_Clanky();
		$statement = $clanok->select()->where('id = ?', $id);
		$this->view->clanok = $clanok->fetchRow($statement);			   	
	}
	
	public function upravClanokAction(){
		$id = $this->_request->getParam('id');
		$uloz = $this->_request->getParam('uloz');
		if(empty($id)){
			$this->mess->addMessage(array('typ' => 'error', 'sprava' => 'Nezadana hodnota parametru #ID'));
			$this->_redirect('/admin'); 
		}
		$clanok = new Model_DbTable_Clanky();
		if(empty($uloz)){		  
		  $statement = $clanok->select()->where('id = ?', $id);
		  $this->view->clanok = $clanok->fetchRow($statement);
		}else{
			$where = 'id = '.$id;
			$content = $this->_request->getParam('content');
			$title = $this->_request->getParam('title');
			$img = $this->_request->getParam('img');
			$data = array(
			  'content' => $content,
			  'title' => $title,
			  'img' => $img
			);
			$result = $clanok->update($data, $where); 
			$this->mess->addMessage(array('typ' => 'ok', 'sprava' => 'Záznam bol úspešne upravený'));
			$this->_redirect('/admin');									
		}
	}
	
	public function pridajClanokAction(){
		$valid = true;
		$uloz = $this->_request->getParam('uloz');
		$content = $this->_request->getParam('content');
		$title = $this->_request->getParam('title');
		$img = $this->_request->getParam('img');
			
		if(!empty($uloz)){			
			$clanok = new Model_DbTable_Clanky();
			$pridal = 1;
			if(empty($content) || empty($title)){
				$this->view->content = $content;
				$this->view->img = $img;
				$this->view->title = $title;
				$this->addMessage('error', 'Vyplň všetky potrebné údaje');
				$this->_request->setParam('uloz', null);
				$valid = false;
			}
			if($valid){			
			  $data = array(
			    'content' => $content,
			    'title' => $title,
			    'img' => $img,
			    'date' => new Zend_Db_Expr('NOW()'),
			    'user_id' => $pridal
			  );						
			  $result = $clanok->insert($data);	
			  $this->addMessage('ok', 'Článok bol úspešne zapísaný do databázy');		
			  $this->_redirect('/admin');
			}
		}
	}

	public function vymazClanokAction(){
		$this->_helper->layout()->disableLayout();
		$this->_helper->viewRenderer->setNoRender(true);		
		$id = $this->_request->getParam('id');
		if(empty($id)){
			$this->addMessage('error', 'Neplatne zadana hodnota ID článku');			
		}else{
			$clanok = new Model_DbTable_Clanky();
			$where = 'id = '.$id;
			$clanok->delete($where);
			$this->addMessage('ok', 'Zaznam s id #'.$id.' bol úspešne vymazaný');			
		}
		$this->_redirect('/admin');
	}
	
	
	
	/////////////////////////////////////////////////////////////////////////////////////////////////////////
	
	public function videoklipyAction(){
		$page = $this->_request->getParam('strana');	
		if(empty($page)){
			$page = 1;	
		}
		$videoklipy = new Model_DbTable_Videoklipy();
		$statement = $videoklipy->select()->limitPage($page, 10);
		$result = $videoklipy->fetchAll($statement);
    	$paginator = Zend_Paginator::factory($videoklipy->fetchAll());
    	$paginator->setItemCountPerPage(10);
    	$paginator->setCurrentPageNumber($page);
    	$this->view->paginator=$paginator;						
		$this->view->klipy = $result;
	}
	
	public function pridajVideoklipAction(){
		
	}
	
	public function vymazVideoklipAction(){
		$id = $this->_request->getParam('id');
		if(empty($id)){
			$this->addMessage('error', 'Neplatna hodnota #ID');
		}else{
			$this->_helper->layout()->disableLayout();
			$this->_helper->viewRenderer->setNoRender(true);
			$klip = new Model_DbTable_Videoklipy();
			$where = 'id = '.$id;
			$klip->delete($where);
			$this->addMessage('ok', 'Videoklip bol úspešne vymazaný');
		    $this->_redirect('/admin/videoklipy');
		}
	}
	
	public function upravVideoklipAction(){
		$id = $this->_request->getParam('id');
		$this->view->id = $id;
		if(empty($id)){
			$this->addMessage('error', 'Neplatna hodnota parametru #ID');
			$this->_redirect('/admin/videoklipy');
		}else{
			$klip = new Model_DbTable_Videoklipy();
			$statement = $klip->select()->where('id = ?', $id);
			$res = $klip->fetchRow($statement);
			$this->view->title = $res->title;
			$this->view->url = $res->url;			
			$odosli = $this->_request->getParam('uloz');
			if(!empty($odosli)){
				$title = $this->_request->getParam('title');
				$url = $this->_request->getParam('url');
				if(empty($title) || empty($url)){
					$this->_request->setParam('uloz', null);
					$this->view->url = $url;
					$this->view->title = $title;					
				}else{
				  $where = 'id = '.$id;
				  $data = array('title' => $title, 'url' => $url);				
				  $klip->update($data, $where);
				  $this->addMessage('ok', 'Zaznam bol uspesne upraveny');
				  $this->_redirect('/admin/videoklipy');
				}
			}			
		}
	}
	
	public function pripravVideoklipAction(){
    	$id=  $this->_request->getParam('id');
    	$odosli = $this->_request->getParam('uloz3');
    	if(!empty($id)){    		
    		$yt = new Zend_Gdata_YouTube();
    		$result = $yt->getVideoEntry($id);   
    		$video_url =  $result->mediaGroup->player[0]->url;
    		$thumb_url = $result->mediaGroup->thumbnail[0]->url;	    		
    		$this->view->info = $video_url;
    		$this->view->img = $thumb_url;
    		$this->view->url = $id;
    		$nadpis = $result->getVideoTitle();
    		$this->view->title = $nadpis;
    		if(!empty($odosli)){
    			$url = $this->downloadThumb($video_url, $thumb_url); 
    			$data = array(
    			  'active' => 1, //TODO 0 .. iba Debug verzia
    			  'title' => $nadpis,
    			  'url' => $id,
    			  'category' => 0,
    			  'date' => new Zend_Db_Expr('NOW()') 
    			); 
    			$videoklip = new Model_DbTable_Videoklipy();
    			$videoklip->insert($data);
    			$this->addMessage('ok', 'Videoklip bol úspešne pridaný');
    			$this->_redirect('/admin/videoklipy');   		     		      		  
    		} 
    	}else{
    		$this->addMessage('error', 'Nezadaná hodnota #ID');
    		$this->_redirect('/admin/videoklipy');
    	}
	}
	
	public function ulozVideoklipAction(){
		$this->_helper->layout()->disableLayout();
		$this->_helper->viewRenderer->setNoRender(true);		
	}
	
	public function rebrickyAction(){
		$page = $this->_request->getParam('strana');
		if(empty($page)){
			$page = 1;
		}
		$rebricky = new Model_DbTable_Rebricky();
		$statement = $rebricky->select()->limitPage($page,10);
		$this->view->rebricky = $rebricky->fetchAll($statement);
    	$paginator = Zend_Paginator::factory($rebricky->fetchAll());
    	$paginator->setItemCountPerPage(10);
    	$paginator->setCurrentPageNumber($page);
    	$this->view->paginator=$paginator;			
				
	}
	
	public function pridajRebricekAction(){
		$uloz = $this->_request->getParam('uloz');
		if(!empty($uloz)){
			$rebricek = new Model_DbTable_Rebricky();
			$nazov = $this->_request->getParam('title');
			$data = array('name' => $nazov, 'date' => new Zend_Db_Expr('NOW()'));
			if(!empty($nazov)){
				$rebricek->insert($data);
				$this->addMessage('ok', 'Rebríček bol úspešne pridaný');
				$this->_redirect('/admin/rebricky');
			}else{
				$this->view->nazov = $nazov;
			}
		}
	}
	
	public function rebricekInfoAction(){
		$id = $this->_request->getParam('id');
		$uloz = $this->_request->getParam('uloz');	
		if(!empty($id)){
			$this->view->id = $id;
			$rebricek2klip = new Model_DbTable_RebricekNaKlip();
			$statement = $rebricek2klip->select('klipy')->where('rebriceknaklip.rebricek_id = ?', $id)->setIntegrityCheck(false)->joinLeft('klipy', 'rebriceknaklip.klip_id = klipy.id', array('p' => 'id', 't' =>'title', 'd' =>'date', 'u' =>'url'));
			$this->view->klipy = $rebricek2klip->fetchAll($statement);
			if(!empty($uloz)){
		 		$rebricek = new Model_DbTable_Rebricky();
		  		$klip_id = $this->_request->getParam('klip_id');
		  		$this->_request->setParam('uloz', null);
		  		$videoklip = new Model_DbTable_Videoklipy();
		  		$test_stat = $videoklip->select()->where('id = ?', $klip_id);
		  		$result = $videoklip->fetchRow($test_stat);		  		
		  		if(!empty($klip_id) && $result != null){ 
		  			$data = array('klip_id' => $klip_id, 'rebricek_id' => $id, 'pos' => '0');	
		  			$rebricek2klip->insert($data);
		  			$this->addMessage('ok', 'Videoklip bol pridaný do rebríčku #'.$id);
		  			$this->_redirect('/admin/rebricek-info/id/'.$id);	  			
		  		}else{
		  			$this->addMessage('error', 'Neplatna hodnota #ID parametru pre klip');
		  			$this->_redirect('/admin/rebricek-info/id/'.$id);
		  		}
		}			 			
		}else{
			$this->addMessage('error', 'Neplatna hodnota #ID');
			$this->_redirect('/admin/rebricky');
		}						
	}
	
	public function vymazZRebrickuAction(){
		$this->_helper->layout()->disableLayout();
		$this->_helper->viewRenderer->setNoRender(true);
		$id = $this->_request->getParam('id');
		if(!empty($id)){
			$rebricek = new Model_DbTable_RebricekNaKlip();
			$rebricek->delete('id = '.$id);
			$this->addMessage('ok', 'Zaznam bol uspesne vymazany');
		}else{
			$this->addMessage('error', 'Neplatna hodnota #ID parametru');
		}
		$this->_redirect('/admin/rebricky');
	}
	
	public function vymazRebricekAction(){
		$id = (int)$this->_request->getParam('id');
		if(!empty($id)){			
			$rebricekNaKlip = new Model_DbTable_RebricekNaKlip();
			$res = $rebricekNaKlip->delete('rebricek_id = '.$id);
			$rebricek = new Model_DbTable_Rebricky();
			$rebricek->delete('id = '.$id);
			$this->addMessage('ok', 'Rebricek bol uspesne vymazany');									
		}else{
			$this->addMessage('error', 'Nepravna hodnota #ID');
		}
		$this->_redirect('/admin/rebricky');
	}
	
	
	//===========================================
	// Pomocne funkcie
	//=========================================== 
	
	private function addMessage($typ, $sprava){
		$this->mess->addMessage(array('typ' => $typ, 'sprava' => $sprava));
	}
	
    private function downloadThumb($video_url, $thumb_url){
    	$pos = strpos($video_url, 'v=');
    	$video = substr($video_url, $pos +2 );
    	$pos = strpos($video, '&');
    	$video = substr($video,0,$pos);
    	$date = date('d-m-Y');	
    	$YourFile = $thumb_url;

		$Data = file_get_contents($YourFile);
		    			
		$myFile01 = "data/".$date;
		if(!file_exists($myFile01)){
			mkdir($myFile01, 777);
		}
		$myFile = "data/".$date."/".$video.".jpg";		
		file_put_contents($myFile, $Data);

    	$thumb = substr($url, strpos($url, '?v='+3), 10);
    	return $thumb;
    }
    
    public function usersAction(){
    	//$uzivatelia = new Mode
    }
}
?>