<?php
session_start();
include_once('utils/cUser.php');
include_once('utils/cItem.php');
//include('utils/SiteRenderer.php');
include('utils/SiteSettings.php');
include('sites/index/cIndexSite.php');
include('sites/user/cUserSite.php');
include('sites/galery/cGalerySite.php');

SiteSettings::load();

$errors=array();
$messages=array();
$data = array();

request("","","");

function request($name_site,$name_action,$name_view){
    global $errors,$messages,$data;
    
    $user = new cDefaultUser();
    if(isset($_SESSION['user'])){
        $user= cUser::getById($_SESSION['user']);
    }

    $site = SiteSettings::getDefaultSite();
    if(SiteSettings::isSite($name_site)){
         $site = SiteSettings::getSite($name_site);
    }else{
        if(isset($_GET['site'])){
            if(SiteSettings::isSite($_GET['site'])){
                $site = SiteSettings::getSite($_GET['site']);
            }else{
                $errors[]="Requested site ".$_GET['site']."doesn't exist.";
            }
        }
    }
    $action = $site->getDefaultAction();
    if($site->isAction($name_action)){
         $action = $site->getAction($name_action);
    }else if(isset($_GET['action'])){
        if($site->isAction($_GET['action'])){

            $action = $site->getAction($_GET['action']);

        }else{
            $errors[]="Requested action ".$_GET['action']."doesn't exist.";;
        }
    }


    if($action->canDo($user)){
        $action->run();
        $errors =array_merge($errors, $action->getErrors());
        $messages =array_merge($messages, $action->getMessages());

    }else{
        $errors =array_merge($errors, $action->getErrors());
    }
    $data = $action->getData();

   if($action->redirect() == true){
        request($action->getSite(),$action->getAction(),$action->getView());
        return;

   }
  $renderer = $site->getDefaultView();
    if($site->isView($name_view)){
         $renderer = $site->getView($name_view);
    }else if(isset($_GET['view'])){
        if($site->isView($_GET['view'])){

            $renderer = $site->getView($_GET['view']);

        }else{
            $errors[]="Requested view ".$_GET['view']."doesn't exist.";;
        }
    }

    if($renderer->canView($user)){
 
        $renderer->render($data,$errors,$messages);
        return;
    }else{
        $renderer = $site->getDefaultView();
        $errors[]="You can't view this part of site.";;
        $renderer->render($data,$errors,$messages);
        return;
    }
}

?>
