<?php
include('sites/user/cUserSiteActionDefault.php');
include('sites/user/cUserSiteViewDefault.php');
include('sites/user/cUserSiteActionNew.php');
include('sites/user/cUserSiteViewNew.php');
include('sites/user/cUserSiteViewLogin.php');
include('sites/user/cUserSiteActionLogin.php');
include('sites/user/cUserSiteActionLogout.php');

include('sites/user/cUserSiteViewEdit.php');
include('sites/user/cUserSiteActionEdit.php');
include('sites/user/cUserSiteViewList.php');
include('sites/user/cUserSiteActionList.php');
include('sites/user/cUserSiteActionRemove.php');
/**
 * Description of cUserSite
 *
 * @author camper
 */
class cUserSite {
    private $actions;
    private $views;
    function __construct() {
        $this->actions = array(
            "default"=>"cUserSiteActionDefault",
            "new"=>"cUserSiteActionNew",
            "login"=>"cUserSiteActionLogin",
            "logout"=>"cUserSiteActionLogout",
            "edit"=>"cUserSiteActionEdit",
            "list"=>"cUserSiteActionList",
			"remove"=>"cUserSiteActionRemove",
        );
        $this->views = array(
            "default"=>"cUserSiteViewDefault",
            "new"=>"cUserSiteViewNew",
            "login"=>"cUserSiteViewLogin",
            "edit"=>"cUserSiteViewEdit",
            "list"=>"cUserSiteViewList"

        );
    }
    function isAction($action){
        if(isset($this->actions[$action])){
            return true;
        }
        return false;
    }
    function getDefaultAction(){
       $clases = array_values($this->actions);
       $classname=$clases[0];
       return new $classname;
    }
    function getAction($action){
       if($this->isAction($action)){
           $classname= $this->actions[$action];
           return new $classname;
       }
       return $this->getDefaultAction();
    }

    function isView($view){
        if(isset($this->views[$view])){
            return true;
        }
        return false;
    }
    function getDefaultView(){
       $clases = array_values($this->views);
       $classname=$clases[0];
       return new $classname;
    }
    function getView($view){
       if($this->isView($view)){
           $classname= $this->views[$view];
           return new $classname;
       }
       return $this->getDefaultView();
    }

}
?>
