<?php
ini_set("include_path", "../utils".PATH_SEPARATOR."../../utils".PATH_SEPARATOR.ini_get("include_path"));
require_once 'PHPUnit/Framework.php';

require_once '/var/www/galery/utils/cUser.php';

/**
 * Test class for cUser.
 * Generated by PHPUnit on 2010-04-04 at 12:45:03.
 */
class cUserTest extends PHPUnit_Framework_TestCase
{
    /**
     * @var cUser
     */
    protected $uAdmin;

    protected $uLuser;
    protected $uAbdul;
    protected $uAdam;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp()
    {

    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown()
    {
        
    }

  
    /**
     * Dostanu sa k databaze?
     */
    public function testGetUserDB()
    {
        // Remove the following lines when you implement this test.

    }

    /**
     * @todo Implement testCheckNick().
     */
    public function testCheckNick()
    {
        // Remove the following lines when you implement this test.
       
    }

    /**
     * @todo Implement testCheckMail().
     */
    public function testCheckMail()
    {
        
    }

    /**
     * @todo Implement testCheckPassword().
     */
    public function testCheckPassword()
    {
        
    }

    public function testPrivileges()
    {
        $admin=cUser::getByNick("admin");
         
        $this->assertEquals(true,$admin->hasPrivilege('admin'));
        $this->assertEquals(true,$admin->hasPrivilege('tags'));
        $this->assertEquals(true,$admin->hasPrivilege('adds_all'));
        $this->assertEquals(true,$admin->hasPrivilege('sees_all'));
        $this->assertEquals(true,$admin->hasPrivilege('comments'));

        cUser::create("luser8","327b75fe98ddc7b6b9fe03914b52449c36c84138","lame user", "");
        
        $user=cUser::getByNick("luser8");
        $this->assertEquals(false,$user->hasPrivilege('adds_all'));
        $user->addPrivilege('adds_all');
        $this->assertEquals(true,$user->hasPrivilege('adds_all'));
        unset($user);

        $user2 =cUser::getByNick("luser8");
        $this->assertEquals(true,$user2->hasPrivilege('adds_all'));
        $user2->removePrivilege('adds_all');
        $this->assertEquals(false,$user2->hasPrivilege('adds_all'));
        unset($user2);

        $user3 =cUser::getByNick("luser8");
        $this->assertEquals(false,$user3->hasPrivilege('adds_all'));

        cUser::remove($user3->getId());
        unset($user3);
    }
    
    public function testEditUser()
    {
        cUser::create("luser","327b75fe98ddc7b6b9fe03914b52449c36c84138","lame user", "");
        cUser::create("adam","327b75fe98ddc7b6b9fe03914b52449c36c84138","me", "");




        $user=cUser::getByNick("luser");
        $this->assertEquals("lame user",$user->getPopis());
        $user->setPopis("not as lame user");
        $user->setNick('user');
        $user->setEmail('mh@mf.mm');
        $this->assertEquals("not as lame user",$user->getPopis());
        $this->assertEquals("user",$user->getNick());
        $this->assertEquals("mh@mf.mm",$user->getEmail());

        unset($user);

        $user2=cUser::getByNick("user");
        $this->assertEquals("not as lame user",$user2->getPopis());
        $this->assertEquals("user",$user2->getNick());
        $this->assertEquals("mh@mf.mm",$user2->getEmail());
        cUser::remove($user2->getId());
        unset($user2);
/****************************/
        $user=cUser::getByNick("adam");
        $this->assertEquals("me",$user->getPopis());
        $user->setPopis("I am Adam");
        $this->assertEquals("I am Adam",$user->getPopis());
        unset($user);

        $user2=cUser::getByNick("adam");
        $this->assertEquals("I am Adam",$user2->getPopis());
        cUser::remove($user2->getId());
        unset($user2);
    }


    /**
     * 
     */
    public function testGetById()
    {
        $admin = cUser::getById(0);
         $this->assertEquals('admin',$admin->getNick());
         
    }

    /**
     * .
     */
    public function testGetByNick()
    {
        cUser::create("luser","327b75fe98ddc7b6b9fe03914b52449c36c84138","lame user", "");
        cUser::create("Ali Abdull Mohammad Ibn Al Hadzhi Ibn Batuta","327b75fe98ddc7b6b9fe03914b52449c36c84138","long name user", "");
        cUser::create("adam","327b75fe98ddc7b6b9fe03914b52449c36c84138","me", "");


        $user=cUser::getByNick("admin");
         $this->assertEquals('admin',$user->getNick());
        //cUser::remove($user->getId()); cant remove admin
        unset($user);


        $user=cUser::getByNick("luser");
        $this->assertEquals('luser',$user->getNick());
        cUser::remove($user->getId());
        unset($user);
        $user=cUser::getByNick("luser");
        $this->assertEquals(NULL,$user);
        unset($user);


        $user=cUser::getByNick("adam");
         $this->assertEquals('adam',$user->getNick());
        cUser::remove($user->getId());
        unset($user);
        $user=cUser::getByNick("adam");
        $this->assertEquals(NULL,$user);
        unset($user);

        $user=cUser::getByNick("Ali Abdull Mohammad Ibn Al Hadzhi Ibn Batuta");
         $this->assertEquals('Ali Abdull Mohammad Ibn Al Hadzhi Ibn Batuta',$user->getNick());
        cUser::remove($user->getId());
        unset($user);
        $user=cUser::getByNick("Ali Abdull Mohammad Ibn Al Hadzhi Ibn Batuta");
        $this->assertEquals(NULL,$user);
        unset($user);
        

    }

}
?>
