<?
function add_placemark($name,$type,$state,$country,$longitude,$latitude,$altitude)
{
	if (!auth_islogged())
		return false;
	
	$name = htmlspecialchars($name);
	$type = htmlspecialchars($type);
	$state = htmlspecialchars($state);
	$country = htmlspecialchars($country);
	$longitude = htmlspecialchars($longitude);
	$latitude = htmlspecialchars($latitude);
	$altitude = htmlspecialchars($altitude);
	
	if ((strlen($name) < 1) OR (!is_numeric($type)) OR (!is_numeric($state)) OR (!is_numeric($longitude)) OR (!is_numeric($latitude)))
		return false;
		
	if ((!is_numeric($altitude)) AND (strlen($altitude) != 0))
		return false;
	
	$type = db_safe_string($type);
			
	if (!($type_check = db_query("SELECT id FROM placemark_type_enumerator WHERE id = '$type'")))
		return false;
	
	if (db_num_rows($type_check) < 1)
		return false;	
		
	$state = db_safe_string($state);
	
	if (!($state_check = db_query("SELECT id FROM country_enumerator WHERE id = '$state'")))
		return false;
	
	if (db_num_rows($state_check) < 1)
		return false;	
	
	$name = db_safe_string($name);
	$country = db_safe_string($country);
	$longitude = db_safe_string($longitude);
	$latitude = db_safe_string($latitude);
	$altitude = db_safe_string($altitude);
	
	if (strlen($altitude) == 0)
		unset($altitude);
	
	$add_query = "INSERT INTO placemarks (name,author,type,place_state,place_country,gps_longitude,gps_latitude,gps_altitude) VALUES ('$name','".db_safe_string(auth_userid())."','$type','$state','$country','$longitude','$latitude',".(isset($altitude)?"'".$altitude."'":"NULL").")";
	if (!db_query($add_query))
		return false;
	
	return true;
}

include_once("lang/".$language."/placemarklist_lang.php");
?>

<span class="hide_show_button" id="placemark_add_form_show" onclick='showForm("placemark_add_form_set","placemark_add_form_show");'><? echo "+ ".$placemarklist_lang['21'];?></span>
<form action="" enctype="multipart/form-data" method="post" id="placemark_add_form">
	<fieldset id="placemark_add_form_set">
			<legend><? echo $placemarklist_lang['21'];?></legend>
			
			<label for="placemark_add_name"><? echo $placemarklist_lang['4'];?></label>
			<input type="text" id="placemark_add_name" name="placemark_add_name" maxlength="255" title=<? echo "\"".$placemarklist_lang['4']."\"";?> <? if (isset($_POST['placemark_add_name'])) echo "value=\"".htmlspecialchars($_POST['placemark_add_name'])."\"";?> />
									
			<label for="placemark_add_type"><? echo $placemarklist_lang['5'];?></label>
			<select name="placemark_add_type" id="placemark_add_type">
				<?
				$req = db_query("SELECT id, name FROM placemark_type_enumerator ORDER BY name ASC");
				if (!$req)
				{
					die("Error connecting database: ".db_error());
				}
				
				$type_def = null;
				if ((isset($_POST['placemark_add_type'])) AND (is_numeric(htmlspecialchars($_POST['placemark_add_type']))))
					$type_def = htmlspecialchars($_POST['placemark_add_type']);
				while ($type = db_fetch_array($req))
				{
				?>
					<option value=<? echo "\"".htmlspecialchars($type["id"])."\"";?> <? if (htmlspecialchars($type["id"])==$type_def) echo "selected=\"selected\""?>><? echo htmlspecialchars($type["name"]);?></option>
				<?
				}
				?>			
			</select>									
			<br/>
			<label for="placemark_add_state"><? echo $placemarklist_lang['7'];?></label>
			<select name="placemark_add_state" id="placemark_add_state">
				<?
				$req = db_query("SELECT id,name FROM country_enumerator ORDER BY name ASC");
				if (!$req)
				{
					die("Error connecting database: ".db_error());
				}
				
				$state_def = 156;
				if ((isset($_POST['placemark_add_state'])) AND (is_numeric(htmlspecialchars($_POST['placemark_add_state']))))
					$state_def = htmlspecialchars($_POST['placemark_add_state']);
				while ($state = db_fetch_array($req))
				{
				?>
					<option value=<? echo "\"".htmlspecialchars($state["id"])."\"";?> <? if (htmlspecialchars($state["id"])==$state_def) echo "selected=\"selected\""?>><? echo htmlspecialchars($state["name"]);?></option>
				<?
				}
				?>			
			</select>					
						
			<label for="placemark_add_country"><? echo $placemarklist_lang['6'];?></label>
			<input type="text" id="placemark_add_country" name="placemark_add_country" maxlength="255" title=<? echo "\"".$placemarklist_lang['6']."\"";?> <? if (isset($_POST['placemark_add_country'])) echo "value=\"".htmlspecialchars($_POST['placemark_add_country'])."\"";?>/>
			<br/>
			
			<label for="placemark_add_longitude"><? echo $placemarklist_lang['23'];?></label>
			<input type="text" id="placemark_add_longitude" size="8" name="placemark_add_longitude" maxlength="20" title=<? echo "\"".$placemarklist_lang['23']."\"";?> <? if (isset($_POST['placemark_add_longitude'])) echo "value=\"".htmlspecialchars($_POST['placemark_add_longitude'])."\"";?>/>
			
			<label for="placemark_add_latitude"><? echo $placemarklist_lang['24'];?></label>
			<input type="text" id="placemark_add_latitude" size="8" name="placemark_add_latitude" maxlength="20" title=<? echo "\"".$placemarklist_lang['24']."\"";?> <? if (isset($_POST['placemark_add_latitude'])) echo "value=\"".htmlspecialchars($_POST['placemark_add_latitude'])."\"";?>/>			
			
			<label for="placemark_add_altitude"><? echo $placemarklist_lang['25'];?></label>
			<input type="text" id="placemark_add_altitude" size="8" name="placemark_add_altitude" maxlength="20" title=<? echo "\"".$placemarklist_lang['25']."\"";?> <? if (isset($_POST['placemark_add_altitude'])) echo "value=\"".htmlspecialchars($_POST['placemark_add_altitude'])."\"";?>/>
						
			<input type="submit" name="placemark_add" title=<? echo "\"".$placemarklist_lang['22']."\"";?> value=<? echo "\"".$placemarklist_lang['22']."\"";?>	/>						
			<br/>
			<?
			if (isset($_POST['placemark_add']))
			{
				if ((isset($_POST['placemark_add_name'])) AND (isset($_POST['placemark_add_type'])) AND (isset($_POST['placemark_add_state'])) AND (isset($_POST['placemark_add_country'])) AND (isset($_POST['placemark_add_longitude'])) AND (isset($_POST['placemark_add_latitude'])) AND (isset($_POST['placemark_add_altitude'])))
				{
					if (strlen($_POST['placemark_add_name']) < 1)
					{ ?>
						<span class="form_error"><? echo $placemarklist_lang['26']; ?></span>
			<?	}
					else if (!is_numeric($_POST['placemark_add_longitude']))
					{ ?>
						<span class="form_error"><? echo $placemarklist_lang['27']; ?></span>
			<?	}
					else if (!is_numeric($_POST['placemark_add_latitude']))
					{ ?>
						<span class="form_error"><? echo $placemarklist_lang['28']; ?></span>
			<?	}
					else if (!add_placemark($_POST['placemark_add_name'],$_POST['placemark_add_type'],$_POST['placemark_add_state'],$_POST['placemark_add_country'],$_POST['placemark_add_longitude'],$_POST['placemark_add_latitude'],$_POST['placemark_add_altitude']))
					{ ?>
						<span class="form_error"><? echo $placemarklist_lang['29']; ?></span>
			<?	}
					else
					{ ?>
						<span class="form_ok"><? echo $placemarklist_lang['30']; ?></span>
			<?	unset($_POST);
					}
				}				
			}
			
			?>
			
	</fieldset>
</form>
<script type="text/javascript">
	<? if(!(isset($_POST['placemark_add'])))
	    echo 'hideForm("placemark_add_form_set","placemark_add_form_show");';
	?>
</script>