﻿using System;
using System.Data;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class customControls_Filters : System.Web.UI.UserControl {


    private NorthwindDataContext db = new NorthwindDataContext();
    private string _DataListID = null;

    public string DataListID {
        get { return _DataListID; }
        set {_DataListID = value; }
    }

    protected void Page_Load(object sender, EventArgs e) {
        if (!Page.IsPostBack) {
            Load_All_Checkboxes();
            Load_ArticlesCheckboxlists(); 
        }
    }

    private void Load_All_Checkboxes() {
        chb_user_all.Text = "všetci";
        chb_user_all.Checked = true;
        chb_user_all.EnableViewState = true;
        chb_cat_all.Text = "všetky";
        chb_cat_all.EnableViewState = true;
        chb_cat_all.Checked = true;
    }

    private void Load_ArticlesCheckboxlists() {
        var users =
            (from u in db.articles
             select new {
                 user_name = u.user_name
             }).Distinct();
        chb_user.DataSource = users;
        chb_user.DataTextField = "user_name";
        chb_user.DataValueField = "user_name";
        chb_user.DataBind();
        var cats =
            (from a in db.articles
             from rel in db.CategoryArticleRelations
             where a.article_id == rel.article_id
             select new {
                 cat_title = rel.category.title, 
                 cat_id = rel.category_id
             }).Distinct();
        chb_cat.DataSource = cats;
        chb_cat.DataTextField = "cat_title";
        chb_cat.DataValueField = "cat_id";
        chb_cat.DataBind();
        //zaskrtni vsetky
        for (int i = 0; i < chb_user.Items.Count; i++) {
            chb_user.Items[i].Selected = true;
        }
        for (int i = 0; i < chb_cat.Items.Count; i++) {
            chb_cat.Items[i].Selected = true;
        }
    }

    private void setCheckedAll(CheckBoxList _list, bool _checked){
        for (int i = 0; i < _list.Items.Count; i++) {
            _list.Items[i].Selected = _checked;
        }
    }

    protected void chb_user_all_Changed(object sender, EventArgs e) {
        if (chb_user_all.Checked) {
            setCheckedAll(this.chb_user, true);
        }
        else {
            setCheckedAll(this.chb_user, false);
        }
        applyArticleFilters();
    }

    protected void chb_cat_all_CheckedChanged(object sender, EventArgs e) {
        if (chb_cat_all.Checked) {
            setCheckedAll(this.chb_cat, true);
        }
        else {
            setCheckedAll(this.chb_cat, false);
        }
        applyArticleFilters();
    }

    protected void chb_user_SelectedIndexChanged(object sender, EventArgs e) {
        bool vsetky = true;
        foreach (ListItem c in chb_user.Items) {
            if (c.Selected) {
                //este neviem co
            }
            else {
                vsetky = false;
            }
        }
        chb_user_all.Checked = vsetky;
        applyArticleFilters();
    }

    protected void chb_cat_SelectedIndexChanged(object sender, EventArgs e) {
        bool vsetky = true;
        foreach (ListItem c in chb_cat.Items) {
            if (c.Selected) {
                //nieco
            }
            else {
                vsetky = false;
            }
        }
        chb_cat_all.Checked = vsetky;
        applyArticleFilters();
    }

    private void applyArticleFilters() {
        List<string> user_list = new List<string>();
        foreach (ListItem item in chb_user.Items) {
            if (item.Selected) {
                user_list.Add(item.Value);
            }
        }
        List<string> cat_list = new List<string>();
        foreach (ListItem item in chb_cat.Items) {
            if (item.Selected) {
                cat_list.Add(item.Value);
            }
        }
        List<article> pom =
            (from c in db.articles
             select c).ToList();
        List<article> pom_out = new List<article>();
        foreach (article a in pom) {
            if (userListContainsIt(user_list, a.user_name) &&
                atLeastOneCategory(cat_list, a.article_id)) {
                pom_out.Add(a);
            }
        }
        var final_list =
            from a in pom_out
            from p in db.photos
            where p.user_name == a.user_name
            let link = "~/main/clanok.aspx?id=" + a.article_id
            let text_link = uprav_zdroj(a.link)
            select new {
                link = link,
                title = a.title,
                zdroj = a.link,
                zdroj_text = text_link,
                pridal = a.user_name,
                desc = a.description,
                src = p.path
            };
        //var aa_out =
        //    from c in db.articles
        //    where userListContainsIt(user_list, c.user_name)
        //    where atLeastOneCategory(cat_list, c.article_id)
        //    let link = "~/main/clanok.aspx?id=" + c.article_id
        //    let text_link = uprav_zdroj(c.link)
        //    from p in db.photos
        //    where p.user_name == c.user_name
        //    select new {
        //        link = link,
        //        title = c.title,
        //        zdroj = c.link,
        //        zdroj_text = text_link,
        //        pridal = c.user_name,
        //        desc = c.description,
        //        src = p.path
        //    };
        Control obsah = Page.Master.FindControl("obsah");
        DataList dl = (DataList)obsah.FindControl(DataListID);
        dl.DataSource = final_list;
        dl.DataBind();
        //if (chb_user_all.Checked && chb_cat_all.Checked) {
        //    var a_out =
        //        from c in db.articles
        //        let link = "~/main/clanok.aspx?id=" + c.article_id
        //        let text_link = uprav_zdroj(c.link)
        //        from p in db.photos
        //        where p.user_name == c.user_name
        //        select new {
        //            link = link,
        //            title = c.title,
        //            zdroj = c.link,
        //            zdroj_text = text_link,
        //            pridal = c.user_name,
        //            desc = c.description,
        //            src = p.path
        //        };
        //    return;
        //}
        //if (chb_cat_all.Checked) {
        //    List<string> mena = new List<string>();
        //    foreach (ListItem item in chb_user.Items) {
        //        if (item.Selected) {
        //            mena.Add(item.Value);
        //        }
        //    }
        //    var a_out =
        //        from c in db.articles
        //        where mena.Contains(c.user_name)
        //        let link = "~/main/clanok.aspx?id=" + c.article_id
        //        let text_link = uprav_zdroj(c.link)
        //        from p in db.photos
        //        where p.user_name == c.user_name
        //        select new {
        //            link = link,
        //            title = c.title,
        //            zdroj = c.link,
        //            zdroj_text = text_link,
        //            pridal = c.user_name,
        //            desc = c.description,
        //            src = p.path
        //        };
        //    return;
        //}
    }

    private bool userListContainsIt(List<string> list, string s) {
        if (!chb_user_all.Checked && !list.Contains(s)) {
            return false;
        }
        return true;
    }

    private bool atLeastOneCategory(List<string> list, int article_id) {
        if (chb_cat_all.Checked) {
            return true;
        }
        List<category> all =
            (from rel in db.CategoryArticleRelations
            where rel.article_id == article_id
            select rel.category).ToList();
        List<category> list_out = new List<category>();
        foreach (category c in all) {
            if(catListContainsIt(list, c.category_id)){
                list_out.Add(c);
            }
        }
        if (list_out.Count > 0) {
            return true;
        }
        return false;
    }

    private bool catListContainsIt(List<string> list, int id) {
        if (!chb_cat_all.Checked && !list.Contains(id.ToString())) {
            return false;
        }
        return true;
    }

    private string uprav_zdroj(string _z) {
        if (_z.Length > 60) {
            string s = _z.Substring(0, 60);
            s += "...";
            return s;
        }
        return _z;

    }
}
