﻿using System;
using System.Data;
using System.Data.Linq;
using System.Data.SqlClient;
using System.Configuration;
using System.Collections;
using System.Collections.Generic;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Linq;

public partial class main_clanok : System.Web.UI.Page {

    private NorthwindDataContext db = new NorthwindDataContext();
    private Table<article> clanky = null;
    private Table<comment> komentare = null;
    private int clanok_id;
    private int comment_id;
    List<comment> komenty_out_list = new List<comment>();
     
    protected void Page_Init(object sender, EventArgs e) {
        //adding CSS style file
        HtmlLink newCSS = new HtmlLink();
        newCSS.Href = "~/css/clanky_style.css";
        newCSS.Attributes.Add("type", "text/css");
        newCSS.Attributes.Add("rel", "Stylesheet");
        Page.Header.Controls.Add(newCSS);
        newCSS.Href = "~/css/komentare_style.css";
        Page.Header.Controls.Add(newCSS);
        //add tables 
        this.clanky = db.GetTable<article>();
        this.komentare = db.GetTable<comment>();

    }

    protected void Page_Load(object sender, EventArgs e) {
        // id zobrazovaneho clanku
        string req_param = Request.QueryString["id"];
        try {
            this.clanok_id = Int16.Parse(req_param);
            article clanok = clanky.Single(c => c.article_id == this.clanok_id);
            article_title.Text = clanok.title;
            article_text.Text = clanok.text;
        }
        catch (InvalidOperationException ex) {
            //zapis log
            Response.Redirect(@"~/main/clanky.aspx");
        }
        catch (ArgumentNullException ex) {
            //zapis log
            Response.Redirect(@"~/main/clanky.aspx");
        }
        catch (Exception ex) {
            //zapis log
            Response.Redirect(@"~/main/clanky.aspx");
        }
        //init controls
        pridaj_komentar_link.NavigateUrl = "~/main/comment.aspx?"
            + "id=" + this.clanok_id + "&type=article&content=" + clanok_id;
    }

    private void findDeeperComment(comment _c) {
        IEnumerable<comment> deeper =
            from c in this.komentare
            where c.parrent_id == _c.comment_id
            where c.parrent_type == "comment"
            select c;
        if (deeper.Count<comment>() == 0) {
            return;
        }
        else {
            foreach (comment com in deeper) {
                this.komenty_out_list.Add(com);
                findDeeperComment(com);
            }
        }
    }

    protected void komenty_list_Load(object sender, EventArgs e) {
        IEnumerable<comment> komenty_out_pom =
            from c in this.komentare
            where c.parrent_id == this.clanok_id
            where c.parrent_type == "article"
            select c;
        foreach (comment c in komenty_out_pom) {
            this.komenty_out_list.Add(c);
            this.findDeeperComment(c);
        }
        var com_out =
            from c in this.komenty_out_list
            let off_set = "margin-left: " + c.off_set + "px;"
            let link = "~/main/comment.aspx?id=" + c.comment_id 
                + "&type=comment&content=" + clanok_id
            select new {
                title = c.title,
                text = c.text,
                link,
                off_set
            };
        komenty_list.DataSource = com_out;
        komenty_list.DataBind();
    }

}
