﻿using System;
using System.Data;
using System.Data.Linq;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;

public partial class main_edit_test_edit : System.Web.UI.Page {

    private NorthwindDataContext db = new NorthwindDataContext();
    private Table<test> tbl_testy = null;
    private Table<question> tbl_question = null;
    private Table<answer> tbl_answer = null;
    private Table<TestQuestionRelation> tbl_tqrel = null;
    private Table<CategoryTestRelation> tbl_ctrel = null;
    private Table<category> tbl_kategorie = null;
    private List<CheckBox> kategorie_list = null;


    Control obsah_control = null;

    private int pocet_otazok = 0;
    private int pocet_kategorii = 0;

    protected void Page_Init(object sender, EventArgs e) {
        //adding CSS style file 
        HtmlLink newCSS = new HtmlLink();
        newCSS.Href = "~/css/edit_style.css";
        newCSS.Attributes.Add("type", "text/css");
        newCSS.Attributes.Add("rel", "Stylesheet");
        Page.Header.Controls.Add(newCSS);
        //crate tables
        tbl_testy = db.tests;
        tbl_question = db.questions;
        tbl_answer = db.answers;
        tbl_ctrel = db.CategoryTestRelations;
        tbl_tqrel = db.TestQuestionRelations;
        tbl_kategorie = db.categories;
        //init others
        obsah_control = Master.FindControl("obsah");
        List<CheckBox> kategorie_list = new List<CheckBox>();
    }

    protected void Page_Load(object sender, EventArgs e) {
        if (!Page.IsPostBack) {
            //1.kategorie list
            var chb_list =
                from c in db.categories
                select new { id = c.category_id, text = c.text };
            chbl_kategorie.DataSource = chb_list;
            chbl_kategorie.DataTextField = "title";
            chbl_kategorie.DataValueField = "id";
            chbl_kategorie.DataBind();
            //ddl_spravna_odpoved_1
            string[] items = {"odpoveď č.1", "odpoveď č.2",
            "odpoveď č.3", "odpoveď č.4"};
            ddl_spravna_odpoved_1.DataSource = items;
            ddl_spravna_odpoved_1.DataBind();
            lbl_odpoved_1_1.Text="odpoveď č.1 >>";
            lbl_odpoved_1_2.Text = "odpoveď č.2 >>";
            lbl_odpoved_1_3.Text="odpoveď č.3 >>";
            lbl_odpoved_1_4.Text = "odpoveď č.4 >>";

        }
        if (ViewState["pocet_otazok"] != null) {
            pocet_otazok = int.Parse(ViewState["pocet_otazok"].ToString());
            for (int i = 1; i <= pocet_otazok; i++) {
                pridaj_otazku(i + 1);
            }
        }
    }

    /*
     * @params _i = kolka otazka sa prave generuje
     */
    private void pridaj_otazku(int _i) {
        HtmlGenericControl dv_test_otazka = new HtmlGenericControl("div");
        dv_test_otazka.Attributes.Add("class", "test_otazka");
        HtmlGenericControl dv_test_otazka_zadanie = new HtmlGenericControl("div");
        dv_test_otazka_zadanie.Attributes.Add("class", "test_otazka_zadanie");
        Label lbl_new = new Label();
        lbl_new.ID = "lbl_otazka_" + _i.ToString();
        lbl_new.Text = "otázka č." + _i.ToString();
        lbl_new.EnableViewState = true;
        TextBox tb_new = new TextBox();
        tb_new.ID = "tb_otazka_" + _i.ToString();
        tb_new.Width = 400;
        tb_new.EnableViewState = true;
        //zorat controls pre otazku
        dv_test_otazka_zadanie.Controls.Add(lbl_new);
        dv_test_otazka_zadanie.Controls.Add(tb_new);
        dv_test_otazka.Controls.Add(dv_test_otazka_zadanie);
        HtmlGenericControl dv_test_otazka_odpovede = new HtmlGenericControl("div");
        dv_test_otazka_odpovede.Attributes.Add("class", "test_otazka_odpovede");
        for (int j = 1; j <= 4; j++) {
            HtmlGenericControl dv_odpoved = new HtmlGenericControl("div");
            dv_odpoved.Attributes.Add("class", "test_otazka_odpoved");
            Label lbl_new2 = new Label();
            lbl_new2.ID = "lbl_odpoved_" + _i.ToString()
                + "_" + j.ToString();
            lbl_new2.Text = "odpoveď č." + j.ToString() + " >>";
            TextBox tb_new2 = new TextBox();
            tb_new2.ID = "tb_odpoved_" + _i.ToString()
                + "_" + j.ToString();
            tb_new2.Width = 250;
            dv_odpoved.Controls.Add(lbl_new2);
            dv_odpoved.Controls.Add(tb_new2);
            dv_test_otazka_odpovede.Controls.Add(dv_odpoved);
        }
        dv_test_otazka.Controls.Add(dv_test_otazka_odpovede);
        HtmlGenericControl dv_test_otazka_spravna_odpoved = new HtmlGenericControl("div");
        dv_test_otazka_spravna_odpoved.Attributes.Add("class", "test_otazka_spravna_odpoved");
        Label lbl_spravna = new Label();
        lbl_spravna.ID = "lbl_spravna_odpoved_" + _i.ToString();
        lbl_spravna.Text = "správna odpoveď:";
        DropDownList ddl_spravna = new DropDownList();
        ddl_spravna.ID = "ddl_spravna_odpoved_" + _i.ToString();
        dv_test_otazka_spravna_odpoved.Controls.Add(lbl_spravna);
        dv_test_otazka_spravna_odpoved.Controls.Add(ddl_spravna);
        dv_test_otazka.Controls.Add(dv_test_otazka_spravna_odpoved);
        string[] items = {"odpoveď č.1", "odpoveď č.2",
            "odpoveď č.3", "odpoveď č.4"};
        ddl_spravna.DataSource = items;
        ddl_spravna.DataBind();
        ddl_spravna.EnableViewState = true;
        panel_otazky.ContentTemplateContainer.Controls.Add(dv_test_otazka);
    }

    protected void btn_pridaj_otazku_Click(object sender, EventArgs e) {
        pridaj_otazku(pocet_otazok + 2);
        pocet_otazok++;
        ViewState["pocet_otazok"] = pocet_otazok.ToString();
    }

    protected void btn_uloz_test_Click(object sender, EventArgs e) {
        if (!validne_kategorie()) {
        }
        int idcko_test;
        try {
            idcko_test = tbl_testy.Max(c => c.test_id);
            idcko_test++;
        }
        catch (Exception ex) {
            idcko_test = 1;
        }
        string user = User.Identity.Name;
        test novy_test = new test();
        novy_test.test_id = idcko_test;
        novy_test.title = tb_test_nazov.Text;
        novy_test.description = tb_test_popis.Text;
        novy_test.links = null;
        novy_test.user_name = user;
        novy_test.url = "~/main/test.aspx?id=" + idcko_test;
        tbl_testy.InsertOnSubmit(novy_test);
        TextBox tb = null;
        string question_id = null;
        string spravna_id = null;
        string answer_id = null;
        int idcko_question;
        try {
            idcko_question = tbl_question.Max(c => c.question_id);
        }
        catch (Exception ex) {
            idcko_question = 0;
        }
        for (int i = 1; i <= pocet_otazok + 1; i++) {
            idcko_question++;
            question_id = "tb_otazka_" + i.ToString();
            tb = (TextBox)obsah_control.FindControl(question_id);
            question new_q = new question();
            new_q.title = tb.Text;
            new_q.text = null;
            new_q.user_name = user;
            new_q.help = null;
            tbl_question.InsertOnSubmit(new_q);
            TestQuestionRelation tq_relation = new TestQuestionRelation();
            tq_relation.test_id = idcko_test;
            tq_relation.question_id = idcko_question;
            tbl_tqrel.InsertOnSubmit(tq_relation);
            spravna_id = "ddl_spravna_odpoved_" + i.ToString();
            DropDownList ddl = (DropDownList)obsah_control.FindControl(spravna_id);
            for (int j = 1; j <= 4; j++) {
                answer_id = "tb_odpoved_" + i.ToString()
                    + "_" + j.ToString();
                tb = (TextBox)obsah_control.FindControl(answer_id);
                answer new_a = new answer();
                new_a.text = tb.Text;
                new_a.question_id = idcko_question;
                new_a.help = null;
                if (ddl.SelectedIndex == (j - 1)) {
                    new_a.correct = true;
                }
                else {
                    new_a.correct = false;
                }
                tbl_answer.InsertOnSubmit(new_a);
            }
            // vytvaram na pevno do kat, 1.
            for (int index = 0; index < chbl_kategorie.Items.Count; index++) {
                if (chbl_kategorie.Items[index].Selected) {
                    CategoryTestRelation new_r = new CategoryTestRelation();
                    new_r.test_id = idcko_test;
                    new_r.category_id = int.Parse(chbl_kategorie.Items[index].Value); 
                    tbl_ctrel.InsertOnSubmit(new_r);
                }
            }
        }
        try {
            db.SubmitChanges(ConflictMode.ContinueOnConflict);
        }
        catch (ChangeConflictException ex) {
            lt_validacia.Text = ex.Message;
        }
        catch (DuplicateKeyException ex) {
            lt_validacia.Text = ex.Message;
        }
        catch (SqlException ex) {
            lt_validacia.Text = ex.Message;
        }
        lt_validacia.Text = "TEST USPESNE VYTVORENY !!!";
    }

    protected void btn_zobraz_id_Click(object sender, EventArgs e) {
        DropDownList ddl = (DropDownList)obsah_control.FindControl("ddl_spravna_odpoved_1");
        lt_validacia.Text = ddl.SelectedItem.Value;
    }

    private  bool validne_kategorie() {
        int pocet = 0;
        for (int i = 0; i < chbl_kategorie.Items.Count; i++) {
            if (chbl_kategorie.Items[i].Selected) {
                pocet++;
            }
        }
        if (pocet > 0) {
            return true;
        }
        return false;
    }


    void validna_otazka(object source, ServerValidateEventArgs e) {

    }
}

