﻿using System;
using System.Collections.Generic;
using System.Data.Linq;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class main_test : System.Web.UI.Page {

    private NorthwindDataContext db = new NorthwindDataContext();
    private Table<test> tbl_test = null;
    private Table<question> tbl_question = null;
    private Table<CategoryTestRelation> tbl_ctrel = null;
    private Table<TestQuestionRelation> tbl_tqrel = null;
    private Table<answer> tbl_answer = null;
    private int id = 0;
    private test test = null;

    protected void Page_Init(object sender, EventArgs e) {
        //adding CSS style file
        HtmlLink newCSS = new HtmlLink();
        newCSS.Href = "~/css/testy_style.css";
        newCSS.Attributes.Add("type", "text/css");
        newCSS.Attributes.Add("rel", "Stylesheet");
        Page.Header.Controls.Add(newCSS);
        //create tables
        this.tbl_test = db.tests;
        this.tbl_question = db.questions;
        this.tbl_ctrel = db.CategoryTestRelations;
        this.tbl_tqrel = db.TestQuestionRelations;
        this.tbl_answer = db.answers;
    }

    protected void Page_Load(object sender, EventArgs e) {
        if (!Page.IsPostBack) {
            //getting test ID to by shown
            try {
                id = int.Parse(Request.QueryString["id"]);
                ViewState["id"] = id;
                this.test = 
                    (from t in tbl_test
                    where t.test_id == id
                    select t).SingleOrDefault();
                if (this.test == null)
                    throw new ArgumentNullException();
                IList<question> questions = 
                    (from rel in tbl_tqrel
                    where rel.test_id == this.test.test_id
                    from q in tbl_question
                    where q.question_id == rel.question_id
                    select q).ToList();
                //IList<int> spravne_odpovede = new List<int>();
                IList<Otazka> otazky = new List<Otazka>();
                int pom = 1;
                string poradie;
                foreach(question q in questions){
                    List<answer> odp =
                        (from a in tbl_answer
                        where a.question_id == q.question_id
                        select a).ToList();
                    if(odp.Count() != 4){
                        // TODO otazka ma viac ako 4 odpovede! PRECO ???
                    }
                    //foreach (answer a in odp) {
                    //    if (a.correct) {
                    //        spravne_odpovede.Add(a.answer_id);
                    //    }
                    //}
                    poradie = pom.ToString() + ")";
                    Otazka ot = new Otazka(q.title, odp, poradie);
                    otazky.Add(ot);
                    pom++;
                    //save corrent answer into ViewState

                }
                dl_otazky.DataSource = otazky;
                dl_otazky.DataBind();
                lbl_test_title.Text = this.test.title;
                lt_test_text.Text = this.test.description;
            }
            catch (ArgumentNullException ex) {
                // TODO solve redirecting if no test_id matching ID in request
            }
            catch (FormatException ex) {
                // TODO solve redirecting if no test_ID has been sent by request
            }
            catch (OverflowException ex) {
                // TODO solve redirecting if no test_ID has been sent by request
            }
            // fill test controls
        }
        if (ViewState["id"] != null) {
            this.id = int.Parse(ViewState["id"].ToString());
        }
    }

    protected void btn_vyhodnot_Click(Object sender, EventArgs e) {
        int pocet_spravnych = 0;
        List<int> otazky_id =
            (from rel in tbl_tqrel
             where rel.test_id == this.id
             select rel.question_id).ToList();
        List<int> spravne = new List<int>();
        foreach (int i in otazky_id) {
            try {
                var spravna_id =
                    (from a in tbl_answer
                     where a.question_id == i
                     where a.correct
                     select a.answer_id).Single();
                spravne.Add(spravna_id);
            }
            catch (ArgumentNullException ex) {
                // musi mat otazka aspon jednu spravny odpoved !
                // TODO co teraz ?
            }
        }
        int selected = 0;
        foreach (DataListItem item in dl_otazky.Items) {
            RadioButtonList rbl = (RadioButtonList)item.FindControl("moznosti");
            if (rbl == null) {
                throw new ArgumentNullException();
            }
            try {
                selected = int.Parse(rbl.SelectedValue);
                if (spravne.Contains(selected)) {
                    pocet_spravnych++;
                }
                else {
                    // NESPRAVNA!!

                }
            }
            catch(Exception ex) {
                //TODO nieje oznaceny radiobuttonlist, vadi to?    
            }
        }
        Label1.Text = "Pocet spravnych je: " + pocet_spravnych.ToString()
            + " z " + otazky_id.Count;
        
    }

}

