using System;
using System.Data;
using System.Data.Linq;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;
using System.Linq;

public partial class testy : System.Web.UI.Page {

    private NorthwindDataContext db = new NorthwindDataContext();
    private Table<test> ttesty = null;
    private Table<CategoryTestRelation> tbl_ctrel = null;
    private Table<TestQuestionRelation> tbl_tqrel = null;
    private Table<category> kategorie = null;
    private Table<aspnet_User> uzivatelia = null;

    protected void Page_Init(object sender, EventArgs e) {
        //adding CSS style file
        HtmlLink newCSS = new HtmlLink();
        newCSS.Href = "~/css/testy_style.css";
        newCSS.Attributes.Add("type", "text/css");
        newCSS.Attributes.Add("rel", "stylesheet");
        Page.Header.Controls.Add(newCSS);
        HtmlLink newCSS2 = new HtmlLink();
        newCSS2.Href = "~/css/pager_style.css";
        newCSS2.Attributes.Add("type", "text/css");
        newCSS2.Attributes.Add("rel", "stylesheet");
        Page.Header.Controls.Add(newCSS2);
        HtmlLink newCSS3 = new HtmlLink();
        newCSS3.Href = "~/css/filters_style.css";
        newCSS3.Attributes.Add("type", "text/css");
        newCSS3.Attributes.Add("rel", "Stylesheet");
        Page.Header.Controls.Add(newCSS3);
        //create tables
        this.ttesty = db.tests;
        this.kategorie = db.categories;
        this.tbl_ctrel = db.CategoryTestRelations;
        this.tbl_tqrel = db.TestQuestionRelations;
        this.uzivatelia = db.aspnet_Users;
    }

    protected void Page_Load(object sender, EventArgs e) {
        if (!Page.IsPostBack) {
            Load_Checklists_Tests();
            Load_All_Checkboxes();
            //write all test without any filter applying
            var out_testy =
                from t in db.tests
                let link = "~/main/test.aspx?id=" + t.test_id
                select new { url = link, title = t.title, description = t.description };
            lw_testy.DataSource = out_testy;
            lw_testy.DataBind();
        }
    }

    protected void lw_testy_pager_changing(object sender, PagePropertiesChangingEventArgs e) {
        this.DataPager1.SetPageProperties(e.StartRowIndex, e.MaximumRows, false);
        applyTestsFilters();
        //var out_testy =
        //    from t in db.tests
        //    let link = "~/main/test.aspx?id=" + t.test_id
        //    select new { url = link, title = t.title, description = t.description };
        //lw_testy.DataSource = out_testy;
        //lw_testy.DataBind();
    }

    private void Load_All_Checkboxes() {
        chb_user_all.Text = "vetci";
        chb_user_all.Checked = true;
        chb_user_all.EnableViewState = true;
        chb_cat_all.Text = "vetky";
        chb_cat_all.EnableViewState = true;
        chb_cat_all.Checked = true;
    }

    private void Load_Checklists_Tests() {
        var users =
            (from t in db.tests
             select new {
                 user_name = t.user_name
             }).Distinct();
        chb_user.DataSource = users;
        chb_user.DataTextField = "user_name";
        chb_user.DataValueField = "user_name";
        chb_user.DataBind();
        var cats =
            (from t in db.tests
             from rel in db.CategoryTestRelations
             where t.test_id == rel.test_id
             select new {
                 cat_title = rel.category.title,
                 cat_id = rel.category_id
             }).Distinct();
        chb_cat.DataSource = cats;
        chb_cat.DataTextField = "cat_title";
        chb_cat.DataValueField = "cat_id";
        chb_cat.DataBind();
        //zaskrtni vsetky
        setCheckedAll(chb_cat, true);
        setCheckedAll(chb_user, true);
        //for (int i = 0; i < chb_user.Items.Count; i++) {
        //    chb_user.Items[i].Selected = true;
        //}
        //for (int i = 0; i < chb_cat.Items.Count; i++) {
        //    chb_cat.Items[i].Selected = true;
        //}
    }

    private void setCheckedAll(CheckBoxList _list, bool _checked) {
        for (int i = 0; i < _list.Items.Count; i++) {
            _list.Items[i].Selected = _checked;
        }
    }

    protected void chb_user_all_Changed(object sender, EventArgs e) {
        if (chb_user_all.Checked) {
            setCheckedAll(this.chb_user, true);
        }
        else {
            setCheckedAll(this.chb_user, false);
        }
        applyTestsFilters();
    }

    protected void chb_cat_all_Changed(object sender, EventArgs e) {
        if (chb_cat_all.Checked) {
            setCheckedAll(this.chb_cat, true);
        }
        else {
            setCheckedAll(this.chb_cat, false);
        }
        applyTestsFilters();
    }

    protected void chb_user_SelectedIndexChanged(object sender, EventArgs e) {
        bool vsetky = true;
        foreach (ListItem c in chb_user.Items) {
            if (c.Selected) {
                //este neviem co
            }
            else {
                vsetky = false;
            }
        }
        chb_user_all.Checked = vsetky;
        applyTestsFilters();
    }

    protected void chb_cat_SelectedIndexChanged(object sender, EventArgs e) {
        bool vsetky = true;
        foreach (ListItem c in chb_cat.Items) {
            if (c.Selected) {
                //nieco
            }
            else {
                vsetky = false;
            }
        }
        chb_cat_all.Checked = vsetky;
        applyTestsFilters();
    }

    private void applyTestsFilters() {
        List<string> user_list = new List<string>();
        foreach (ListItem item in chb_user.Items) {
            if (item.Selected) {
                user_list.Add(item.Value);
            }
        }
        List<string> cat_list = new List<string>();
        foreach (ListItem item in chb_cat.Items) {
            if (item.Selected) {
                cat_list.Add(item.Value);
            }
        }
        List<test> pom =
            (from t in db.tests
             select t).ToList();
        List<test> pom_out = new List<test>();
        foreach (test t in pom) {
            if (userListContainsIt(user_list, t.user_name) &&
                atLeastOneCategory(cat_list, t.test_id)) {
                pom_out.Add(t);
            }
        }
        List<TestUkazka> final_list =
            (from a in pom_out
             select new TestUkazka(
                a.url,
                a.title,
                a.description,
                a.photo.path
             )).ToList();
        lw_testy.DataSource = final_list;
        lw_testy.DataBind();
    }

    private bool userListContainsIt(List<string> list, string s) {
        if (!chb_user_all.Checked && !list.Contains(s)) {
            return false;
        }
        return true;
    }

    private bool atLeastOneCategory(List<string> list, int test_id) {
        if (chb_cat_all.Checked) {
            return true;
        }
        List<category> all =
            (from rel in db.CategoryTestRelations
             where rel.test_id == test_id
             select rel.category).ToList();
        List<category> list_out = new List<category>();
        foreach (category c in all) {
            if (catListContainsIt(list, c.category_id)) {
                list_out.Add(c);
            }
        }
        if (list_out.Count > 0) {
            return true;
        }
        return false;
    }

    private bool catListContainsIt(List<string> list, int id) {
        if (!chb_cat_all.Checked && !list.Contains(id.ToString())) {
            return false;
        }
        return true;
    }

}

public class TestUkazka {

    private string _url;
    private string _title;
    private string _description;
    private string _path;

    public string url {
        get { return _url; }
        set { _url = value; }
    }

    public string title {
        get { return _title; }
        set { _title = value; }
    }

    public string description {
        get { return _description; }
        set { _description = value; }
    }

    public string path {
        get { return _path; }
        set { _path = value; }
    }

    public TestUkazka(string u, string t, string d, string p) {
        this._url = u;
        this._title = t;
        this._description = d;
        this._path = p;
    }

}

