<?
/* AdminProcess.php
 * spracovanie submitnutych formularov z admin centra
 */
include("../include/session.php");

class AdminProcess
{
   /* konstruktor */
   function AdminProcess(){
      global $session;
      /* ci je admin */
      if(!$session->isAdmin()){
         header("Location: ../index.php");
         return;
      }
      /* zmena user levelu */
      if(isset($_POST['subupdlevel'])){
         $this->procUpdateLevel();
      }
      /* vymazanie uzivatela */
      else if(isset($_POST['subdeluser'])){
         $this->procDeleteUser();
      }
      /* ban uzivatela */
      else if(isset($_POST['subbanuser'])){
         $this->procBanUser();
      }
      /* vymaz zabanovaneho uzivatela */
      else if(isset($_POST['subdelbanned'])){
         $this->procDeleteBannedUser();
      }
      /* presmerovanie */
      else{
         header("Location: ../index.php");
      }
   }

   /* procUpdateLevel - upravenie user levelu */
   function procUpdateLevel(){
      global $session, $database, $form;
      /* kontrola username */
      $subuser = $this->checkUsername("upduser");
      
      /* su chyby */
      if($form->num_errors > 0){
         $_SESSION['value_array'] = $_POST;
         $_SESSION['error_array'] = $form->getErrorArray();
         header("Location: admin.php");
      }
      /* uprav user level */
      else{
         $database->updateUserField($subuser, "userlevel", (int)$_POST['updlevel']);
         header("Location: admin.php");
      }
   }
   
   /* procDeleteUser - zmazanie uzivatela */
   function procDeleteUser(){
      global $session, $database, $form;
      /* kontrola username */
      $subuser = $this->checkUsername("deluser");
      
      /* su chyby */
      if($form->num_errors > 0){
         $_SESSION['value_array'] = $_POST;
         $_SESSION['error_array'] = $form->getErrorArray();
         header("Location: admin.php");
      }
      /* vymaz uzivatela z db */
      else{
         $q = "DELETE FROM ".TBL_USERS." WHERE username = '$subuser'";
         $database->query($q);
         header("Location: admin.php");
      }
   }
   
   /* procBanUser - zabanovanie uzivatela (vymaze username z tabulky uzivatelov
    * a da ho do tabulky zabanovanych)
    */
   function procBanUser(){
      global $session, $database, $form;
      /* kontrola username */
      $subuser = $this->checkUsername("banuser");
      
      /* su chyby */
      if($form->num_errors > 0){
         $_SESSION['value_array'] = $_POST;
         $_SESSION['error_array'] = $form->getErrorArray();
         header("Location: admin.php");
      }
      /* zabanuj uzivatela */
      else{
         $q = "DELETE FROM ".TBL_USERS." WHERE username = '$subuser'";
         $database->query($q);

         $q = "INSERT INTO ".TBL_BANNED_USERS." VALUES ('$subuser', $session->time)";
         $database->query($q);
         header("Location: admin.php");
      }
   }
   
   /* procDeleteBannedUser - vymaze zabanovaneho uzivatela */
   function procDeleteBannedUser(){
      global $session, $database, $form;
      /* kontrola username */
      $subuser = $this->checkUsername("delbanuser", true);
      
      /* su chyby */
      if($form->num_errors > 0){
         $_SESSION['value_array'] = $_POST;
         $_SESSION['error_array'] = $form->getErrorArray();
         header("Location: admin.php");
      }
      /* zmaz uzivatela z db */
      else{
         $q = "DELETE FROM ".TBL_BANNED_USERS." WHERE username = '$subuser'";
         $database->query($q);
         header("Location: admin.php");
      }
   }
   
   /* checkUsername - kontrola ci je username validne */
   function checkUsername($uname, $ban=false){
      global $database, $form;
      /* kontrola username */
      $subuser = $session->checkVar($_POST[$uname],true);
      $field = $uname;  
      if(!$subuser || strlen($subuser = trim($subuser)) == 0){
         $form->setError($field, "* Username not entered<br>");
      }
      else{
         /* kontrola, ci je username v db */
         $subuser = stripslashes($subuser);
         if(strlen($subuser) < 5 || strlen($subuser) > 30 ||
            !eregi("^([0-9a-z])+$", $subuser) ||
            (!$ban && !$database->usernameTaken($subuser))){
            $form->setError($field, "* Username does not exist<br>");
         }
      }
      return $subuser;
   }
};

/* inicializacia */
$adminprocess = new AdminProcess;

?>
