<?
/* GrAdminProcess.php
 * spracovanie submitnutych formularov z group admin centra
 */
include("../include/session.php");

class GrAdminProcess
{
   /* konstruktor */
   function GrAdminProcess(){
      global $session;
      /* ci je admin */
      if(!$session->hasGroupUserlevel($session->checkVar($_SESSION['username']), $session->checkVar($_POST['subgrid'],true), 9)){
         header("Location: gradmin.php?grid=".htmlentities($_POST['subgrid']));
      }
      if(isset($_POST['subupdlevel'])){
          $this->procUpdateLevel();
          header("Location: gradmin.php?grid=".htmlentities($_POST['subgrid']));
      }
      /* zmena user levelu */
      if(isset($_POST['allow']) || isset($_POST['deny'])){
         $this->procDealRequest();
      }
      /* vymazanie uzivatela */
      else if(isset($_POST['subdeluser'])){
         $this->procDeleteUser();
      }
      /* presmerovanie */
      else{
         header("Location: ../index.php");
      }
   }

   /* procUpdateLevel - upravenie user levelu */
   function procUpdateLevel(){
      global $session, $database, $form;

      /* kontrola username */

      $subuser = $this->checkUsername("upduser");
      /* su chyby */
      if($form->num_errors > 0){
         $_SESSION['value_array'] = $_POST;
         $_SESSION['error_array'] = $form->getErrorArray();
         header('Location: gradmin.php?grid='.htmlentities($_POST['subgrid']));
      }
      /* uprav user level */
      else{
         $database->updateGroupUserField($subuser, $_POST['subgrid'], "gruserlevel", (int)$_POST['updlevel']);
         header('Location: gradmin.php?grid='.htmlentities($_POST['subgrid']));
      }
   }

   /* procDealRequest - prijate, odmietnutie requestu */
   function procDealRequest(){
      global $session, $database;
      if (isset($_POST['allow'])) {
          $database->acceptRequest($session->checkVar($_POST['subuname'],true),$session->checkVar($_POST['subgrid'],true));
      } else {
          $database->denyRequest($session->checkVar($_POST['subuname'],true),$session->checkVar($_POST['subgrid'],true));
      }
         header('Location: gradmin.php?grid='.htmlentities($_POST['subgrid']));
   }
   /* procDeleteUser - zmazanie uzivatela */
   function procDeleteUser(){
      global $session, $database, $form;
      /* kontrola username */
      $subuser = $this->checkUsername("deluser");
      
      /* su chyby */
      if($form->num_errors > 0){
         $_SESSION['value_array'] = $_POST;
         $_SESSION['error_array'] = $form->getErrorArray();
         header('Location: gradmin.php?grid='.htmlentities($_POST['subgrid']));
      }
      /* vymaz uzivatela z db */
      else{
         $q = "DELETE FROM groupusers WHERE username = '$subuser' and grid = '$grid'";
         $database->query($q);
         header('Location: gradmin.php?grid='.htmlentities($_POST['subgrid']));
      }
   }
   

   
   /* checkUsername - kontrola ci je username validne */
   function checkUsername($uname){
      global $database, $form, $session;
      /* kontrola username */
      $subuser = $session->checkVar($_POST['upduser'],true);
      $field = $uname;  
      if(!$subuser || strlen($subuser = trim($subuser)) == 0){
         $form->setError($field, "* Username not entered<br>");
      }
      else{
         /* kontrola, ci je username v db */
         $subuser = stripslashes($subuser);
         if(strlen($subuser) < 5 || strlen($subuser) > 30 ||
            !eregi("^([0-9a-z])+$", $subuser) ||
            (!$database->confirmGroupUser($subuser,$session->checkVar($_POST['subgrid'])))){
            $form->setError($field, "* Username does not exist<br>");
         }
      }
      return $subuser;
   }
};

/* inicializacia */
$gradminprocess = new GrAdminProcess;

?>
