<?
/**
 * Session.php
 */
include("database.php");
include("form.php");

class Session
{
   var $username;     //username uzivatela pri registracii
   var $userid;       //nahodna hodnota generovana pri prihlaseni
   var $userlevel;    //level uzivatela - admin, user, guest
   var $time;         //cas, kedy sa loadla stranka
   var $logged_in;    //true ak je user prihlaseny
   var $userinfo = array();  //pole s komplet user infom
   var $url;          //prave prehliadana stranka

   /* konstruktor */
   function Session(){
      $this->time = time();
      $this->startSession();
   }

   /* nastartuje session, ponahadzuje premenne
    */
   function startSession(){
      global $database;  //pripojenie do db
      session_start();   

      /* zisti ci je user lognuty */
      $this->logged_in = $this->checkLogin();

      /* ak neni lognuty, tak nastav ako guesta  */
      if(!$this->logged_in){
         $this->username = $_SESSION['username'] = GUEST_NAME;
         $this->userlevel = GUEST_LEVEL;
      }

      /* nastavi adresu */
      $this->url = $_SESSION['url'] = $_SERVER['PHP_SELF'];
   }

   /* checkLogin - kontrola prihlasenia, ci je vytvorena user session, ci bolo cookie,
    * ci je prihlasenie autenticke. vracia true ak je uzivatel prihlaseny.
    */
   function checkLogin(){
      global $database;  
      /* kontrola, ci je user zapamatany */
      if(isset($_COOKIE['cookname']) && isset($_COOKIE['cookid'])){
         $this->username = $_SESSION['username'] = $this->checkVar($_COOKIE['cookname'],true);
         $this->userid   = $_SESSION['userid']   = $this->checkVar($_COOKIE['cookid'],true);
      }

      /* username a userid je nastavene a nie je guest */
      if(isset($_SESSION['username']) && isset($_SESSION['userid']) &&
         $_SESSION['username'] != GUEST_NAME){
         /* ak username sedi s userid */
         if($database->confirmUserID($this->checkVar($_SESSION['username']), $this->checkVar($_SESSION['userid'])) != 0){
            /* ak nesedi, uzivatel nie je prihlaseny */
            unset($_SESSION['username']);
            unset($_SESSION['userid']);
            return false;
         }

         /* uzivatel je prihlaseny, nastav premenne */
         $this->userinfo  = $database->getUserInfo($this->checkVar($_SESSION['username']));
         $this->username  = $this->userinfo['username'];
         $this->userid    = $this->userinfo['userid'];
         $this->userlevel = $this->userinfo['userlevel'];
         return true;
      }
      /* uzivatel nie je prihlaseny */
      else{
         return false;
      }
   }

   /* login - pokial user zadal username a heslo, funkcia ich overi
    * proti databaze a vytvori session, prihlasi pouzivatela
    */
   function login($subuser, $subpass, $subremember){
      global $database, $form;  

      /* kontrola chyby v username */
      $field = "user";  //meno pre pole (kvoli erroru)
      if(!$subuser || strlen($subuser = trim($subuser)) == 0){
         $form->setError($field, "* nezadali ste username");
      }
      else{
         /* kontrola, ci je username alfanumericke */
         if(!eregi("^([0-9a-z])*$", $subuser)){
            $form->setError($field, "* Username nie je alfanumericke");
         }
      }

      /* kontrola chyby v hesle */
      $field = "pass";  
      if(!$subpass){
         $form->setError($field, "* nezadali ste heslo");
      }
      
      /* ak su errory, tak sa vrat */
      if($form->num_errors > 0){
         return false;
      }

      /* kontrola, ci je username v db a heslo sedi */
      $subuser = stripslashes($subuser);
      $result = $database->confirmUserPass($subuser, md5($subpass));

      /* kontrola na result */
      if($result == 1){
         $field = "user";
         $form->setError($field, "* username nenajdene");
      }
      else if($result == 2){
         $field = "pass";
         $form->setError($field, "* nespravne heslo");
      }
      
      /* navrat ak error */
      if($form->num_errors > 0){
         return false;
      }

      /* username a heslo su ok, nastav session premenne */
      $this->userinfo  = $database->getUserInfo($subuser);
      $this->username  = $_SESSION['username'] = $this->userinfo['username'];
      $this->userid    = $_SESSION['userid']   = $this->generateRandID();
      $this->userlevel = $this->userinfo['userlevel'];
      
      /* vloz userid do db */
      $database->updateUserField($this->username, "userid", $this->userid);


      /* cookies, pre username a pre userid */
      if($subremember){
         setcookie("cookname", $this->username, time()+COOKIE_EXPIRE, COOKIE_PATH);
         setcookie("cookid",   $this->userid,   time()+COOKIE_EXPIRE, COOKIE_PATH);
      }

      /* login uspesny */
      return true;
   }

   /* logout - pokial sa uzivatel chce odhlasit, vymaze cookies,
    * vymaze session premenne, nastavi guest userlevel */
   function logout(){
      global $database; 
      /* zmazanie cookies */
      if(isset($_COOKIE['cookname']) && isset($_COOKIE['cookid'])){
         setcookie("cookname", "", time()-COOKIE_EXPIRE, COOKIE_PATH);
         setcookie("cookid",   "", time()-COOKIE_EXPIRE, COOKIE_PATH);
      }

      /* zmazanie premennych */
      unset($_SESSION['username']);
      unset($_SESSION['userid']);

      /* zmena hlavnej premennej */
      $this->logged_in = false;
      
      
      /* nastav guest userlevel */
      $this->username  = GUEST_NAME;
      $this->userlevel = GUEST_LEVEL;
   }

   /* register - pokial uzivatel submitol registracny
    * formular, vyhodnoti chyby, ak su tak vrati 1, ak
    * je reg. uspesna, vrati 0, ak nie tak 2 */
   function register($subuser, $subpass, $subemail){
      global $database, $form;  
      
      /* kontrola username */
      $field = "user";  
      if(!$subuser || strlen($subuser = trim($subuser)) == 0){
         $form->setError($field, "* nezadali ste Username");
      }
      else{
         /* kontrola na dlzku */
         $subuser = stripslashes($subuser);
         if(strlen($subuser) < 5){
            $form->setError($field, "* username prilis kratke (najmenej 6 znakov)");
         }
         else if(strlen($subuser) > 30){
            $form->setError($field, "* username prilis dlhe (najviac 30 znakov)");
         }
         /* kontrola, ci su pouzite len alfanumericke znaky */
         else if(!eregi("^([0-9a-z])+$", $subuser)){
            $form->setError($field, "* username nie je alfanumericke");
         }
         /* kontrola, ci nie je rovnaky username ako pre guesta */
         else if(strcasecmp($subuser, GUEST_NAME) == 0){
            $form->setError($field, "* username sa uz pouziva");
         }
         /* kontrola, ci sa username uz nepouziva */
         else if($database->usernameTaken($subuser)){
            $form->setError($field, "* username sa uz pouziva");
         }
         /* kontrola, ci username nie je zabanovane */
         else if($database->usernameBanned($subuser)){
            $form->setError($field, "* username je zabanovane");
         }
      }

      /* kontrola hesla */
      $field = "pass";  
      if(!$subpass){
         $form->setError($field, "* nezadali ste heslo");
      }
      else{
         /* kontrola dlzky hesla */
         $subpass = stripslashes($subpass);
         if(strlen($subpass) < 4){
            $form->setError($field, "* heslo prilis kratke");
         }
         /* kontrola alfanumerickosti hesla */
         else if(!eregi("^([0-9a-z])+$", ($subpass = trim($subpass)))){
            $form->setError($field, "* heslo nie je alfanumericke");
         }
      }
      
      /* kontrola emailu */
      $field = "email";  
      if(!$subemail || strlen($subemail = trim($subemail)) == 0){
         $form->setError($field, "* nezadali ste email");
      }
      else{
         /* kontrola, ci je v spravnom formate mail */
         $regex = "^[_+a-z0-9-]+(\.[_+a-z0-9-]+)*"
                 ."@[a-z0-9-]+(\.[a-z0-9-]{1,})*"
                 ."\.([a-z]{2,}){1}$";
         if(!eregi($regex,$subemail)){
            $form->setError($field, "* nespravny email");
         }
         $subemail = stripslashes($subemail);
      }

      /* ked su errory, tak sa vrat */
      if($form->num_errors > 0){
         return 1;  
      }
      /* ked nie su errory, pridaj noveho pouzivatela */
      else{
         if($database->addNewUser($subuser, md5($subpass), $subemail)){
            return 0;  //uspesne pridany
         }else{
            return 2;  //pridanie zlyhalo
         }
      }
   }
   
   /* editAccount - uprava accountu */
   function editAccount($subcurpass, $subnewpass, $subemail){
      global $database, $form;  
      /* zadane nove heslo */
      if($subnewpass){
         /* kontrola sucasneho hesla */
         $field = "curpass";  
         if(!$subcurpass){
            $form->setError($field, "* nezdali ste Vase sucasne heslo");
         }
         else{
            /* kontrola, ci ma heslo dobry format a je dost dlhe */
            $subcurpass = stripslashes($subcurpass);
            if(strlen($subcurpass) < 4 ||
               !eregi("^([0-9a-z])+$", ($subcurpass = trim($subcurpass)))){
               $form->setError($field, "* sucasne heslo nespravne");
            }
            /* chybne heslo */
            if($database->confirmUserPass($this->username,md5($subcurpass)) != 0){
               $form->setError($field, "* sucasne heslo nespravne");
            }
         }
         
         /* kontrola noveho hesla*/
         $field = "newpass";  
         /* kontrola, ci ma heslo dobry format a je dost dlhe*/
         $subpass = stripslashes($subnewpass);
         if(strlen($subnewpass) < 4){
            $form->setError($field, "* nove heslo je prilis kratke");
         }
         /* kontrola alfanumerickosti hesla */
         else if(!eregi("^([0-9a-z])+$", ($subnewpass = trim($subnewpass)))){
            $form->setError($field, "* nove heslo nie je alfanumericke");
         }
      }
      /* pokus o zmenu hesla */
      else if($subcurpass){
         $field = "newpass"; 
         $form->setError($field, "* nezadali ste nove heslo");
      }
      
      /* kontrola emailu */
      $field = "email";  
      if($subemail && strlen($subemail = trim($subemail)) > 0){
         /* kontrola, ci je email v spravnom formate */
         $regex = "^[_+a-z0-9-]+(\.[_+a-z0-9-]+)*"
                 ."@[a-z0-9-]+(\.[a-z0-9-]{1,})*"
                 ."\.([a-z]{2,}){1}$";
         if(!eregi($regex,$subemail)){
            $form->setError($field, "* nespravny email");
         }
         $subemail = stripslashes($subemail);
      }
      
      /* ak existuju chyby, vrat sa aj s vypisom */
      if($form->num_errors > 0){
         return false;  
      }
      
      /* update hesla */
      if($subcurpass && $subnewpass){
         $database->updateUserField($this->username,"password",md5($subnewpass));
      }
      
      /* zmena mailu */
      if($subemail){
         $database->updateUserField($this->username,"email",$subemail);
      }
      
      return true;
   }
   
   /*isAdmin - vracia true, ak je prihlaseny globalny admin */
   function isAdmin(){
      return ($this->userlevel == ADMIN_LEVEL ||
              $this->username  == ADMIN_NAME);
   }
   
   /* generateRandID - generuje md5 hash pre userid zo stringu */
   function generateRandID(){
      return md5($this->generateRandStr(16));
   }
   
   /* generateRandStr - generuje nahodny string */
   function generateRandStr($length){
      $randstr = "";
      for($i=0; $i<$length; $i++){
         $randnum = mt_rand(0,61);
         if($randnum < 10){
            $randstr .= chr($randnum+48);
         }else if($randnum < 36){
            $randstr .= chr($randnum+55);
         }else{
            $randstr .= chr($randnum+61);
         }
      }
      return $randstr;
   }


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////            CAST PRE PRACU SO SKUPINAMI                            ///////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

 /* register - pokial uzivatel submitol registracny
    * formular, vyhodnoti chyby, ak su tak vrati 1, ak
    * je reg. uspesna, vrati 0, ak nie tak 2 */
   function grregister($subgrname, $subgrtheme, $subusername){
      global $database, $form;

      /* kontrola username */
      $field = "grname";
      if(!$subgrname || strlen($subgrname = trim($subgrname)) == 0){
         $form->setError($field, "* Nezadali ste nazov skupiny");
      }
      else{
         /* kontrola na dlzku */
         $subgrname = stripslashes($subgrname);
         if(strlen($subgrname) < 3){
            $form->setError($field, "* nazov skupiny musi byt dlhsi ako 3 znaky");
         }
         else if(strlen($subgrname) > 30){
            $form->setError($field, "* nazov skupiny nesmie byt dlhsi ako 30 znakov");
         }
         /* kontrola, ci su pouzite len alfanumericke znaky */
         else if(!eregi("^([0-9a-z ])+$", $subgrname)){
            $form->setError($field, "* nazov skupiny smie obsahovat iba znaky a-Z a cislice 0-9");
         }
//         /* kontrola, ci sa nazov skupiny uz nepouziva */
//         else if($database->grnameTaken($subgrname)){
//            $form->setError($field, "* nazov skupiny sa uz pouziva");
//         }
      }

      /* ked su errory, tak sa vrat */
      if($form->num_errors > 0){
         return 1;
      }
      /* ked nie su errory, pridaj novu skupinu */
      else{
         if($database->addNewGroup($subgrname, $subgrtheme, $subusername)){
            return 0;  //uspesne pridany
         }else{
            return 2;  //pridanie zlyhalo
         }
      }
   }

   function hasGroupUserlevel($username, $grid, $userlevel){
      global $database;
      if($database->hasGUL($username, $grid, $userlevel)) {
         return true;
      } else {
         return false; //nema taky userlevel
      }
   }





   function checkVar($var,$gpc = false) {
        if ($gpc && get_magic_quotes_gpc())
              return $var;
        return mysql_real_escape_string($var);
    }
};
/* inicializacia session */
$session = new Session;

/* inicializacia formu */
$form = new Form;

?>
