<?php
class UzivatelController extends Zend_Controller_Action {
	public function indexAction(){
		$page = $this->_request->getParam('strana');
		if(empty($page))
		$page = 1;
		$uzivatelM = new Model_DbTable_Uzivatel();
		$statement = $uzivatelM->select()->limitPage($page, 10);
		$result = $uzivatelM->fetchAll($statement);
		$paginator = Zend_Paginator::factory($uzivatelM->fetchAll());
		$paginator->setItemCountPerPage(10);
		$paginator->setCurrentPageNumber($page);
		$this->view->paginator=$paginator;
		$this->view->uzivatelia = $result;
	}

	public function loginAction(){
		$registracia = $this->_request->getParam('registracia');
		if(!empty($registracia)){
			$this->_redirect('/uzivatel/registracia');
		}

		$username = $this->_request->getParam('username');
		$password = $this->_request->getParam('password');
		if(empty($username) || empty($password)){
			$this->_redirect('/');
		}

		$user = new Model_DbTable_Uzivatel();
		$DB = $user->getDefaultAdapter();
		$this->_helper->layout()->disableLayout();
		$this->_helper->viewRenderer->setNoRender(true);
		$registry = Zend_Registry::getInstance();
		var_dump($this->_request->getParams());
		$auth = Zend_Auth::getInstance();
		$authAdapter = new Zend_Auth_Adapter_DbTable($DB);
		$authAdapter->setTableName('user')
		->setIdentityColumn('login')
		->setCredentialColumn('password');
		$authAdapter->setIdentity($username);
		$authAdapter->setCredential(md5($password));
			
		$result = $auth->authenticate($authAdapter);
		if($result->isValid()){
			$data = $authAdapter->getResultRowObject(null,'password');
			$auth->getStorage()->write($data);
			$this->_redirect('/uzivatel/info');
		}else{
			$this->_redirect('/');
		}
	}

	public function infoAction(){
		$id = $this->_request->getParam('id');		
		$this->view->ajax = false;
		if($this->_request->isXmlHttpRequest()){
			$this->_helper->layout()->disableLayout();
			$this->view->ajax = true;
		}
		if(!empty($id)){
			$id = $this->_request->getParam('id');
			$uzivatel = new Model_DbTable_Uzivatel();
			$stat = $uzivatel->select()->where('login = ?', $id);
			$this->view->uzivatel = $uzivatel->fetchRow($stat);
		}else{
			$auth = Zend_Auth::getInstance();
			if(!$auth->hasIdentity()){
				$this->_redirect('/uzivatel/login');
			}
			$this->view->uzivatel = $auth->getStorage()->read();
		}
		$this->view->login = $this->view->uzivatel->login;
		if($this->view->uzivatel->profile_id != -1){
			$profil = new Model_DbTable_Profil();
			$statement = $profil->select()->where('id = ?', $this->view->uzivatel->profile_id);
			$profil_info = $profil->fetchRow($statement);
			if(count($profil_info == 1)){
				$this->view->profilExists = true;
				$this->view->profilInfo = $profil_info;
			}else  {
				$this->view->profilExists = false;
			}
		}


	}

	public function registraciaAction(){
		$odosli = $this->_request->getParam('odosli');
		if(!empty($odosli)){
			$login = $this->_request->getParam('login');
			$mail = $this->_request->getParam('mail');
			$icq = $this->_request->getParam('icq');
			$www = $this->_request->getParam('www');
			$name = $this->_request->getParam('name');
			$surname = $this->_request->getParam('surname');
			$info = $this->_request->getParam('info');
			$foto = $this->_request->getParam('foto');
			$password1 = $this->_request->getParam('password1');
			$password2 = $this->_request->getParam('password2');
			$uzivatel = new Model_DbTable_Uzivatel();
			$data = array(
		      'login' => $login,
		      'password' => md5($password1),
		      'mail' => $mail,
		      'date' => new Zend_Db_Expr('NOW()'),
		      'acl_id' => '0',
		      'profile_id' => '-1'		  
		    );
		    $id = null;
		    if(($password1 == $password2) && !empty($mail) && !empty($login)){
		    	$id = $uzivatel->insert($data);
		    	if(!empty($icq) || !empty($www) || !empty($info) || !empty($name)|| !empty($surname)|| !empty($foto)){
					  $profile = new Model_DbTable_Profil();
		    		  $data2 = array('name' => $name, 'surname' => $surname, 'www' => $www, 'info' => $info, 'icq' => $icq);
		    		  $prof_id=$profile->insert($data2);
		    		  $uzivatel->update(array('profile_id' => $prof_id), 'id = '.$id);			    		
					  $upload = new Zend_File_Transfer_Adapter_Http(); 					  
    				  $upload->setDestination('data/users/'); 
    				  //$upload->addValidator('MimeType', false, 'image');
					  $upload->addFilter('Rename',array('target' => 'data/users/'.$login.'.jpg','overwrite' => true));
					  if($upload->isValid()){    				     
      				  	$upload->receive();
					  }else{
					  	$this->_redirect('/');  
					  }  		    				    		  	    
		    	}		    
		    	$this->_redirect('/');
		    }
		    $this->view->mail = $mail;
		    $this->view->login = $login;
		    $this->view->icq = $icq;
		    $this->view->www = $www;
		    $this->view->info = $info;
		    $this->view->name = $name;
		    $this->view->surname = $surname;
		}else{

		}
	}

	public function helperAction(){
		$this->_helper->layout()->disableLayout();
		$auth = Zend_Auth::getInstance();
		if($auth->hasIdentity()){
			$this->view->online = true;
			$info = $auth->getStorage()->read();
			$this->view->info = $info;
		}else{
			$this->view->online = false;
		}
	}

	public function logoutAction(){
		$admin = $this->_request->getParam('admin');
		if(!empty($admin)){
			$this->_redirect('/admin');
		}
		$profil = $this->_request->getParam('profil');
		if(!empty($profil)){
			$this->_redirect('/uzivatel/info');
		}
		$this->_helper->layout()->disableLayout();
		$this->_helper->viewRenderer->setNoRender(true);
		$auth = Zend_Auth::getInstance();
		if($auth->hasIdentity()){
			$auth->clearIdentity();
			$this->_redirect('/');
		}
	}

	public function profilAction(){
		$this->_helper->layout()->disableLayout();

		if(!empty($id)){
			$profil_info = new Model_DbTable_Profil();
			$this->view->profil = $profil_info->fetchRow('where id = '.$id);
		}
	}

	public function ajaxPlaylistAction(){
		$this->_helper->layout()->disableLayout();
	}
	public function ajaxUzivatelAction(){
		$this->_helper->layout()->disableLayout();
	}


	public function zobrazAction(){
		$this->_helper->viewRenderer->setNoRender(true);
		$this->_helper->layout()->disableLayout();
		$id = $this->_request->getParam('id');
		if(!empty($id)){
			$this->_redirect('/uzivatel/info/id/'.$id);
		}
	}
	
	public function playlistAction(){
		$ajax = false;
		$login = $this->_request->getParam('id');
		if(empty($login)){
			$auth = Zend_Auth::getInstance();
			if($auth->hasIdentity()){
				$tmp = $auth->getStorage()->read();
				$login = $tmp->login;				
			}else{
				$this->_redirect('/');
			}
		}
		//zisti ci sa jedna o ajax request, ak ano zrusi layout na vystupe		
		if($this->_request->isXmlHttpRequest()){
			$this->_helper->layout()->disableLayout();
			$ajax = true;
		}		
		$user = new Model_DbTable_Uzivatel();
		$statement = $user->select()->where('login = ?', $login);
		$uzivatel = $user->fetchRow($statement);
		//echo $uzivatel->id; die();						
		$playlist = new Model_DbTable_Playlist();
		$statement = $playlist->select('klipy')->order('id DESC')
							  ->where('user_id = ?', $uzivatel->id)
							  ->setIntegrityCheck(false)
							  ->joinLeft('klipy', 'playlist.klip_id = klipy.id',array('p' => 'id', 't' =>'title', 'd' =>'date', 'u' =>'url'));							 	   
		$this->view->videoklipy = $playlist->fetchAll($statement);		
		$this->view->ajax = $ajax;
	}
	
	public function pridajSkladbuAction(){
		$user_info= null;
		$auth = Zend_Auth::getInstance();
			if($auth->hasIdentity()){
				$user_info = $auth->getStorage()->read();							
			}else{
				$this->_redirect('/');
			}		
		$this->_helper->viewRenderer->setNoRender(true);
		$this->_helper->layout()->disableLayout();
		$id = $this->_request->getParam('song');
		if(!empty($id)){
			$check = new Model_DbTable_Videoklipy();
			$statement = $check->select()->where('url = ?', $id);
			$result = $check->fetchRow($statement);
			if(count($result) == 1){
				$data = array('klip_id' => $result->id, 'user_id' => $user_info->id);
				$model = new Model_DbTable_Playlist();
				$tmp_stat = $model->select()->where('klip_id = ?', $result->id)->where('user_id = ?',$user_info->id);
				$tmp_res = $model->fetchAll($tmp_stat);
				if(count($tmp_res) < 1){					
				  $model->insert($data);					  		
				}	
				$this->_redirect('/uzivatel/playlist');
				/*				
				$statement = $model->select('klipy')->where('user_id = ?', $user_info->id)->setIntegrityCheck(false)->joinLeft('klipy', 'playlist.klip_id = klipy.id',array('p' => 'id', 't' =>'title', 'd' =>'date', 'u' =>'url'));
				$this->view->videoklipy = $model->fetchAll($statement);
				*/
			}else{
				echo 'skladba neexistuje';
			}
		}
	}
}
?>
