<?php
/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of SiteRenderer
 *
 * @author camper
 */
//include("SiteSettings.php");
class SiteRenderer {
    private static function getMainTemplate() {
        $fh = fopen('utils/template.html','r') or die($php_errormsg);
        $template = fread($fh,filesize('utils/template.html'));

        fclose($fh) or die($php_errormsg);
        return $template;
    }
    public static function renderArrayToList($array) {
        $out="";
        $out=$out."<ul>\n";

        foreach($array as $item) {
            $out=$out."<li>$item</li>\n";
        }

        $out=$out."</ul>\n";

        return $out;
    }
    static function standardRender($site,$errors,$messages) {
        $rendered_site = SiteRenderer::getMainTemplate();
        foreach ($site as $key => $value) {
            $rendered_site = str_replace(
                $key,$value,$rendered_site);
        }

        $rendered_login="<a href=\"?site=user&action=login\">login</a> / <a href=\"?site=user&action=new\">register</a>";
        if(isset($_SESSION['user'])) {
            $rendered_login="<a href=\"?site=user&action=edit&user_id=".$_SESSION['user']."\">edit profile</a> | <a href=\"?site=user&action=logout\">logout</a>";
        }
        $rendered_site = str_replace("{RENDER_LOGIN_LOGOUT}",$rendered_login,$rendered_site);


        $rendered_errors =  SiteRenderer::renderArrayToList($errors);
        $rendered_site = str_replace("{RENDER_ERRORS}",$rendered_errors,$rendered_site);

        $rendered_messages =  SiteRenderer::renderArrayToList($messages);
        $rendered_site = str_replace("{RENDER_MESSAGES}",$rendered_messages,$rendered_site);

        $rendered_sites = SiteRenderer::renderArrayToList(SiteSettings::getLinks());
        $rendered_site = str_replace("{RENDER_LIST_OF_SITES}",$rendered_sites,$rendered_site);

        echo $rendered_site;
    }
}
class Form {
    var $fields = array();
    var $submit_name;
    var $action;
    var $method;
    public function  __construct($sname,$act,$meth) {
        $this->submit_name = $sname;
        $this->action = $act;
        $this->method = $meth;
    }
    public function add($what) {
        $this->fields[]=$what;
    }
    public function render() {
        $out = "
            <form class=\"upload\" enctype=\"multipart/form-data\" action=\"$this->action\" method=\"$this->method\">
            <table>
            ";
        foreach($this->fields as $field){
            $out=$out."<tr>
                    <td><label for=\"".$field->getName()."\">".$field->getLabel()."</label></td> <td>".$field->render()."</td>
                <tr>";
        }
        $out = $out."
            <tr>
            <td><input type=\"submit\" value=\"$this->submit_name\" name=\"submit\"/>	</td>
            </tr>
            </table>

            </form>
            ";
        return $out;
    }
}

class fInput{
      var $label="";
      var $name="";
      var $value="";
       public function  __construct($nlabel,$nname,$nvalue) {
           $this->label = $nlabel;
           $this->name = $nname;
           $this->value = $nvalue;
       }
       public function getLabel() {
           return $this->label;
       }

       public function getName() {
           return $this->name;
       }

       public function getValue() {
           return $this->value;
       }

       public function render(){
           return '<input name="'.$this->name.'" id="'.$this->name.'" type="input" value="'.$this->value.'" />';
       }
}
class fPassword extends fInput{
       public function render(){
           return '<input name="'.$this->name.'" id="'.$this->name.'" type="password" value="'.$this->value.'" />';
       }
}

class fTextArea extends fInput{
       public function render(){
           return '<textarea rows=\"4\" cols=\"20\" name="'.$this->name.'" id="'.$this->name.'" />'.$this->value.'</textarea>';
       }
}
class fLink extends fInput{
       public function render(){
           return '<a id="'.$this->label.'" href="'.$this->value.'">'.$this->label.'</a>';
       }
}
class fCheckBoxField extends fInput{

       public function render(){
        $out="";
        $out=$out."<ul>\n";

        foreach($this->value as $key=>$item){
            $out=$out."<li><label for='".$this->name.'_'.$key."'>$key</label>";
            if($item==true){
                $out=$out.' <input type="checkbox" id="'.$this->name.'_'.$key.'" name="'.$this->name.'_'.$key.'" checked="checked">';
            }else{
               $out=$out.' <input type="checkbox" id="'.$this->name.'_'.$key.'" name="'.$this->name.'_'.$key.'" >';

            }
            $out=$out."</li>\n";
        }

        $out=$out."</ul>\n";

        return $out;
    }
}
class fSelect extends fInput{

       public function render(){
        $out="";
        $out=$out."<select id='".$this->name."' name='".$this->name."'>\n";

        foreach($this->value as $key=>$item){
            $out=$out."<option>$item</option>\n";
        }

        $out=$out."</select>\n";

        return $out;
    }
}
class fFile extends fInput{
       public function render(){
           return '<input name="'.$this->name.'" id="'.$this->name.'" type="file" />';
       }
}

?>
