<?php

/**
 * BaseLesson
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property integer $day
 * @property integer $start
 * @property integer $end
 * @property integer $lesson_type_id
 * @property integer $room_id
 * @property integer $subject_id
 * @property integer $external_id
 * @property LessonType $LessonType
 * @property Room $Room
 * @property Subject $Subject
 * @property Doctrine_Collection $StudentGroup
 * @property Doctrine_Collection $Teacher
 * @property Doctrine_Collection $Linked
 * @property Doctrine_Collection $StudentGroupLessons
 * @property Doctrine_Collection $TeacherLessons
 * @property Doctrine_Collection $UserTimetableLessons
 * 
 * @method integer             getDay()                  Returns the current record's "day" value
 * @method integer             getStart()                Returns the current record's "start" value
 * @method integer             getEnd()                  Returns the current record's "end" value
 * @method integer             getLessonTypeId()         Returns the current record's "lesson_type_id" value
 * @method integer             getRoomId()               Returns the current record's "room_id" value
 * @method integer             getSubjectId()            Returns the current record's "subject_id" value
 * @method integer             getExternalId()           Returns the current record's "external_id" value
 * @method LessonType          getLessonType()           Returns the current record's "LessonType" value
 * @method Room                getRoom()                 Returns the current record's "Room" value
 * @method Subject             getSubject()              Returns the current record's "Subject" value
 * @method Doctrine_Collection getStudentGroup()         Returns the current record's "StudentGroup" collection
 * @method Doctrine_Collection getTeacher()              Returns the current record's "Teacher" collection
 * @method Doctrine_Collection getLinked()               Returns the current record's "Linked" collection
 * @method Doctrine_Collection getStudentGroupLessons()  Returns the current record's "StudentGroupLessons" collection
 * @method Doctrine_Collection getTeacherLessons()       Returns the current record's "TeacherLessons" collection
 * @method Doctrine_Collection getUserTimetableLessons() Returns the current record's "UserTimetableLessons" collection
 * @method Lesson              setDay()                  Sets the current record's "day" value
 * @method Lesson              setStart()                Sets the current record's "start" value
 * @method Lesson              setEnd()                  Sets the current record's "end" value
 * @method Lesson              setLessonTypeId()         Sets the current record's "lesson_type_id" value
 * @method Lesson              setRoomId()               Sets the current record's "room_id" value
 * @method Lesson              setSubjectId()            Sets the current record's "subject_id" value
 * @method Lesson              setExternalId()           Sets the current record's "external_id" value
 * @method Lesson              setLessonType()           Sets the current record's "LessonType" value
 * @method Lesson              setRoom()                 Sets the current record's "Room" value
 * @method Lesson              setSubject()              Sets the current record's "Subject" value
 * @method Lesson              setStudentGroup()         Sets the current record's "StudentGroup" collection
 * @method Lesson              setTeacher()              Sets the current record's "Teacher" collection
 * @method Lesson              setLinked()               Sets the current record's "Linked" collection
 * @method Lesson              setStudentGroupLessons()  Sets the current record's "StudentGroupLessons" collection
 * @method Lesson              setTeacherLessons()       Sets the current record's "TeacherLessons" collection
 * @method Lesson              setUserTimetableLessons() Sets the current record's "UserTimetableLessons" collection
 * 
 * @package    candle
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 6820 2009-11-30 17:27:49Z jwage $
 */
abstract class BaseLesson extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('lesson');
        $this->hasColumn('day', 'integer', null, array(
             'type' => 'integer',
             'notnull' => true,
             ));
        $this->hasColumn('start', 'integer', null, array(
             'type' => 'integer',
             'notnull' => true,
             ));
        $this->hasColumn('end', 'integer', null, array(
             'type' => 'integer',
             'notnull' => true,
             ));
        $this->hasColumn('lesson_type_id', 'integer', null, array(
             'type' => 'integer',
             'notnull' => true,
             ));
        $this->hasColumn('room_id', 'integer', null, array(
             'type' => 'integer',
             'notnull' => true,
             ));
        $this->hasColumn('subject_id', 'integer', null, array(
             'type' => 'integer',
             'notnull' => true,
             ));
        $this->hasColumn('external_id', 'integer', null, array(
             'type' => 'integer',
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('LessonType', array(
             'local' => 'lesson_type_id',
             'foreign' => 'id'));

        $this->hasOne('Room', array(
             'local' => 'room_id',
             'foreign' => 'id'));

        $this->hasOne('Subject', array(
             'local' => 'subject_id',
             'foreign' => 'id',
             'onDelete' => 'CASCADE'));

        $this->hasMany('StudentGroup', array(
             'refClass' => 'StudentGroupLessons',
             'local' => 'lesson_id',
             'foreign' => 'student_group_id'));

        $this->hasMany('Teacher', array(
             'refClass' => 'TeacherLessons',
             'local' => 'lesson_id',
             'foreign' => 'teacher_id'));

        $this->hasMany('Lesson as Linked', array(
             'refClass' => 'LinkedLessons',
             'local' => 'lesson1_id',
             'foreign' => 'lesson2_id',
             'equal' => true));

        $this->hasMany('StudentGroupLessons', array(
             'local' => 'id',
             'foreign' => 'lesson_id'));

        $this->hasMany('TeacherLessons', array(
             'local' => 'id',
             'foreign' => 'lesson_id'));

        $this->hasMany('UserTimetableLessons', array(
             'local' => 'id',
             'foreign' => 'lesson_id'));
    }
}