<?php 
/*
		GPS Share v.1
    Copyright (C) 2010  Filip Vojtko

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

/* Database framework (PostgreSQL version)*/


function to_db_bool($q) {
	if ($q == true) {
		return "t";
	} else {
		return "f";
	}	
}

function to_php_bool($q) {
	if ($q == "t") {
		return true;
	} else {
		return false;
	}
}

function db_query_bool($q) {
	if ($q)
	{
		return "true";
	}
	else
	{
		return "false";
	}
}

function db_begin() {
	return db_query("BEGIN");
}

function db_commit() {
	return db_query("COMMIT");
}

function db_abort() {
	return db_query("ABORT");
}

function db_charset($charset) {
	return db_query("SET NAMES '".db_safe_string($charset)."'");
}

function db_connect($host,$dbname,$user,$password,$schema) {
    $dbconn = pg_connect("host=$host dbname=$dbname user=$user password=$password");
    if (!$dbconn)
    {
	    die("Could not connect: ".pg_last_error());
    }
    if ($schema != "")
    {
    	$schema_set = pg_query("SET search_path TO $schema");
    	if(!$schema_set)
   		{
	    	die("Can\'t use database: ".pg_last_error());
    	}
		}
    return $dbconn;
}

function db_query($q){
    return pg_query($q);
}

function db_fetch_array($r){
    return pg_fetch_array($r);
}

function db_num_rows($q){
    return pg_num_rows($q);
}

function db_close($conn) {
    return pg_close($conn);
}

function db_error() {
	return pg_last_error();
}

function db_safe_string($s) {
	return pg_escape_string($s);
}

function db_create_temp_table($name,$select) {
	return "CREATE TEMPORARY TABLE ".db_safe_string($name)." AS (".$select.");";	
}

?>