<?
/*
		GPS Share v.1
    Copyright (C) 2010  Filip Vojtko

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

if (isset($_POST['placemark_export']))
{	
	$xml = array ();	
	if ((isset($_POST['placemark_export_id'])) AND (is_array($_POST['placemark_export_id'])))
	{
		$id_list = $_POST['placemark_export_id'];		
		foreach ($id_list as $id_key => $id_value)
		{
				if (!($id_query = db_query("SELECT P.name AS name, TE.type_name AS type_name, CE.state AS state, P.place_country AS country, P.gps_longitude AS longitude, P.gps_latitude AS latitude, P.gps_altitude AS altitude FROM placemarks AS P NATURAL JOIN (SELECT id AS place_state, name AS state FROM country_enumerator) AS CE NATURAL JOIN (SELECT id AS type, name AS type_name FROM placemark_type_enumerator) AS TE WHERE P.id = '".db_safe_string($id_value)."' LIMIT 1")))
					die("Error connecting database: ".db_error());
				if (db_num_rows($id_query) > 0)
				{
					$id_result = db_fetch_array($id_query);
					$id_array = array ( "name" => htmlspecialchars($id_result['name']),
																"type" => htmlspecialchars($id_result['type_name']),
																"state" => htmlspecialchars($id_result['state']),
																"country" => htmlspecialchars($id_result['country']),
																"longitude" => htmlspecialchars($id_result['longitude']),
																"latitude" => htmlspecialchars($id_result['latitude']),
																"altitude" => htmlspecialchars($id_result['altitude']));					
					$xml[$id_key] = $id_array;								
				}
		}
	}
	$file = "tmp/".session_id().".xml";
	if (CreateXMLFile($file,$xml))
		ExportXMLFile($file);	
}


function ExportXMLFile($xmlFile)
{
	if (file_exists($xmlFile))
	{
		header('Content-Description: File Transfer');
		header('Content-Type: text/xml');
		header('Content-Length: ' . filesize($xmlFile));
		//header('Content-Disposition: attachment; filename=' . basename($xmlFile));
		header('Content-Disposition: attachment; filename=gps_share_export.xml');
		readfile($xmlFile);
		unlink($xmlFile);
		die();
	}
	else
	{
		die("XML export file not found");
	}
}

function CreateXMLFile($xmlFileName,$selectedPlacemarkArray)
{
	$xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"."<kml xmlns=\"http://www.opengis.net/kml/2.2\">";
	while (list($key,$val) = each($selectedPlacemarkArray))
	{
		$xml = $xml."<placemark>";
		$xml = $xml."<name>".$val['name']."</name>";
		$xml = $xml."<description>".$val['type']." (".$val['state'].", ".$val['country'].")</description>";
		$xml = $xml."<point>";
		$xml = $xml."<coordinates>".$val['longitude'].",".$val['latitude'].",".$val['altitude']."</coordinates>";
		$xml = $xml."</point>";
		$xml = $xml."</placemark>";
	}
	$xml = $xml."</kml>";
	$file = fopen($xmlFileName,"w");
	if (!$file)
	{
		return false;
	}
	if (!fwrite($file,$xml))
	{
		return false;
	}
	fclose($file);
	return true;
}


?>