/****************************************************************************
* sync.h
*
* (c) Tomas Plachetka
*****************************************************************************/
#ifndef SYNC_H
#define SYNC_H

#ifdef SYNC_SEM
#include <semaphore.h>
#elif SYNC_MUTEX
#include <pthread.h>
#endif

/*****************************************************************************
* Global preprocessor defines
******************************************************************************/

#ifdef SYNC_SEM
/* Use semaphore synchronisation */
/* Write your code here (and to sync.c if needed): */

#elif SYNC_MUTEX
/* Use pthread synchronisation */
#define MUTEX_INIT(m) pthread_mutex_init(m, NULL)
#define MUTEX_DESTROY(m) pthread_mutex_destroy(m)
#define LOCK(m) pthread_mutex_lock(m)
#define UNLOCK(m) pthread_mutex_unlock(m)
#define COND_INIT(c) pthread_cond_init(c, NULL)
#define COND_DESTROY(c) pthread_cond_destroy(c)
#define WAIT(c, m) pthread_cond_wait(c, m)
#define SIGNAL(c) pthread_cond_signal(c)
#endif

/*****************************************************************************
* Global typedefs
******************************************************************************/
#ifdef SYNC_SEM
/* Use semaphore synchronisation */
/* Write your code here (and to sync.c if needed) */

#elif SYNC_MUTEX
/* Use mutex synchronisation */
typedef pthread_mutex_t MUTEX_T;
typedef pthread_cond_t COND_T;
#endif

/*****************************************************************************
* Global variables
******************************************************************************/

/*****************************************************************************
* Global functions
******************************************************************************/

#endif
