package org.sunflow.raytracer;

import java.util.HashMap;

/**
 * Maintains a cache of all loaded texture maps. This is usefull if the same texture might be used more than once in
 * your scene.
 */
public final class TextureCache {
    private static HashMap textures = new HashMap();

    private TextureCache() {}

    /**
     * Gets a reference to the texture specified by the given filename. If the texture has already been loaded the
     * previous reference is returned, otherwise, a new texture is created.
     *
     * @param filename image file to load
     * @return texture object
     * @see Texture
     */
    public static Texture getTexture(String filename) {
        if (textures.containsKey(filename))
            return (Texture) textures.get(filename);
        Texture t = new Texture(filename);
        textures.put(filename, t);
        return t;
    }
}