<?php

class cForm {

	public $spacer; 
	private $resetval;
	
	function __construct($spacer=" &nbsp; ", $resetval="Reset", $backval="Back") {
		$this->spacer = $spacer;
		$this->resetval = $resetval;
		$this->backval = $backval;
		global $_path;
		$this->path = $_path;
	}
	
	public function HTMLdoForm($label, $name, $form) {
		$ret = '<label for="'.$name.'" id="'.$name.'_label">'.$label.'</label>'."\n";
		$ret .= $form . '<br />'."\n";
		return $ret;
	}
	
	public function passwordBox($label, $name) {
		return $this->HTMLdoForm($label, $name, '<input type="password" name="'.$name.'" id="'.
			$name.'" class="input_large" value="" />');
	}
	
	public function inputBox($label, $name, $length, $value="", $operation="", $readonly=FALSE, $description='') {
		$otherClass = "";
		if ($readonly) {
			$otherClass = ' readonly';
		}
		$class = ($length <= 16 ? 'input_small' : 'input_large') . $otherClass;
		$desc  = $description != '' ? '<small class="desc">'.$description.'</small>' : '';
		
		return $this->HTMLdoForm($label, $name, '<input type="text" name="'.$name.'" id="'.$name.'" class="'.
			$class.'" value="'.$value.'" maxlength="'.$length.'" '.$operation.''.($readonly ? ' readonly="readonly"' : "").' />'.$desc);
	}
	
	public function checkBox($label, $name, $value='0', $operation="") {
		return $this->HTMLdoForm($label, $name, '<input type="checkbox" name="'.$name.'" id="'.$name.'" value="1" class="checkbox"'.($value ? ' checked="checked"' : '').' '.$operation.'/>');
	}
	
	public function textBox($label, $name, $value="", $class="") {
		return '<div id="'.$name.'">' . "\n" .
			$this->HTMLdoForm($label, $name, '<textarea name="'.$name.'"' .
			(empty($class) ? "" : ' class="'.$class.'"') .'>'.$value.'</textarea>')
			. '</div>';
	}
	
	public function uploadBox($label, $name) {
		return $this->HTMLdoForm($label, $name, '<input type="file" name="'.$name.'" id="'.$name.'" />');
	}
	
	public function megaBox($value="") {
		return '<div id="richedit" class="megaBox">' . "\n" . $this->getRichEdit() .
			'<textarea name="megaBox1" id="megaBox1">'.$value.'</textarea>'.'</div>'."\n";
	}
	
	public function wikiBox($value="") {
		return '<div id="wikitext" class="megaBox">' . "\n" . $this->getWikiBits() .
			'<textarea name="wpTextbox1" id="wpTextbox1">'.$value.'</textarea>'.'</div>'."\n";
	}
	
	public function hiddenF($name, $value="") {
		return '<input type="hidden" name="'.$name.'" value="'.$value.'" class="nodisp" />'."\n";
	}
	
	public function selectBox($label, $name, $values, $default="", $onchange="", $operation="") {
		$txt = "";
		$txt .= '<select name="'.$name.'" id="'.$name.'"'.($onchange ? ' onchange="javascript:'.$onchange.';"' : "").' '.$operation.'>' . "\n";
		if ($default == "") // empty($default) vracalo TRUE pre $default = '0'
			$default = $values[0]['value'];
		for ($i=0;$i<count($values);$i++)
			$txt .= '<option class="'.(array_key_exists("class",$values[$i]) ? $values[$i]['class'] : "a").'" value="'.$values[$i]['value'].'"'.
				($values[$i]['value'] == $default ? ' selected="selected"' : '').'>'.$values[$i]['name'].'</option>'."\n";
		$txt .= '</select>';
		return $this->HTMLdoForm($label, $name, $txt);
	}
	
	public function optionBox($label, $name, $values, $default="", $onchange="") {
		$boxes = Array();
		if (strlen($default) == 0)
			$default = $values[0]['value'];
		for ($i=0;$i<count($values);$i++)
			$boxes[] = '<input type="radio" name="'.$name.'" id="'.$name.'_'.$values[$i]['value'].'" value="'.
				$values[$i]['value'].'" class="optionbox"'.($onchange ? 'onclick="javascript:'.$onchange.';"' : "").''.
				($values[$i]['value'] == $default ? ' checked="checked"' : '').' />'.$values[$i]['name'].'';
		return $this->HTMLdoForm($label, $name, implode($this->spacer,$boxes));
	}
	
	public function clickButton($id, $submitval, $value) {
		return $this->submitButton($id, $submitval, FALSE, $value);
	}
	
	public function submitButton($id=0, $submitval="Submit", $reset=TRUE, $value="submit", $saveAsNew=FALSE) {
		return $this->HTMLdoForm("&nbsp;", $value, 
			'<input type="submit" name="'.$value.'" id="'.$value.'" class="submit input_save" value="'.$submitval.'" />' .
			($saveAsNew ? $this->spacer . '<input type="submit" name="Insert" id="Insert" class="submit input_save" value="Create" onclick="return confirm(\'Save as new entry?\');" />' : "") .
			($reset ? $this->spacer . '<input type="reset" name="reset" class="submit input_reset" value="'.$this->resetval.'" />' : '') .
			$this->hiddenF("id",$id) .
			($reset ? $this->spacer . '<input type="submit" name="Back" class="submit input_back" value="'.$this->backval.'" />' : ''));
	}
	
	public function filterButtons($applyFilterLabel, $cancelFilerLabel) {
		$ret = "";
		$ret .= '<div class="submit">'."\n";
		$ret .= '<input type="submit" name="button_applyFilter" id="button_applyFilter" class="submit" value="'.$applyFilterLabel.'" />';
		$ret .= $this->spacer;
		$ret .= '<input type="submit" name="button_cancelFilter" id="button_cancelFilter" class="submit" value="'.$cancelFilerLabel.'" />';
		$ret .= $this->spacer;
		$ret .= '</div>'."\n";	
		return $ret;
	}

	public final function getRichEdit() {
		$path = $this->path['core_modules_url']."tinymce/";
return '<!-- tinyMCE -->
<script language="javascript" type="text/javascript" src="'.$path.'jscripts/tiny_mce/tiny_mce.js"></script>
<script language="javascript" type="text/javascript">
	tinyMCE.init({
		theme : "advanced",
		mode : "exact",
		elements : "megaBox1",
		cleanup : "true",
		auto_cleanup_word : false,
		relative_urls : false,
		remove_script_host : false,
		entity_encoding : "raw",
		content_css : "'.$this->path['styles'].'base.css, '.$this->path['styles'].'style.css, '.$this->path['styles'].'tinymce.css",
		extended_valid_elements : "a[href|target|name|class],tr[class],input[type|name|value|class|style]",
		plugins : "table,nonbreaking",
		theme_advanced_buttons3_add_before : "tablecontrols,separator,forecolor,backcolor,nonbreaking",
		// invalid_elements : "a",
		theme_advanced_styles : "Header 1=header1;Header 2=header2;Header 3=header3;Table Row=tableRow1", // Theme specific setting CSS classes
		entity_encoding: "named",
		entities: "160,nbsp",
		debug : false,
		apply_source_formatting : true,
		nonbreaking_force_tab : true
	});</script>
<!-- /tinyMCE -->'."\n";	
	}
	
	public final function getWikiBits() {
		$path = $this->path['core_modules_url']."wikibits/";
return "<!-- WikiBits -->
<script type=\"text/javascript\" src=\"".$path."wikibits.js\"></script>
<div id=\"toolbar\">
<script type=\"text/javascript\">
/*<![CDATA[*/
addButton('".$path."icons/button_bold.png','Bold text','\'\'\'','\'\'\'','Bold text','mw-editbutton-bold');
addButton('".$path."icons/button_italic.png','Italic text','\'\'','\'\'','Italic text','mw-editbutton-italic');
addButton('".$path."icons/button_link.png','Internal link','[[',']]','Link title','mw-editbutton-link');
addButton('".$path."icons/button_extlink.png','External link (remember http:// prefix)','[',']','http://www.example.com link title','mw-editbutton-extlink');
addButton('".$path."icons/button_headline.png','Level 2 headline','\\n== ',' ==\\n','Headline text','mw-editbutton-headline');
addButton('".$path."icons/button_image.png','Embedded image','[[Image:',']]','Example.jpg','mw-editbutton-image');
addButton('".$path."icons/button_media.png','Media file link','[[Media:',']]','Example.ogg','mw-editbutton-media');
addButton('".$path."icons/button_nowiki.png','Ignore wiki formatting','[code]','[/code]','Insert non-formatted text here','mw-editbutton-nowiki');
addButton('".$path."icons/button_hr.png','Horizontal line (use sparingly)','\\n----\\n','','','mw-editbutton-hr');
/*]]>*/
</script>
</div>
<!-- /WikiBits -->"."\n";	
	}

}

?>
