<?php

class cFunctions extends cApp {
	
	public $oDb, $oUrl, $oSession, $oForm;

	function __construct($oDb, $oUrl, $oSession, $oForm) {
		$this->oDb = $oDb;
		$this->oUrl = $oUrl;
		$this->oSession = $oSession;
		$this->oForm = $oForm;
	}

	final function userSelectbox($idUser, $name="id_user") {
		$q = $this->oDb->query("SELECT id,login FROM users ORDER BY login ASC");
		$pole = Array();
		$pole[0]['value'] = 0;
		$pole[0]['name'] = "-- Choose --";
		while ($bR = $this->oDb->get($q)) {
			$pole[]['value'] = $bR['id'];
			$pole[count($pole)-1]['name'] = $bR['login'];
		}
		return $this->oForm->selectBox("User", $name, $pole, $idUser);
	}
	
	final function groupSelectbox($idGroup, $idUser=0, $jsAction="") {
		$where = "";
		if ($idUser > 0)
			$where .= " WHERE id_user IN (0,{$idUser})";
		$q = $this->oDb->query("SELECT id_group,title FROM `group`{$where} ORDER BY title ASC");
		$pole = Array();
		$pole[0]['value'] = 0;
		$pole[0]['name'] = "-- All --";
		while ($bR = $this->oDb->get($q)) {
			$pole[]['value'] = $bR['id_group'];
			$pole[count($pole)-1]['name'] = $bR['title'];
		}
		return $this->oForm->selectBox("Group", "id_group", $pole, $idGroup, $jsAction);
	}
	
	final function namespaceSelect() {
		$array = Array();
		$array[]['name'] = "- Empty -";
		$array[count($array)-1]['value'] = 0;
		$q = $this->oDb->query("SELECT * FROM namespace ORDER BY namespace ASC");
		while ($res = $this->oDb->get($q)) {
			$array[]['name'] = $res['namespace'];
			$array[count($array)-1]['value'] = $res['id_namespace'];
		}
		return $array;
	}
	
	final function dateSelectbox($label, $name, $dateString="", $minuta=1, $hodina=1, $den=1, $mesiac=1, $rok=1) {
		$data = "";
		if ($dateString) {
      	$t_minuta = substr($dateString,14,2);
      	$t_hodina = substr($dateString,11,2);
      	$t_den = substr($dateString,8,2);
      	$t_mesiac = substr($dateString,5,2);
      	$t_rok = substr($dateString,0,4);
		} else {
			$t_minuta = 0;
			$t_hodina = 0;
			$t_den = date("j");
			$t_mesiac = date("n");
			$t_rok = date("Y");
		}
		if ($den) {
			$data .= "<select name=\"".$name."_den\" class=\"date\">";
			for ($i=1;$i<=31;$i++) {
				if (strlen($i) == 1) $a = "0".$i; else $a = $i;
				if ($i == $t_den) $selected = " selected=\"selected\""; else $selected = "";
			$data .= "<option value=\"".$a."\"".$selected.">".$i."</option>";
			}
			$data .= "</select> &nbsp; ";
		}
		if ($mesiac) {
      	$data .= "<select name=\"".$name."_mesiac\" class=\"date\">";
      	for ($i=1;$i<=12;$i++) {
        		if (strlen($i) == 1) $a = "0".$i; else $a = $i;
        		if ($i == $t_mesiac) $selected = " selected=\"selected\""; else $selected = "";
				$data .= "<option value=\"".$a."\"".$selected.">".date("M",mktime(0,0,0,$i,1,1970))."</option>";
			}
			$data .= "</select> &nbsp; ";
		}
		if ($rok) {
			$data .= "<select name=\"".$name."_rok\" class=\"year\">";
			for ($i=1900;$i<=2050;$i++) {
				if (strlen($i) == 1) $a = "0".$i; else $a = $i;
				if ($i == $t_rok) $selected = " selected=\"selected\""; else $selected = "";
				$data .= "<option value=\"".$a."\"".$selected.">".$i."</option>";
			}
			$data .= "</select> &nbsp; ";
		}
		if ($hodina) {
			$data .= "<select name=\"".$name."_hodina\" class=\"date\">";
			for ($i=0;$i<24;$i++) {
 				if (strlen($i) == 1) $a = "0".$i; else $a = $i;
				if ($i == $t_hodina && $dateString) $selected = " selected=\"selected\""; else $selected = "";
				$data .= "<option value=\"".$a."\"".$selected.">".$a."</option>";
			}
			$data .= "</select> &nbsp; ";
		}
		if ($minuta) {
			$data .= "<select name=\"".$name."_minuta\" class=\"date\">";
			for ($i=0;$i<60;$i++) {
				if (strlen($i) == 1) $a = "0".$i; else $a = $i;
				if ($i == $t_minuta && $dateString) $selected = " selected=\"selected\""; else $selected = "";
				$data .= "<option value=\"".$a."\"".$selected.">".$a."</option>";
			}
     	 $data .= "</select>";
		}
		$data .= '<input type="hidden" name="'.$name.'_sekunda" value="00" />';
		return $this->oForm->HTMLdoForm($label, $name, $data);
	}
	
	final function setDateFromSelect($name, $postData) {
		$date = "";
		$key = $name."_rok";
		if (array_key_exists($key,$postData))
			$date .= $postData[$key];
		else $date .= date("Y");
		$date .= "-";
		$key = $name."_mesiac";
		if (array_key_exists($key,$postData))
			$date .= $postData[$key];
		else $date .= date("m");
		$date .= "-";
		$key = $name."_den";
		if (array_key_exists($key,$postData))
			$date .= $postData[$key];
		else $date .= date("d");
		$date .= " ";
		$key = $name."_hodina";
		if (array_key_exists($key,$postData))
			$date .= $postData[$key];
		else $date .= date("h");
		$date .= ":";
		$key = $name."_minuta";
		if (array_key_exists($key,$postData))
			$date .= $postData[$key];
		else $date .= date("i");
		$date .= ":";
		$key = $name."_sekunda";
		$date .= $postData[$key];
		return $date;
	}
	
	public final function setTags($idMenu, $idReference, $tags) {
		$tags = trim($tags);
		if (strlen($tags) == 0 || $tags == " ")
			return;
		$tags = explode(",",$tags);
		$this->oDb->query("DELETE FROM tags
			WHERE id_menu = '{$idMenu}' AND id_reference = '{$idReference}'");
		for ($i=0;$i<count($tags);$i++) {
			if (strlen($tags[$i]) == 0) continue;
			$tags[$i] = str_replace("_"," ",$tags[$i]);
			$tags[$i] = trim($tags[$i]);
			$this->oDb->query("INSERT INTO tags SET
				id_menu = '{$idMenu}',
				id_reference = '{$idReference}',
				tagname = '{$tags[$i]}'");
		}
	}
	
	public final function tagsArray($idMenu, $idReference) {
		$array = Array();
		if (!$idReference) return $array;
		$q = $this->oDb->query("SELECT tagname FROM tags
			WHERE id_menu = '{$idMenu}' AND id_reference = '{$idReference}'");
		while ($res = $this->oDb->get($q))
			$array[] = $res['tagname'];
		return $array;
	}
	
	public final function tagTextBox($idMenu, $idReference) {
		if (array_key_exists("tags",$_POST))
			$tags = explode(",",$_POST['tags']);
		else
			$tags = $this->tagsArray($idMenu, $idReference);
		return $this->oForm->TextBox("Tags (, sep.)", "tags", implode(", ",$tags), "smaller");
	}
	
	public final function tagCloud($countTags = 0, $idUser = 0) {
		if ($countTags)
			$limit = " LIMIT 0,{$countTags}";
		else
			$limit = "";
		if ($idUser)
			// Toto zrovna modularita nie je, lebo tbc...
			$userTags = "
				WHERE id_menu = '5' AND id_reference IN (SELECT id_blog FROM blog WHERE id_user = '{$idUser}')
				OR id_menu = '7' AND id_reference IN (SELECT id_wiki FROM wiki WHERE id_user = '{$idUser}')
				OR id_menu = '12' AND id_reference IN (SELECT id_file FROM file WHERE id_user = '{$idUser}')";
		else
			$userTags = "";
		$tags = Array();
		$biggest_font_size = 500;
		$smallest_font_size = 100; 
		$multiplier = $biggest_font_size - $smallest_font_size; 
		$cntTags = $this->oDb->getKey("cnt","SELECT COUNT(tagname) AS cnt FROM tags");
		$sql = "(SELECT tagname, COUNT(tagname) AS cnt FROM tags {$userTags}
			GROUP BY tagname ORDER BY cnt DESC{$limit}) ORDER BY tagname ASC";
		$q = $this->oDb->query($sql);
		while ($res = $this->oDb->get($q)) {
			$tags[]['tag'] = $res['tagname'];
			$size = round(($res['cnt']/$cntTags)*$multiplier)+$smallest_font_size;
			$tags[count($tags)-1]['size'] = $size . "%";
			$tags[count($tags)-1]['count'] = $res['cnt'];
			
		} 
		if (count($tags) == 0) {
			$tags[0]['tag'] = "No tags";
			$tags[0]['size'] = "100%";
		}
		return $tags;
	}
	
	public final function smartResize($file, $width=0, $height=0, $proportional=TRUE) {
		if ( $height <= 0 && $width <= 0 )
			return FALSE;
		$info = getimagesize($file);
		$image = '';
		$final_width = 0;
		$final_height = 0;
		list($width_old, $height_old) = $info;
		if ($proportional) {
			$proportion = $width_old / $height_old;
			if ( $width > $height && $height != 0) {
				$final_height = $height;
				$final_width = $final_height * $proportion;
			} elseif ( $width < $height && $width != 0) {
				$final_width = $width;
				$final_height = $final_width / $proportion;
			} elseif ( $width == 0 ) {
				$final_height = $height;
				$final_width = $final_height * $proportion;          
			} elseif ( $height == 0) {
				$final_width = $width;
				$final_height = $final_width / $proportion;          
			} else {
				$final_width = $width;
				$final_height = $height;
			}
		} else {
			$final_width = ( $width <= 0 ) ? $width_old : $width;
			$final_height = ( $height <= 0 ) ? $height_old : $height;
		}
		switch ($info[2]) {
			case IMAGETYPE_GIF:
				$image = imagecreatefromgif($file);
			break;
			case IMAGETYPE_JPEG:
				$image = imagecreatefromjpeg($file);
			break;
			case IMAGETYPE_PNG:
				$image = imagecreatefrompng($file);
			break;
			default:
				return FALSE;
		}
		$image_resized = imagecreatetruecolor($final_width, $final_height);
		imagecolortransparent($image_resized, imagecolorallocate($image_resized, 0, 0, 0) );
		imagealphablending($image_resized, FALSE);
		imagesavealpha($image_resized, TRUE);
		imagecopyresampled($image_resized, $image, 0, 0, 0, 0, $final_width, $final_height, $width_old, $height_old);
		ob_start();
		switch ($info[2]) {
			case IMAGETYPE_GIF:
				imagegif($image_resized, $file);
			break;
			case IMAGETYPE_JPEG:
				imagejpeg($image_resized, $file, 85);
			break;
			case IMAGETYPE_PNG:
				imagepng($image_resized, $file);
			break;
			default:
				return false;
		}
		return TRUE;
	}
	
}

?>
