<?php

class group extends cData {

	public $pluginName, $pluginMenuTitle, $tables, $joins, $rights, $order, 
		$perPage, $insertText, $urlLink, $moduleType, $childClass;
	private $groupType;

	function __construct($oDb, $oUrl, $oSession, $action) {
		$this->pluginName = "Group";
		$this->pluginMenuTitle = "Group";
		$this->tables = Array (
			Array(
				"name" => "group"
			),
			Array(
				"name" => "users"
			)
		);
		$this->joins = Array (
			"users" => "users.id = group.id_user"
		);
		$this->order = "group.title";
		$this->perPage = 30;
		$this->insertText = "Add group";
		$this->urlLink = "group";
		$this->moduleType = "class";
		$this->childClass = __CLASS__;
		parent::__construct($oDb, $oUrl, $oSession, $action);
		$this->groupType = "public";
		if ($this->oUrl->page == "my-groups")
			$this->groupType = "private";
		if ($this->groupType == "private") {
			$this->searchDb[] = "users.id = '".$oSession->idUser."'";
			$this->searchDb[] = "group.private = '1'";
		} else
			$this->searchDb[] = "group.private = '0'";
	}
	
	final function validateData($array) {
		
		try { 
			if ($array['id'] == 0)
				if ($this->oDb->dbnumrows("SELECT `title` FROM `group` WHERE `title` = '".$array['title']."'") > 0)
					throw new Exception("Group exists");
		} catch (Exception $e) {
			$this->errorMsg($e->getMessage());
			return FALSE;
		}
		parent::validateData($array);
		return TRUE;	
	}
	
	final function beforeSubmit($postData) {
		if ($postData['id'] == 0 && $this->groupType == "private")
			$postData['title'] = "User:{$this->oSession->loginName}:" . $postData['title'];
		return parent::beforeSubmit($postData);
	}
	
	final function printList() {
		$ret = "";
		$ret .= $this->tableHead("List of groups",Array(
			"ID","Title","Users","Private"
		));
		
		while ($bR = $this->oDb->get($this->query)) {
			$ID = $this->pp($bR,"id_group");
			$private = $this->pp($bR,"private");
			$ret .= $this->inTable(Array(
				$ID,
				$this->pp($bR,"title"),
				$this->oDb->getKey("pocet","SELECT COUNT(id_user) AS pocet FROM group_user
					WHERE id_group = '{$ID}'"),
				($private ? "Yes" : "No"),
			),$this->pp($bR,$this->primaryKey));
		}
		$ret .= $this->tableEnd();
		return parent::printList($ret);
	}
	
	final function printForm($action, $id) {
		$ret = "";
		// $ret .= $this->oFunctions->userSelectbox($this->pp($this->row, "id_user"));
		$ret .= $this->oForm->hiddenF("id_user",$this->oSession->idUser);
		$readonly = FALSE; // FALSE
		if (!$id)
			$readonly = FALSE;
		$ret .= $this->oForm->inputBox("Title", "title", 64, $this->pp($this->row, "title"), "", $readonly);
		$val = $this->groupType == "private" ? 1 : 0;
		$ret .= $this->oForm->hiddenF("private",$val);
		$sel = '<select name="userSelect[]" id="userSelect[]" multiple="multiple" size="10">'."\n";
		$q = $this->oDb->query("SELECT * FROM users");
		$sQ = $this->oDb->query("SELECT id_user FROM group_user WHERE id_group = '".$id."'");
		$sArray = Array();
		
		while ($sRes = $this->oDb->get($sQ))
			$sArray[] = $sRes['id'];
		while ($eRes = $this->oDb->get($q)) {
			$selected = in_array($eRes['id'],$sArray) ? ' selected="selected"' : "";
			$sel .= '<option value="'.$eRes['id'].'"'.$selected.'>'.$eRes['login'].'</option>'."\n";
		}
		$sel .= '</select>'."\n";
		$ret .= $sel;
		return parent::printForm($action, $id, $ret);
	}
	
	final function dbUpdate($id) {
		parent::dbUpdate($id);
		$postData = $_POST;
		if (array_key_exists("userSelect",$postData)) {
			$this->oDb->query("DELETE FROM group_user WHERE id_group = '".$id."'");
			$sT = $postData['userSelect'];
			for ($i=0;$i<count($sT);$i++)
				$this->oDb->query("INSERT INTO group_user (id_user,id_group)
					VALUES ('".$sT[$i]."','".$id."')");
		}
	}
	
}

?>