<?php

class users extends cData {

	public $pluginName, $pluginMenuTitle, $tables, $joins, $rights, $order, 
		$perPage, $insertText, $urlLink, $moduleType, $childClass;

	function __construct($oDb, $oUrl, $oSession, $action) {
		$this->pluginName = "Users";
		$this->pluginMenuTitle = "Users";
		//s akymi tabulkami pracuje
		$this->tables = Array (
			Array(
				"name" => "users"
			)
		);
		$this->order = "users.login";
		$this->perPage = 30;
		$this->insertText = "Pridaj uživatela";
		$this->urlLink = "users";
		$this->moduleType = "class";
		$this->childClass = __CLASS__;
		parent::__construct($oDb, $oUrl, $oSession, $action);
	}
	
	final function validateData($array) {
		try {
			if (!$this->checkEmail($array['email']))
				throw new Exception("Wrong e-mail address.");
			if ($array['p1'] != $array['p2'])
				throw new Exception("Passwords don't match.");
		} catch (Exception $e) {
			$this->errorMsg($e->getMessage());
			return FALSE;
		}
		parent::validateData($array);
		return TRUE;	
	}
	
	final function beforeSubmit($postData) {
		if (!empty($postData['p1'])) {
			$postData['password'] = encryptPass($postData['p1']);
			$content = "Username: {$postData['loginname']}\n";
			$content = "Password: {$postData['p1']}\n\n";
			$content .= "URL: {$this->path['url']}";
			$this->sendMail($this->getGeneralConfig("email"), $postData['email'], "Account created", $content);
		}
		return parent::beforeSubmit($postData);
	}
	
	final function printList() {
		$ret = "";
		$ret .= $this->tableHead("Users",Array(
			"Nick","Name","Surname","prava"
		));
		while ($bR = $this->oDb->get($this->query)) {
			$ret .= $this->inTable(Array(
				$this->pp($bR,"login"),
				$this->pp($bR,"meno"),
				$this->pp($bR,"priezvisko"),
				$this->pp($bR,"prava"),
			),$this->pp($bR,$this->primaryKey));
		}
		$ret .= $this->tableEnd();
		
		return parent::printList($ret);
	}
	
	final function printForm($action, $id) {
		$ret = "";
		$ret .= $this->oForm->inputBox("Login", "login", 64, $this->pp($this->row, "login"));
		$ret .= $this->oForm->inputBox("Meno", "meno", 64, $this->pp($this->row, "meno"));
		$ret .= $this->oForm->inputBox("Priezvisko", "priezvisko", 32, $this->pp($this->row, "priezvisko"));
		$ret .= $this->oForm->inputBox("Vek", "vek", 32, $this->pp($this->row, "vek"));
		$ret .= $this->oForm->passwordBox("Password", "p1");
		$ret .= $this->oForm->passwordBox("Password retype", "p2");
		$ret .= $this->oForm->inputBox("Prava", "prava", 32, $this->pp($this->row, "prava"));
		$ret .= $this->oForm->inputBox("Respekt", "respekt", 64, $this->pp($this->row, "respekt"));
		$ret .= $this->oForm->inputBox("Email", "email", 96, $this->pp($this->row, "email"));
		
		/*
		 * vyberie vsetky kluby a vypise ich
		 */
		//vybere iba Rootov ty mozu pridavat/mazat hociakych uzivatelov ostatny mozu len vo svojom klube
		
		$sql='SELECT id_user FROM `group_user` where id_group in (SELECT id_group FROM `group` where title= "Root" ) ';
		$stmt =$this->oDb->query($sql);
		$Root=false;
		while ($row = $stmt->fetch()){
			if ($row['id_user']==$_SESSION['id_user']) $Root=true;
		}
		
		if ($Root) $stmt =$this->oDb->query("SELECT id as value, nazov FROM `klub` ");
		else $stmt =$this->oDb->query("SELECT id as value, nazov FROM `klub` Where id=".$_SESSION['klubId']);
		
		$i=0; 
		while ($row = $stmt->fetch()){
			$values[$i]['value']=$row['value'];
			$values[$i]['name']=$row['nazov'];
			$i++;
		}
		$ret .= $this->oForm->selectBox("Klub", "klub", $values );
		$ret .= $this->oForm->optionBox("Able to login", "enabled", Array (
			Array (
				"name" => "Áno",
				"value" => 1
			),
			Array (
				"name" => "Nie",
				"value" => 0
			)
		), $this->pp($this->row, "enabled"));
		return parent::printForm($action, $id, $ret);
	}
	
	final function checkEmail($email = "") {
		if (!ereg("^[^@]{1,64}@[^@]{1,255}$", $email))
			return false;
		$email_array = explode("@", $email);
		$local_array = explode(".", $email_array[0]);
		for ($i = 0; $i < sizeof($local_array); $i++)
		if (!ereg("^(([A-Za-z0-9!#$%&'*+/=?^_`{|}~-][A-Za-z0-9!#$%&'*+/=?^_`{|}~\.-]{0,63})|(\"[^(\\|\")]{0,62}\"))$", $local_array[$i]))
			return false;
		if (!ereg("^\[?[0-9\.]+\]?$", $email_array[1])) {
			$domain_array = explode(".", $email_array[1]);
			if (sizeof($domain_array) < 2)
				return false;
			for ($i = 0; $i < sizeof($domain_array); $i++)
				if (!ereg("^(([A-Za-z0-9][A-Za-z0-9-]{0,61}[A-Za-z0-9])|([A-Za-z0-9]+))$", $domain_array[$i]))
					return false;
		}
		return true;
	}
	
	function sendMail($from, $to, $sub, $message) {
		$headers  = "From: ".$from."\n";
		$headers .= "Mime-Version: 1.0\n";
		$headers .= "Content-Type: text/html; charset=UTF-8\n";
		$headers .= "X-Mailer: PHP-".phpversion()."\n";
		//potom odpomentovat
		//mail($to, $sub, $message, $headers);
	}
	
	final function dbInsert() {
		$postData = $_POST;
		if (!$this->validateData($postData)) return;
		parent::dbInsert();
		//echo 'vorking id:'.$this->workingID;
		
		//TODO aby pridaval taku hodnost aku ma mat!
		$this->oDb->query("INSERT INTO `group_user` (id_group,id_user) VALUES ('2','".$this->workingID."')");
		$this->oDb->query("INSERT INTO `group_user` (id_group,id_user) VALUES ('1','".$this->workingID."')");
	}
	
	final function dbDelete($id) {
		$this->oDb->queryWithBids("DELETE FROM group_user WHERE id_user = ?", array($id));
		$tables = Array("perms","perms_init");
		foreach ($tables as $table) {

			$this->oDb->queryWithBids("DELETE FROM {$table}
				WHERE id_owner = ?
				AND owner_type = ?", array($id, 'user'));

			$this->oDb->queryWithBids("DELETE FROM {$table}
				WHERE id_user = ?", array($id));
		}
		parent::dbDelete($id);
	}

}

?>
