import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;



/**
 * @author Dana
 *
 */
public class FVstup extends JPanel implements ActionListener{
	private static final long serialVersionUID = 1L;
	private JTable t;
	private JScrollPane s;
	private JPanel panelTlacitka=new JPanel();
	private int max = 100;
	private JDialog owner;
	private JTextField velVstupu;
	private boolean uloz=false;
	private boolean koniec=false;
	public FVstup(JDialog owner){ 
		this.owner=owner;
		this.setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
		JPanel p= new JPanel();
		JLabel l= new JLabel(" Velkost vstupu: ");
		p.add(l);
		velVstupu = new JTextField();
		velVstupu.setText(Integer.toString(max));
		velVstupu.setPreferredSize(new Dimension(100,25));
		velVstupu.setActionCommand("Velkost");
		velVstupu.addActionListener(this);
		p.add(velVstupu);
		add(p);
		String nazvy[] = new String[2];
		nazvy[0] ="miesto";
		nazvy[1] = "hodnota";
		String C[][] = new String[max][2];
		for (int i = 0; i<max; i++){
			C[i][0]=Integer.toString(i+1);
			C[i][1]=Integer.toString(0);
		}
		t = new JTable(new DefaultTableModel(C,nazvy));
		s = new JScrollPane( t);
		s.setPreferredSize(new Dimension(300,300));
		add(s);
		JButton but1 = new JButton("Uloz");
		but1.setActionCommand("Uloz");
		but1.addActionListener(this);
		panelTlacitka.add(but1);
		JButton but2 = new JButton("Koniec");
		but2.setActionCommand("Koniec");
		but2.addActionListener(this);
		panelTlacitka.add(but2);
		add(panelTlacitka);
		setPreferredSize(new Dimension(325,400));
		setVisible(true);
   }
	
	public void zmenVelkost(int velkost){
		max=Math.min(velkost,max);
		remove(s);
		remove(panelTlacitka);
		s.remove(t);
		String nazvy[] = new String[2];
		nazvy[0] ="miesto";
		nazvy[1] = "hodnota";
		String C[][] = new String[velkost][2];
		for (int i = 0; i<max; i++){
			C[i][0]=Integer.toString(i+1);
			C[i][1]=(String) t.getValueAt(i,1);
		}
		if (max<velkost){
			for (int i = max; i<velkost; i++){
				C[i][0]=Integer.toString(i+1);
				C[i][1]=Integer.toString(0);
			}	
		}
		t = new JTable(new DefaultTableModel(C,nazvy));
		s = new JScrollPane( t);
		s.setPreferredSize(new Dimension(300,300));
		add(s);
		add(panelTlacitka);
		this.revalidate();
	}
	
	public void actionPerformed(ActionEvent e) {
		String command = e.getActionCommand();
		if (command.equals("Uloz")){
			uloz=true;
			owner.setVisible(false);
	
		}else if (command.equals("Koniec")){
			koniec=true;
			owner.setVisible(false);
		}else if (command.equals("Velkost")){
			String s=velVstupu.getText();
			if (s.matches("[0-9]+")){
				zmenVelkost(Integer.decode(s).intValue());
			}else{
				JOptionPane.showMessageDialog(this, "Chyba", "Zle zadan vekos vstupu",JOptionPane.PLAIN_MESSAGE);
			}
		}
	}
	public boolean isUloz(){
		return uloz;
	}
	public boolean isKoniec(){
		return koniec;
	}
	public void getFile(File f){
		int M =0;
		String s1=velVstupu.getText();
		if (s1.matches("[0-9]+")){
			M= new Integer(s1).intValue();
		}else{
			JOptionPane.showMessageDialog(this, "Chyba", "Zle zadan vekos vstupu",JOptionPane.PLAIN_MESSAGE);
			return;
		}
		Integer C[] = new Integer[M+1];
		C[0]=new Integer(M);
		for (int i=1; i<=M; i++){
			String s=(String) t.getValueAt(i-1,1);
			if (s.matches("[0-9]+")){
				C[i] = new Integer(s);
			}else{
				JOptionPane.showMessageDialog(this, "Chyba", "Chybne zadan "+ i+"-te slo",JOptionPane.PLAIN_MESSAGE);
				return;
			}
		}
		PrintWriter w = null;
		try {
			w = new PrintWriter(new FileWriter(f));
			for (int i=0; (i<=M); i++){
				w.println(C[i]);	
			}
			w.close();
		} catch (IOException e) {
			JOptionPane.showConfirmDialog(null,"Zle zadan sbor", "Error", JOptionPane.ERROR_MESSAGE);
		}
	}
	public void setFile(File f){
		//TODO upravit
		int M = 0;
		BufferedReader r = null;
		try {
			r = new BufferedReader(new FileReader(f));
			String l;
			if ((l = r.readLine()) != null){
				M =(Integer.decode(l)).intValue();
				t.setValueAt((new Integer(M)).toString(),0,1);
			}
			for (int i=1; (i<M); i++){
				if ((l = r.readLine()) != null){
					Integer j=Integer.decode(l); 
					t.setValueAt(j.toString(),i,1);
				}	
			}
			r.close();
		} catch (IOException e) {
			JOptionPane.showConfirmDialog(null,"Zle zadan sbor", "Error", JOptionPane.ERROR_MESSAGE);
		}
		for (int i = M; i<max;i++){
			t.setValueAt("0",i,1);
			
		}
	}

}
