
/**
 * @author Dana
 * TODO    zfunkcnit help
 */

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;

import javax.swing.*;

import programy.*;

public final class GUI extends JFrame implements ActionListener{
	
	private static final long serialVersionUID = 1L;
	private PProgram fProg;
	private POptions fOpt;
	private Pram prog;
	private JTabbedPane tabbedPane;
	private File fileProg;
	private int  pocProc;
	private String mod;
	private JTextArea chyby,prikazy;
	private String dir=null;;
	
	public GUI(){
		setVisible(false);
		createHlavny();
		setSize(700,420);
		
		JPanel p = new JPanel();
		BoxLayout bl = new BoxLayout(p, BoxLayout.X_AXIS);
		p.setLayout(bl);
		p.add(Box.createRigidArea(new Dimension(10,0)));
		
		
		//Editor na program
		JPanel panel = new JPanel();
		panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));
		fProg = new PProgram();
		fProg.init();
		fProg.velkost(new Dimension(300,325));
		panel.add(fProg,"program");
		panel.setMaximumSize(new Dimension(325,350));
		p.add(panel);
		
		p.add(Box.createRigidArea(new Dimension(10,0)));
		
		
		//		Ponuka vpravo
		panel=new JPanel();
		panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));
		panel.add(Box.createRigidArea(new Dimension(0,5)));
		fOpt = new POptions();
		fOpt.init(this);
		panel.add(fOpt);
		tabbedPane = new JTabbedPane();
		chyby=new JTextArea();
		JScrollPane s = new JScrollPane(chyby);
		//s.setPreferredSize(new Dimension(200,100));
		prikazy=new JTextArea();

		prikazy.setText("IDENT	Do reistra R0 zap index procesora\nCONST c	R[0]=c \nADD i	R0=[Ri]+ [R0]\nSUB i	R0=[Ri]- [R0]\nMULT c	R0=[Ri]*c\nDIV c	R0=[Ri]/c\nIFZERO i	Ak R0 obsahuje 0, pokrauj intrukciou i\nISLESS(i,j) k 	Ak plat Ri  < Rj, pokrauj intrukciou k\nGOTO i	Pokrauj intrukciou i\nHALT	Ukoni vpoet\n"+
				"a priradenia:\n"+"R[i]=R[j]\nC[i]=R[j]\nC[R[i]]=R[j]\nR[i]=C[j]\nR[i]=C[R[j]]\nR[i]=R[R[j]]\nC[i]=R[R[j]]\nR[R[j]]=R[j]\nR[R[j]]=C[j]\n[R[j]]=R[R[j]]\nR[R[j]]=C[R[j]]\nC[R[i]]= R[R[j]]\n");
		
		JScrollPane s1 = new JScrollPane(prikazy);
		
		
		//prikazy.setPreferredSize(new Dimension(200,100));
		tabbedPane.addTab("Zoznam prikazov",s1);
		tabbedPane.addTab("Chyby pri poslednej kompilacii:",s);
		tabbedPane.setPreferredSize(new Dimension(300,200));
		panel.add(tabbedPane);
		panel.add(Box.createRigidArea(new Dimension(0,10)));
		panel.setSize(new Dimension(300,325));
		panel.setPreferredSize(new Dimension(325,325));
		panel.setMaximumSize(new Dimension(325,325));
		
		p.add(panel);
		p.add(Box.createRigidArea(new Dimension(10,0)));
		add(p);
		this.setResizable(false);
		
		mod = "EREW";
		fileProg = null;
		pocProc = 1;
		fOpt.setPocetProcesorov(pocProc);
		fOpt.setMod(mod);
		this.setVisible(true);
	}
	
	//vytvorenie menu
	private void createHlavny(){
		//ramcek
		this.setTitle("Prostredie pre experimentovanie s PRAMami");
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		//menu
		JMenuBar menuBar;
		JMenu menu;
		JMenuItem menuItem;
	     
		menuBar = new JMenuBar();
		 
		menu = new JMenu("File");
		menuBar.add(menu);	 
		menuItem = new JMenuItem("Open");
		menuItem.addActionListener(this);
		menuItem.setActionCommand("open program");
		menu.add(menuItem);
	
		menuItem = new JMenuItem("Save");
		menuItem.addActionListener(this);
		menuItem.setActionCommand("save program");
		menu.add(menuItem);
		
	 
		menuItem = new JMenuItem("Save as");
		menuItem.addActionListener(this);
		menuItem.setActionCommand("save program as");
		menu.add(menuItem);

		menuItem = new JMenuItem("Print");
		menuItem.addActionListener(this);
		menuItem.setActionCommand("print");
		menu.add(menuItem);
		
	 
		menu.addSeparator();
		menuItem = new JMenuItem("Koniec prace");
		menuItem.setActionCommand("exit");
		menuItem.addActionListener(this);
		menu.add(menuItem);
	 
		menu = new JMenu("Program");
		menuBar.add(menu);
		menuItem = new JMenuItem("Nastav typ PRAMu");
		menuItem.addActionListener(this);
		menuItem.setActionCommand("mod");
		menu.add(menuItem);
		menuItem = new JMenuItem("Poet procesorov");
		menuItem.addActionListener(this);
		menuItem.setActionCommand("pocProc");
		menu.add(menuItem);
		menu.addSeparator();
		menuItem = new JMenuItem("Run");
		menuItem.setActionCommand("run");
		menuItem.addActionListener(this);
		menu.add(menuItem);
		menuItem = new JMenuItem("Step");
		menuItem.setActionCommand("step");
		menuItem.addActionListener(this);
		menu.add(menuItem);
		menuItem = new JMenuItem("Compile");
		menuItem.setActionCommand("compile");
		menuItem.addActionListener(this);
		menu.add(menuItem);
		
		menu = new JMenu("Autor");
		menuBar.add(menu);
		//menuItem = new JMenuItem("Help");
		//menuItem.setActionCommand("help");
		//menuItem.addActionListener(this);
		//menu.add(menuItem);
		//menu.addSeparator();
		menuItem = new JMenuItem("Autor");
		menuItem.setActionCommand("autor");
		menuItem.addActionListener(this);
		menu.add(menuItem);
 

     //menu do ramceka
		setJMenuBar(menuBar);
  }

	
	
	public void actionPerformed(ActionEvent e) {
		String command = e.getActionCommand();
		if (command.equals("exit")){
			System.exit(0);
		}else if (command.equals("run")){
			run();
		}else if (command.equals("step")){
			step();
		}else if (command.equals("compile")){
			compile();
		}else if (command.equals("autor")){
			autor();
		}else if (command.equals("open program")){
			openSProgram();
		}else if (command.equals("new program")){
			newProgram();
		}else if (command.equals("save program as")){
			saveSProgram();
		}else if (command.equals("save program")){
			saveProgram();
		}else if (command.equals("print")){
			fProg.print();
		}else if (command.equals("pocProc")){
			setPocProc();
		}else  if (command.equals("mod")){
			setMod();
		}else{
			//TODO  help
		}
	}

	private void compile() {
		String[] s= Pram.compile(fileProg);
		if ((s.length>1)){
			chyby.setText("");
			for (int i=0; i<s.length-1;i++){
				chyby.append(s[i]+"\n");
			}
			return;
		}
	}

	private void autor(){
		JLabel l[] = new JLabel[4];
		l[0] = new JLabel("Autor: Dana Smakov");
		l[1] = new JLabel("Projekt: Bakalrska prca");
		l[2] = new JLabel("Vedca bakalrskej prce: RNDr. Dana Pardubsk, PhD.");
		l[3] = new JLabel("Rok dokonenia: 2007");
		JPanel p = new JPanel();
		BoxLayout bl = new BoxLayout(p, BoxLayout.Y_AXIS);
		p.setLayout(bl);
		p.add(l[0]);
		p.add(l[1]);
		p.add(l[2]);
		p.add(l[3]);
		JOptionPane.showMessageDialog(this, p, "Autor", JOptionPane.INFORMATION_MESSAGE);
	}

	private void openSProgram(){
		int volba = JOptionPane.showConfirmDialog(this, "Chce uloit star program?", "Otzka", JOptionPane.YES_NO_CANCEL_OPTION, JOptionPane.QUESTION_MESSAGE);
		if (volba == JOptionPane.YES_OPTION){
			if (fileProg != null){
				saveProgram();
			}else{
				saveSProgram();
			}
		}
		if (!(volba==JOptionPane.CANCEL_OPTION)){
			JFileChooser fc = new JFileChooser(dir);
			fc.setDialogType(JFileChooser.OPEN_DIALOG);
			fc.setDialogTitle("Open program");
			if (fc.showDialog(this, "Open")==JFileChooser.APPROVE_OPTION){
				File f = fc.getSelectedFile();
				dir=f.getParent();
				if (!f.exists()){
					try {
						f.createNewFile();
					} catch (IOException e) {
						JOptionPane.showMessageDialog(this, "Neviem vytvorit subor s nazvom: "+f.getName(), "Error", JOptionPane.ERROR_MESSAGE);
						return;
					}
				}
				if (f.canRead()){
					fileProg = f;
					fProg.setFile(fileProg);
					
					//fOpt.setNazovProgramu(fileProg.getName());
				}else{
					JOptionPane.showMessageDialog(this, "Neviem precitat subor: "+f.getName(), "Error", JOptionPane.ERROR_MESSAGE);
					return;
				}
			}	
		}	
	}
	
	private void saveSProgram(){
		JFileChooser fc = new JFileChooser(dir);
		if (fc.showSaveDialog(this)==JFileChooser.APPROVE_OPTION){
			File f = fc.getSelectedFile();
			dir=f.getParent();
			if (!f.exists()){
				try {
					f.createNewFile();
				} catch (IOException e) {
					JOptionPane.showMessageDialog(this, "Neviem vytvorit subor s nazvom: "+f.getName(), "Error", JOptionPane.ERROR_MESSAGE);
					return;
				}
			}
			if (f.canWrite()){
				fProg.getFile(f);
				//fOpt.setNazovProgramu(f.getName());
				fileProg = f;
			}else{
				JOptionPane.showMessageDialog(this, "Neviem zapisat do suboru: "+f.getName(), "Error", JOptionPane.ERROR_MESSAGE);
				return;
			}
		}
	
	}
	
	private void saveProgram(){
		if (fileProg != null){
			fProg.getFile(fileProg);
		}else{
			saveSProgram();
		}	
	}
	
	private File openSVstup(){
		JFileChooser fc = new JFileChooser(dir);
		fc.setDialogTitle("Open vstup");
		fc.setDialogType(JFileChooser.OPEN_DIALOG);
		if (fc.showDialog(this, "Open")==JFileChooser.APPROVE_OPTION){
			File f = fc.getSelectedFile();
			dir=f.getParent();
			if (!f.exists()){
				try {
					f.createNewFile();
				} catch (IOException e) {
					JOptionPane.showMessageDialog(this, "Neviem vytvorit subor s nazvom: "+f.getName(), "Error", JOptionPane.ERROR_MESSAGE);
					return null;
				}
			}
			if (f.canRead()){
				return f;
			}else{
				JOptionPane.showMessageDialog(this, "Neviem precitat subor: "+f.getName(), "Error", JOptionPane.ERROR_MESSAGE);
				return null;
			}
		}
		return null;	
	}
	
	private File saveSVstup(FVstup fVstup){
		JFileChooser fc = new JFileChooser(dir);
		fc.setDialogTitle("Save vstup as");
		fc.setDialogType(JFileChooser.SAVE_DIALOG);
		if (fc.showDialog(this, "Save")==JFileChooser.APPROVE_OPTION){
			File f = fc.getSelectedFile(); 
			dir=f.getParent();
			if (!f.exists()){
				try {
					f.createNewFile();
				} catch (IOException e) {
					JOptionPane.showMessageDialog(this, "Neviem vytvorit subor s nazvom: "+f.getName(), "Error", JOptionPane.ERROR_MESSAGE);
					return null;
				}
			}
			if (f.canWrite()){
				fVstup.getFile(f);
				return f;
			}else{
				JOptionPane.showMessageDialog(this, "Neviem zapisat do suboru: "+f.getName(), "Error", JOptionPane.ERROR_MESSAGE);
				return null;
			}	
		}
		return null;
	}
	
	private void saveVstup(FVstup fVstup, File fileVstup){
		if (fileVstup != null){
			fVstup.getFile(fileVstup);
		}else 
			saveSVstup(fVstup);
	}


	private void newProgram() {
		openSProgram();
	}

	private File openSVystup() {
		JFileChooser fc = new JFileChooser(dir);
		fc.setDialogTitle("Open vystup");
		fc.setDialogType(JFileChooser.OPEN_DIALOG);
		if (fc.showDialog(this, "Open")==JFileChooser.APPROVE_OPTION){
			File f = fc.getSelectedFile();
			dir=f.getParent();
			if (!f.exists()){
				try {
					f.createNewFile();
				} catch (IOException e) {
					JOptionPane.showMessageDialog(this, "Neviem vytvorit subor s nazvom: "+f.getName(), "Error", JOptionPane.ERROR_MESSAGE);
					return null;
				}
			}
			if ((f.canWrite())&(f.canRead())){
				return f;
			}else{
				JOptionPane.showMessageDialog(this, "Neviem citat alebo zapisat do suboru: "+f.getName(), "Error", JOptionPane.ERROR_MESSAGE);
				return null;
			}
		}
		return null;
	}
	
	private int velkostVystupu(){
		String s =null; 
		s=	JOptionPane.showInputDialog(this, "Zadaj vekos vstupu:", "Vekos vstupu",JOptionPane.PLAIN_MESSAGE);
		if (!s.equals(null)){
			if (s.matches("[0-9]+")){
				return (new Integer(s).intValue());
			}else{
				JOptionPane.showMessageDialog(this, "Chyba", "Zle zadan vekos vstupu.",JOptionPane.PLAIN_MESSAGE);
				return -1;
			}
			
		}else{
			return -1;
		}

	}

	private void step() {
		String[] s= Pram.compile(fileProg);
		if ((s.length>1)){
			chyby.setText("");
			for (int i=0; i<s.length-1;i++){
				chyby.append(s[i]+"\n");
			}
			return;
		}
		File fileVstup = Vstup();
		if (fileVstup ==null) {
			return;
		}
		int velVystup = velkostVystupu();
		if (velVystup==-1) return;
		File fileVystup=null;
		if (velVystup!=0){
			fileVystup = Vystup();
			if (fileVystup ==null) {
				return;
			}
		}
		if ((fileProg != null)&((fileVystup != null)|(velVystup == 0))){
			try {
				if (mod.equals("EREW")) {
					prog = new EREWPram(fileProg, fileVstup, fileVystup, pocProc,  velVystup, 10);
				}else if (mod.equals("CREW")) {
					prog = new CREWPram(fileProg, fileVstup, fileVystup, pocProc,  velVystup, 10);
				}else if (mod.equals("PRIORITY CRCW")) {
					prog = new PriorityCRCWPram(fileProg, fileVstup, fileVystup, pocProc,  velVystup, 10);
				}else if (mod.equals("COMMON CRCW")) {
					prog = new CommonCRCWPram(fileProg, fileVstup, fileVystup, pocProc,  velVystup, 10);
				}
				File file = fileProg;
				PStep fStep = new PStep(file, prog, this);
			} catch (IOException e) {
			}
		}else{
			if (fileProg ==null){
				JOptionPane.showMessageDialog(this,"Nie je zadan sbor s programom", "Error", JOptionPane.ERROR_MESSAGE);
			}else if (fileVstup ==null){
				JOptionPane.showMessageDialog(this,"Nie je zadan vstupn sbor", "Error", JOptionPane.ERROR_MESSAGE);
			}else if ((fileVystup==null)&(velVystup>0)){
				JOptionPane.showMessageDialog(this,"Nie je zadan vstupn sbor", "Error", JOptionPane.ERROR_MESSAGE);
			}
		}
	
	}
	
	public void hotovo(File fileVystup, int velVyst){
		if (velVyst<=0){
			return;
		}
		JDialog d= new JDialog(this, "vstup", true);
		d.add(PPamat.zobrazSubor(fileVystup,velVyst));
		d.pack();
		d.setVisible(true);
	}
	
	private void run() {
		String[] s= Pram.compile(fileProg);
		if ((s.length>1)){
			chyby.setText("");
			for (int i=0; i<s.length-1;i++){
				chyby.append(s[i]+"\n");
			}
			return;
		}
		File fileVstup = Vstup();
		if (fileVstup ==null) {
			return;
		}
		int velVystup = velkostVystupu();
		if (velVystup==-1) return;
		File fileVystup=null;
		if (velVystup!=0){
			fileVystup = Vystup();
			if (fileVystup ==null) {
				return;
			}
		}
		if ((fileProg != null)&(fileVstup != null)&((fileVystup != null)|(velVystup == 0))){
			try {
				if (mod.equals("EREW")) {
					prog = new EREWPram(fileProg, fileVstup, fileVystup, pocProc, velVystup, 10);
				}else if (mod.equals("CREW")) {
					prog = new CREWPram(fileProg, fileVstup, fileVystup, pocProc, velVystup, 10);
				}else if (mod.equals("PRIORITY CRCW")) {
					prog = new PriorityCRCWPram(fileProg, fileVstup, fileVystup, pocProc, velVystup, 10);
				}else if (mod.equals("COMMON CRCW")) {
					prog = new CommonCRCWPram(fileProg, fileVstup, fileVystup, pocProc, velVystup, 10);
				}
				prog.Run();
				if ((!prog.padol())&(velVystup>0)){
					hotovo(prog.getFVystup(),prog.getVelkostVystupu());
				}
			} catch (IOException e) {
			}
		}else{
			if (fileProg ==null){
				JOptionPane.showMessageDialog(this,"Nie je zadan sbor s programom", "Error", JOptionPane.ERROR_MESSAGE);
			}else if (fileVstup ==null){
				JOptionPane.showMessageDialog(this,"Nie je zadan vstupn sbor", "Error", JOptionPane.ERROR_MESSAGE);
			}else if ((fileVystup==null)&(velVystup>0)){
				JOptionPane.showMessageDialog(this,"Nie je zadan vstupn sbor", "Error", JOptionPane.ERROR_MESSAGE);
			}
		}
	}



	private File Vystup() {
		return openSVystup();
	}
	
	private File Vstup() {
		int volba = JOptionPane.showConfirmDialog(this, "Chces vytvorit novy vstup?", "Vstup", JOptionPane.YES_NO_CANCEL_OPTION);
		if (volba==JOptionPane.YES_OPTION){
			JDialog d= new JDialog(this, "vstup", true);
			FVstup fVstup = new FVstup(d);
			d.add(fVstup);
			d.pack();
			d.setVisible(true);
			if (fVstup.isKoniec()){
				return null;
			}
			if (fVstup.isUloz()){
				return saveSVstup(fVstup);
			}
		}
		if (volba==JOptionPane.NO_OPTION){
			return openSVstup();
		}
		return null;
	}
	
	private void setMod() {
		String[] poss = {"EREW","CREW","PRIORITY CRCW","COMMON CRCW"};
		String s = (String) JOptionPane.showInputDialog(this, "Zadaj typ programu:", "Typ programu",JOptionPane.PLAIN_MESSAGE,null,poss,poss[0]);
		fOpt.setMod(s);
		mod = s;
	}

/*
	private void setVelPam() {
		//prog....
		String s =null; 
		s=	JOptionPane.showInputDialog(this, "Zadaj vekos pamte:", "Vekos pamte",JOptionPane.PLAIN_MESSAGE);
		if (!s.equals(null)){
			Integer i = new Integer(s.trim());
			velPam = i.intValue();
			fOpt.setVelkostPamete(i.intValue());
		}
	}
*/

	private void setPocProc() {
		//prog....
		String s =null;
		s = JOptionPane.showInputDialog(this, "Zadaj poet procesorov:", "Poet procesorov",JOptionPane.PLAIN_MESSAGE);
		if (!s.equals(null)){
			if (s.matches("[0-9]+")){
				Integer i = new Integer(s);
				pocProc = i.intValue();
				fOpt.setPocetProcesorov(i.intValue());
			}else{
				JOptionPane.showMessageDialog(this, "Chyba", "Zle zadan poet procesorov.",JOptionPane.PLAIN_MESSAGE);
			}
			
		}	
	}
    
}
