import java.awt.Dimension;
import java.awt.event.ActionListener;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;

/**
 * @author Dana
 *
 */
public class PColumns extends JPanel{
	
	private static final long serialVersionUID = 1L;
	private JTable t;
	private JScrollPane s;
	private JTextField pocStlpcov;
	private JButton but1;
	int max;
	
	PColumns(ActionListener act, int maxPoc){
		max=maxPoc;
		setSize(new Dimension(200,300));
		setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
		JPanel p= new JPanel();
		JLabel l=new JLabel("Pocet stlpcov:");
		p.add(l);
		pocStlpcov = new JTextField();
		pocStlpcov.setText(Integer.toString(1));
		pocStlpcov.setPreferredSize(new Dimension(100,25));
		pocStlpcov.setActionCommand("PocStlpcov");
		pocStlpcov.addActionListener(act);
		p.add(pocStlpcov);
		add(p);
		
		String nazvy[] = new String[3];
		nazvy[0] ="stlpec";
		nazvy[1] ="sada registrov";
		nazvy[2] ="poznamky";
		String C[][] = new String[1][3];
		C[0][0]=Integer.toString(1);
		C[0][1]=Integer.toString(0);
		C[0][2]="true";
		t = new JTable(new DefaultTableModel(C,nazvy));
		
		s = new JScrollPane( t);
		s.setPreferredSize(new Dimension(300,100));
		add(s);
		but1 = new JButton("Aply");
		but1.setActionCommand("Aply");
		but1.addActionListener(act);
		add(but1);
	}
	
	public void zmenPocetStlpcov(int pocet){
		int max=t.getRowCount();
		max=Math.min(pocet,max);
		remove(s);
		remove(but1);
		s.remove(t);
		String nazvy[] = new String[3];
		nazvy[0] ="miesto";
		nazvy[1] = "hodnota";
		nazvy[2] ="poznamky";
		String C[][] = new String[pocet][3];
		for (int i = 0; i<max; i++){
			C[i][0]=Integer.toString(i+1);
			C[i][1]=(String) t.getValueAt(i,1);
			C[i][2]=(String) t.getValueAt(i,2);
		}
		if (max<pocet){
			for (int i = max; i<pocet; i++){
				C[i][0]=Integer.toString(i+1);
				C[i][1]=Integer.toString(0);
				C[i][2]="false";
			}	
		}
		t = new JTable(new DefaultTableModel(C,nazvy));
		s = new JScrollPane( t);
		s.setPreferredSize(new Dimension(300,100));
		add(s);
		add(but1);
		this.revalidate();
	}
	
	public int getPocetStlpcov(){
		String s=pocStlpcov.getText();
		if (s==null){
			pocStlpcov.setText("1");
			return 1;
		}
		if (s.matches("[0-9]+")){
			return (new Integer(s).intValue());
		}else{
			JOptionPane.showMessageDialog(this, "Chyba", "Zle zadan procesor",JOptionPane.PLAIN_MESSAGE);
			pocStlpcov.setText("1");
			return 1;
		}
	}

	public int[] getStlpce(){
		int pocet=getPocetStlpcov();
		int[] stlpce=new int[pocet];
		for(int i=0;i<pocet;i++){
			String s=((String) t.getValueAt(i,1));
			if (s.charAt(0)!='C'){
				if (s==null){
					stlpce[i]=-1;
				}
				if (s.matches("[0-9]+")){
					stlpce[i]= (new Integer(s).intValue());
				}else{
					JOptionPane.showMessageDialog(this, "Chyba", "Zle zadan procesor",JOptionPane.PLAIN_MESSAGE);
					stlpce[i]=-1;
				}
				
			}else{
				stlpce[i]=max;
			}
		}
		return stlpce;
	}
	
	public boolean[] getPoznamky(){
		int pocet=getPocetStlpcov();
		boolean[] poznamky=new boolean[pocet];
		for(int i=0;i<pocet;i++){
			String s=((String) t.getValueAt(i,2));
			if (s.equals("true")){
				poznamky[i]=true;
			}else if (s.equals("false")){
				poznamky[i]=false;
				
			}else{
				String[] poss = {"false","true"};
				s = (String) JOptionPane.showInputDialog(null, "Zla hodnota v tabulke: \n "+"riadok "+i+", pre "+((String) t.getValueAt(i,1)), "error",JOptionPane.PLAIN_MESSAGE,null,poss,poss[0]);
				t.setValueAt(s,i,2);
				if (s.equals("true")) {
					poznamky[i]=true;
				}else{
					poznamky[i]=false;
				}
			}
		}
		return poznamky;
	}
}
