import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

import programy.Pram;

public class PPamat extends JPanel{
	
	private static final long serialVersionUID = 1L;
	private JTable t;
	private int[]columns;
	private String[] nazvy;
	private JScrollPane s;
	private int max = 1;
	private int poc;
	
	public void init(String name,int pocStlpcov){ 
		poc=pocStlpcov;
		columns=new int[2];
		columns[0]=0;
		columns[1]=1;
		
		nazvy = new String[3];
		nazvy[0] ="miesto";
		nazvy[1] = "R0";
		nazvy[2] = "popisky";
		String C[][] = new String[max][3];
		for (int i = 0; i<max; i++){
			C[i][0]=(new Integer(i)).toString();
			C[i][1]=(new Integer(0)).toString();
			C[i][2]="";
		}
		t = new JTable(new DefaultTableModel(C,nazvy));
		s = new JScrollPane( t);
		s.setPreferredSize(new Dimension(600,150));
		add(s);
	}
	
	public void velkost(Dimension d){
		s.setPreferredSize(d);
	}

	public void nastavenie(Pram pram, int[] stlpce, boolean[] poznamky){
		int pocet=stlpce.length+1;
		for(int i=0; i<poznamky.length;i++){
			if (poznamky[i]){
				pocet++;
			}
		}
		nazvy=new String[pocet];
		columns = new int[pocet-1];
		int j=1;
		nazvy[0]="miesto";
		for (int i=0; i<stlpce.length;i++){
			if (stlpce[i]<poc){
				nazvy[j]="R"+stlpce[i];
			}else{
				nazvy[j]="C";
			}
			columns[j-1]=stlpce[i]*2;
			j++;
			if (poznamky[i]){
				if (stlpce[i]<poc){
					nazvy[j]="koment "+stlpce[i];
				}else{
					nazvy[j]="koment C";
				}
				columns[j-1]=stlpce[i]*2+1;
				j++;
			}
		}
		max=pram.getMaxPamat();
		String C[][] = new String[max][pocet];
		for (int i = 0; i<max; i++){
			C[i][0]=(new Integer(i)).toString();
		}
		remove(s);
		t = new JTable(new DefaultTableModel(C,nazvy));
		s = new JScrollPane( t);
		s.setPreferredSize(new Dimension(600,150));
		add(s);
		setValues(pram);
	}
	public void setMax(int newMax){
		if (max>=newMax) return;
		max=newMax;
		String C[][] = new String[max][nazvy.length];
		for (int i = 0; i<max; i++){
			C[i][0]=(new Integer(i)).toString();
		}
		remove(s);
		t = new JTable(new DefaultTableModel(C,nazvy));
		s = new JScrollPane( t);
		s.setPreferredSize(new Dimension(600,150));
		add(s);
	}
	
	public void setValues(Pram pram){
		setMax(pram.getMaxPamat());
		for (int i=1; i<=columns.length;i++){
			int proc=columns[i-1];
			if (proc%2==0){
				if (proc/2==poc){
					int[] v=pram.getC();
					for (int j=0; j<v.length;j++){
						t.setValueAt(Integer.toString(v[j]),j,i);
					}
				}else{
					int[] v=pram.getR(proc/2);
					for (int j=0; j<v.length;j++){
						t.setValueAt(Integer.toString(v[j]),j,i);
					}
				}
			}else{
				proc--;
				if (proc/2==poc){
					String[] v=pram.getPozn();
					
					for (int j=0; j<v.length;j++){
						t.setValueAt(v[j],j,i);
					}
				}else{
					String[] v=pram.getPozn(proc/2);
					for (int j=0; j<v.length;j++){
						t.setValueAt(v[j],j,i);
					}
				}
				
			}
		}
	}
	public void select(int i,int j){
		t.changeSelection(i,j,false,false);
	}
	public void print(){
		try {
		    if (! t.print()) {
		        JOptionPane.showMessageDialog(null,"User cancelled printing");
		    }
		} catch (java.awt.print.PrinterException e) {
			JOptionPane.showMessageDialog(null,"Cannot print %s%n"+ e.getMessage());
		}


	}
	
	
	public void setEnabled(boolean b){
		t.setEnabled(b);
	}

	public static JPanel zobrazSubor(File f,int max){
		String nazvy[] = new String[2];
		nazvy[0] ="miesto";
		nazvy[1] = "hodnota";
		String C[][] = new String[max][2];
		for (int i = 0; i<max; i++){
			C[i][0]=(new Integer(i)).toString();
			C[i][1]=(new Integer(0)).toString();
		}
		JPanel p = new JPanel();
		JTable t = new JTable(new DefaultTableModel(C,nazvy));
		JScrollPane s = new JScrollPane( t);
		s.setPreferredSize(new Dimension(300,300));
		p.add(s);
		BufferedReader r = null;
		try {
			r = new BufferedReader(new FileReader(f));
			String l;
			
			for (int i=0; (i<max); i++){
				if ((l = r.readLine()) != null){
					t.setValueAt((Integer.decode(l)).toString(),i,1);
				}	
			}
			r.close();
		} catch (IOException e) {
			JOptionPane.showConfirmDialog(null,"Zle zadan sbor", "Error", JOptionPane.ERROR_MESSAGE);
		}
		
		return p;

	}
	
	
}
