
package programy;

import java.util.LinkedList;

import registre.Registre;
import registre.ZdielaneRegistre;


/**
 * @author Dana
 *
 */
public class Ram {
	protected Registre P;
	protected int cKroku = 0;
	protected boolean stav = false, padol = false;	
	protected int ident;
	
	public Ram(int id,int max){
		P=new Registre(max);
		ident = id;
	}
	public int getCInstr(){
		return cKroku;
	}
	public boolean getStav(){
		return stav;
	}
	public boolean padol(){
		return padol;
	}
	public void setStav(boolean s){
		stav = s;
	}
	public void setPadol(boolean s){
		padol = s;
	}
	


	public void Krok(int prikaz[],ZdielaneRegistre C,LinkedList pozn){
		if (prikaz[0]==0){
			nop();
			return;
		}
		if (prikaz[0]==1){
			halt();
			return;
		}
		if (prikaz[0]==2){
			ident();
			return;
		}
		if (prikaz[0]==3){
			cons(prikaz[1]);
			return;
		}
		if (prikaz[0]==4){
			add(prikaz[1]);
			return;
		}
		if (prikaz[0]==5){
			sub(prikaz[1]);
			return;
		}
		if (prikaz[0]==6){
			mult(prikaz[1]);
			return;
		}
		if (prikaz[0]==7){
			div(prikaz[1]);
			return;
		}
		if (prikaz[0]==8){
			goTo(prikaz[1]);
			return;
		}
		if (prikaz[0]==9){
			ifZero(prikaz[1]);
			return;
		}
		if (prikaz[0]==10){
			isLess(prikaz[1],prikaz[2],prikaz[3]);
			return;
		}
		if (prikaz[0]==11){
			if (prikaz[1]==0){
				if (prikaz[2]==0){
					prpr(prikaz[3],prikaz[4],pozn);
					return;
				}
				if (prikaz[2]==1){
					prpc(prikaz[3],prikaz[4],C,pozn);
					return;
				}
				if (prikaz[2]==2){
					prnr(prikaz[3],prikaz[4],pozn);
					return;
				}
				if (prikaz[2]==3){
					prnc(prikaz[3],prikaz[4],C,pozn);
					return;
				}
			}
			if (prikaz[1]==1){
				if (prikaz[2]==0){
					pcpr(prikaz[3],prikaz[4],C,pozn);
					return;
				}
				if (prikaz[2]==2){
					pcnr(prikaz[3],prikaz[4],C,pozn);
					return;
				}
			}
			if (prikaz[1]==2){
				if (prikaz[2]==0){
					nrpr(prikaz[3],prikaz[4],pozn);
					return;
				}
				if (prikaz[2]==1){
					nrpc(prikaz[3],prikaz[4],C,pozn);
					return;
				}
				if (prikaz[2]==2){
					nrnr(prikaz[3],prikaz[4],pozn);
					return;
				}
				if (prikaz[2]==3){
					nrnc(prikaz[3],prikaz[4],C,pozn);
					return;
				}
			}
			if (prikaz[1]==3){
				if (prikaz[2]==0){
					ncpr(prikaz[3],prikaz[4],C,pozn);
					return;
				}
				if (prikaz[2]==2){
					ncnr(prikaz[3],prikaz[4],C,pozn);
					return;
				}
			}
			stav=false;
		}
	}
	
	
	protected void ncnr(int i, int j, ZdielaneRegistre c, LinkedList pozn) {
		int pom=P.getR(i);
		if (!c.setR(pom,P.getR(P.getR(j)))){
			padol=true;
			stav=false;
			return;
		}
		if (c.padol()){
			padol=true;
			stav=false;
			return;
		}
		c.setPozn(pom,(String) pozn.get(cKroku));
		cKroku++;
	}


	protected void ncpr(int i, int j, ZdielaneRegistre c, LinkedList pozn) {
		int pom=P.getR(i);
		if (!c.setR(pom,P.getR(j))){
			padol=true;
			stav=false;
			return;
		}
		if (c.padol()){
			padol=true;
			stav=false;
			return;
		}
		c.setPozn(pom,(String) pozn.get(cKroku));
		cKroku++;
	}


	protected void nrnc(int i, int j, ZdielaneRegistre c, LinkedList pozn) {
		int pom=P.getR(i);
		if (!P.setR(pom,c.getR(P.getR(j)))){
			padol=true;
			stav=false;
			return;
		}
		if (c.padol()){
			padol=true;
			stav=false;
			return;
		}
		P.setPozn(pom,(String) pozn.get(cKroku));
		cKroku++;
	}


	protected void nrpc(int i, int j, ZdielaneRegistre c, LinkedList pozn) {
		int pom=P.getR(i);
		if (!P.setR(pom,c.getR(j))){
			padol=true;
			stav=false;
			return;
		}
		if (c.padol()){
			padol=true;
			stav=false;
			return;
		}
		P.setPozn(pom,(String) pozn.get(cKroku));
		cKroku++;
	}


	protected void pcnr(int i, int j, ZdielaneRegistre c, LinkedList pozn) {
		int pom=i;
		if (!c.setR(pom,P.getR(P.getR(j)))){
			padol=true;
			stav=false;
			return;
		}
		if (c.padol()){
			padol=true;
			stav=false;
			return;
		}
		c.setPozn(pom,(String) pozn.get(cKroku));
		cKroku++;
	}


	protected void pcpr(int i, int j, ZdielaneRegistre c, LinkedList pozn) {
		int pom=i;
		if (!c.setR(pom,P.getR(j))){
			padol=true;
			stav=false;
			return;
		}
		if (c.padol()){
			padol=true;
			stav=false;
			return;
		}
		c.setPozn(pom,(String) pozn.get(cKroku));
		cKroku++;
	}


	protected void prnc(int i, int j, ZdielaneRegistre c, LinkedList pozn) {
		int pom=i;
		if (!P.setR(pom,c.getR(P.getR(j)))){
			padol=true;
			stav=false;
			return;
		}
		if (c.padol()){
			padol=true;
			stav=false;
			return;
		}
		P.setPozn(pom,(String) pozn.get(cKroku));
		cKroku++;
	}


	protected void prpc(int i, int j, ZdielaneRegistre c, LinkedList pozn) {
		int pom=i;
		if (!P.setR(pom,c.getR(j))){
			padol=true;
			stav=false;
			return;
		}
		if (c.padol()){
			padol=true;
			stav=false;
			return;
		}
		P.setPozn(pom,(String) pozn.get(cKroku));
		cKroku++;
	}

	protected void nrnr(int i, int j, LinkedList pozn) {
		if (!P.setR(P.getR(i),P.getR(P.getR(j)))){
			padol=true;
			stav=false;
			return;
		}
		P.setPozn(P.getR(i),(String) pozn.get(cKroku));
		cKroku++;
	}
	
	protected void nrpr(int i, int j, LinkedList pozn) {
		if (!P.setR(P.getR(i),P.getR(j))){
			padol=true;
			stav=false;
			return;
		}
		P.setPozn(P.getR(i),(String) pozn.get(cKroku));
		cKroku++;
	}
	
	protected void prnr(int i, int j, LinkedList pozn) {
		if (!P.setR(i,P.getR(P.getR(j)))){
			padol=true;
			stav=false;
			return;
		}
		P.setPozn(i,(String) pozn.get(cKroku));
		cKroku++;
	}

	protected void prpr(int i, int j, LinkedList pozn) {
		if (!P.setR(i,P.getR(j))){
			padol=true;
			stav=false;
			return;
		}
		P.setPozn(i,(String) pozn.get(cKroku));
		
		cKroku++;
	}
	
	private void isLess(int i, int j, int k) {
		if (P.getR(i)<P.getR(j)){
			cKroku=k;
		}else{
			cKroku++;
		}
		
	}
	
	private void ifZero(int i) {
		if (P.getR0()==0){
			cKroku=i;
		}else{
			cKroku++;
		}
		
	}
	
	private void goTo(int i) {
		cKroku=i;
	}
	
	private void div(int c) {
		P.setR(P.getR0()/c);
		
		cKroku++;
	
	}
	private void mult(int c) {
		P.setR(P.getR0()*c);
		
		cKroku++;
	
	}
	
	private void sub(int i) {
		P.setR(P.getR0()-P.getR(i));
		cKroku++;
		
	}
	
	private void add(int i) {
		P.setR(P.getR0()+P.getR(i));
		cKroku++;
		
		
	}
	
	private void cons(int c) {
		P.setR(c);
		
		cKroku++;
	}
	
	public int[] getR() {
		return P.getReg();
		
	}
	
	public String[] getPozn(){
		return P.getPozn();
		
	}
	
	protected void ident() {
		P.setR(ident);
		
		cKroku++;
	}
	protected void halt() {
		stav = false;
	}

	protected void nop() {
		cKroku++;
	}

	public int getMaxPamat(){
		return P.getVelkost();
		
	}
}
