#include <stdio.h> 
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

int load_user_from_file(char *filename, char **login, char **heslo);
int hladaj(FILE **file, char *filename, char *command, char **parameter, int *pocet_riadkov);
int vrat_ip_port(char *filenameadr, char **ip_adress, char **ip_port);

int mdconnect_and_auth(){
  char *filenameadress = "/usr/local/etc/mdemon/mdemonadr.conf";
  char *filenameuser = "/usr/local/etc/mdemon/mdemonusr.conf";
  char *login = NULL;
  char *heslo = NULL;
  char *ip = NULL;
  char *port = NULL;
  int fd = 0;
  int res = 0;

  if (((res = load_user_from_file(filenameuser, &login, &heslo)) != 0) || (login == NULL) || (heslo == NULL))
  {
    fprintf(stderr, "%s: nepodarilo sa nacitat pouzivatela\n", filenameadress);
    return -1;
  }
  if (((res = vrat_ip_port(filenameadress, &ip, &port)) != 0) || (ip == NULL) || (port == NULL))
  {
    fprintf(stderr, "%s: nepodarilo sa nacitat internetovu adresu kde pocuva mdemon\n", filenameadress);
    return -1;
  }
  
  if ( (fd = mdconnect(ip, port)) < 0)
  { 
    fprintf(stderr, "nepodarilo sa pripojit na server\n"); 
    return -1;
  }
  else if (mdauth(fd, login, heslo) != 0)
  {
    return -1;
  }
  else
    return fd;
}


int load_user_from_file(char *filename, char **login, char **heslo){
  
  int pocet_riadkov = 0;
  int i = 0;
  int len = 0;
  int line_max = 1024;
  char *riadok;
  int hladaj = 1;
  int pom = 0;   
  
  if (filename == NULL)
  {
    fprintf(stderr, "1. argument(filename) nesmie byt NULL\n");
    return 1;
  }
  else if (login == NULL)
  {
    fprintf(stderr, "2 argument(login) nesmie byt NULL\n");
    return 1;
  }
  else if (heslo == NULL)
  {
    fprintf(stderr, "3.argument(heslo) nesmie byt NULL\n");
    return 1;
  }
  
  FILE *file;
  file = fopen(filename, "r");
  if (file == NULL)
  {
    return 1;
  }
  
  *login = (char *) malloc(257*sizeof(char));
  *heslo = (char *) malloc(257*sizeof(char));
  riadok = (char *) malloc((line_max+1)*sizeof(char));
   
  while (fgets(riadok, line_max, file) != NULL)
  {
    pocet_riadkov++;
    len = strlen(riadok);
    if (len == line_max){
      printf("%s: riadok %d je dlhsi ako %d znakov\n", filename, pocet_riadkov, line_max);
      //syslog(LOG_ERR, "%s: riadok %d je dlhsi ako %d znakov\n", filename, pocet_riadkov, line_max);
      //return 1;
    }
    else if(riadok[0] == '#')
    {
      // nasli sme odkomentovany riadok a neriesime ho
    }
    else if ((pom = sscanf(riadok, "%256s %256s", (*login), (*heslo))) == 2)
    {
      if (strlen((*login)) == 256)
      {
	printf("riadok %d suboru users.conf sa nepodarilo spracovat: login je dlhsi ako 255 znakov\n", pocet_riadkov);
	//syslog(LOG_ERR, "riadok %d suboru users.conf sa nepodarilo spracovat: login je dlhsi ako 255 znakov\n", pocet_riadkov);
      }
      else if (strlen((*heslo)) == 256)
      {
	printf("riadok %d suboru users.conf sa nepodarilo spracovat: heslo je dlhsie ako 255 znakov\n", pocet_riadkov);
	//syslog(LOG_ERR, "riadok %d suboru users.conf sa nepodarilo spracovat: heslo je dlhsie ako 255 znakov\n", pocet_riadkov);
      }
      else
      {
	return 0;
      }
    }
    else if (pom == 1)
    {
      printf("%s: riadok %d suboru sa nepodarilo spracovat: ocakavany login a heslo\n", filename, pocet_riadkov);
      //syslog(LOG_ERR, "%s: riadok %d suboru sa nepodarilo spracovat: ocakavany login a heslo\n", filename, pocet_riadkov);
    }
    else
    {
      //pravdepodobne prazdny riadok
    }
  }
  return 0;
}

int hladaj(FILE **file, char *filename, char *command, char **parameter, int *pocet_riadkov)
{
  int hladaj = 1;
  int line_max = 1000;
  char *kommand; 
  kommand = malloc(256*sizeof(char));
  char *riadok;
  riadok = (char *) malloc((line_max+3)*sizeof(char));
  int len = 0;
  //command = malloc(256*sizeof(char));
  (*parameter) = malloc(256*sizeof(char));

  
  while (hladaj) 
  {
    if (fgets(riadok, (line_max+3), (*file)) == NULL)
      return 1;
    
    (*pocet_riadkov)++;
    len = strlen(riadok);
    if (len > line_max){
      printf("%s: riadok %d je dlhsi ako %d znakov\n", filename, *pocet_riadkov, line_max);
      //syslog(LOG_ERR, "%s: riadok %d je dlhsi ako %d znakov\n", filename, *pocet_riadkov, line_max);
      //return 1;
    }
    if (riadok[0] == '#')
    {
    }
    else if (sscanf(riadok, "%255s %255s", kommand, (*parameter)) == 2)
    {
      if (strcmp(kommand, command) == 0)
	return 0;
    }
  }
}

int vrat_ip_port(char *filenameadr, char **ip_adress, char **ip_port){
  
  int line_max = 1000; // riadok nesmie mat viac ako 1000 znakov oficialne
  int hladame = 1;
  int hladaj_ip = 0;
  
  FILE *file;
  file = fopen(filenameadr, "r");
  if (file == NULL)
  {
    //perror("nenasiel sa konfiguracny subor s adresou programu MDemon");
    //syslog(LOG_ERR, "%s: %m\n", filenameadr);
    return 1;
  }
  else if(ip_adress == NULL)
  {
    return 1;
  }
  else if (ip_port == NULL)
  {
    return 1;
  }
  
  char *command; 
  command = malloc(256*sizeof(char));
  char *parameter;
  parameter = malloc(256*sizeof(char));
  char *riadok;
  int pocet_riadkov = 0;
  int len = 0;
  riadok = (char *) malloc((line_max+3)*sizeof(char));
  
  
  if (hladaj(&file, filenameadr, "IP", ip_adress, &pocet_riadkov) != 0)
  {
    //printf("%s: subor neobsahuje povinne nastavenie %s\n", filenameadr, "IP");
    //syslog(LOG_ERR, "%s: subor neobsahuje povinne nastavenie %s\n", filenameusr, "IP");
    return 1;
  }
  if (hladaj(&file, filenameadr, "PORT", ip_port, &pocet_riadkov) != 0)
  {
    //printf("%s: subor neobsahuje povinne nastavenie %s\n", filenamadr, "PORT");
    //syslog(LOG_ERR, "%s: subor neobsahuje povinne nastavenie %s\n", filenameadr, "PORT");
    return 1;
  }
  return 0;
}
