#include <sys/types.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <signal.h>
#include <string.h>

int closepppd(int n){
  
  char *filepppdname; 
  if ((filepppdname = (char *) malloc(100*sizeof(char))) == NULL)
  {
    //perror("malloc:");
    return 1;
  }
  sprintf(filepppdname, "/var/run/ppp%d.pid", n);
  
  FILE *filepppd;
  filepppd = fopen(filepppdname, "r");
  if (filepppdname == NULL)
  {
    //perror("fopen:");
    return 1;
  }
  
  int pid;  
  if (fscanf(filepppd, "%d", &pid) != 1)
  {
    fprintf(stderr, "subor %s je prazdny alebo ma neplatny tvar", filepppdname);
    return 1;
  }
  else
    fclose(filepppd);
  
  if (kill(pid, 2) == -1)
  {
    //perror("kill:");
    return 1;
  }
  else
  {
    //printf("closepppd succeeded\n");
    //sleep(2);
    return 0;
  }
}
