/*
  mdpinger.c - sluzi na zistenie vypadku internetu - kazdych 10 min posle 5-krat echo-request na google.com a martinus.sk 
               ak sa nevrati ani jeden echo-response z uvedenych adries, pokusi sa poslat sms pomocou programu MDemon na cislo tel s textom textsms
	       ak sms bola uspesne odoslana, pinger skonci, inak pokracuje vo svojej cinnosti dalej.
	     - svoj pid uklada po daemonizaci do pidfilename - ak sa mu nepodari otvorit subor a zapisat pid skonci s chybou 
*/
#include <sys/types.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include "../mdemonapllib/mdemonapl.h"
#include "ping.h"

int main(int argc, char *argv[]){

  char *tel = "+421908123456";
  char *textsms = "stratilo sa spojenie do internetu";
  char *pidfilename = "/usr/local/etc/mdemon/mdpinger.pid";

  int fd;
  
  // nacitanie vstupnych parametrov
  openlog("mdemon/pinger", LOG_PID|LOG_CONS, LOG_USER);
  if (argc != 1)
  {
    //perror("zle vstupne data: nespravny pocet argumentov");
    syslog(LOG_ERR, "zle vstupne data: nespravny pocet argumentov - %m");
    //printf("zle vstupne data: nespravny pocet argumentov\n");
    return -1;
  }
  
  if (daemon(0, 0) != 0)
  {
    perror("daemonizacia:");
    syslog(LOG_ERR, "damenizacia - %m");
  }
  
  FILE *file;
  file = fopen(pidfilename, "w");
  if (file == NULL)
  {
    //perror("file open:");
    syslog(LOG_ERR, "%m");
    return 1;
  }
  fprintf(file, "%d", getpid());
  if (fclose(file) == -1)
  {
    //perror("file close:");
    syslog(LOG_ERR, "%m");
    return 1;
  }
  
  while(1){
    //printf("som hore\n");
    if ((cmd_ping("74.125.87.147") != 0) && (cmd_ping("217.67.31.52") != 0))
    {
      //printf("nemame spojenie\n");
      fd = mdconnect_and_auth();
      if (fd < 0)
      {
	//perror("nepodarilo sa pripojit na mdemon\n");
	syslog(LOG_ERR,"MDemon connect: %m");
	return 1;
      }
      else if (mdsend_sms(fd, tel, textsms) == 0)
	return 0;    
      else
	close(fd);
    }
    sleep(600);
  }
}  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
