/*
 * Decompiled with CFR 0.152.
 */
package d.d;

import d.d.MainFrame;
import d.d.ProcGen;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class MapPanel
extends JPanel {
    MainFrame frame;
    static final int Main = 1;
    static final int HeroesEditor = 2;
    static final int HeroesManagment = 3;
    static final int Battle = 4;
    static final int Creatures = 5;
    static final int Map = 6;
    static final int GRASS = 1;
    static final int WATER = 2;
    static final int ROCK = 3;
    static final int TREE = 4;
    static final int GROUND_STONE = 5;
    static final int WALL_STONE = 6;
    static final int FIRE = 7;
    static final int TABLE = 8;
    static final int CUPBOARD = 9;
    static final int CHEST = 10;
    static final int LTABLER = 11;
    static final int LTABLEL = 12;
    static final int CHAIR = 13;
    static final int BED = 14;
    static final int ARMORY = 15;
    static final int SELECTION = 200;
    static final int DELETE = 201;
    public static final int SquareSize = 25;
    int Selected = 6;
    int width;
    int height;
    int MapWidth = 50;
    int MapHeight = 50;
    boolean pressedZ = false;
    int selectedItem = -1;
    Random rn;
    Square[][] squares;
    int XC = -5;
    int YC = -5;
    int cY = 0;
    int cX = 0;
    int seed;
    MapPanel MP = this;
    SelectionPanel SPanel;
    DrawPanel DPanel;
    JFrame cframe;
    JPanel opt;
    JFrame optFrame;
    Keyboard keyboard;
    ProcGen procgen;
    JTextField SeedField;
    JTextField countExactly;
    JComboBox cor;
    JComboBox pot;
    ArrayList<ChangesOfSquares> changeSquares;
    ArrayList<ChangesOpt> changeOpts = new ArrayList();
    ArrayList<def> defOfRooms;
    boolean PG = false;
    boolean preSet = false;
    boolean loaded = false;

    public MapPanel(MainFrame frame) throws IOException {
        this.frame = frame;
        this.OptPanel();
    }

    private void OptPanel() {
        this.optFrame = new JFrame();
        this.optFrame.setSize(this.frame.getWidth() / 2, this.frame.getHeight() / 3);
        this.optFrame.setVisible(true);
        this.optFrame.setLocation(this.frame.width / 2 - this.optFrame.getSize().width / 2, this.frame.height / 2 - this.optFrame.getSize().height / 2);
        this.opt = new JPanel();
        this.opt.setPreferredSize(new Dimension(this.frame.getWidth() / 3, this.frame.getHeight() / 8));
        this.add(this.opt);
        this.opt.setVisible(true);
        Box VBox = Box.createVerticalBox();
        Box b1 = Box.createHorizontalBox();
        this.opt.add(VBox);
        b1.add(new JLabel("Choose:"));
        b1.add(Box.createRigidArea(new Dimension(20, 10)));
        JButton nm = new JButton("Normal mode");
        nm.setPreferredSize(new Dimension(500, 200));
        JButton gen = new JButton("Generating");
        gen.setPreferredSize(new Dimension(500, 200));
        Box b3 = Box.createHorizontalBox();
        b3.add(nm);
        b3.add(Box.createRigidArea(new Dimension(20, 0)));
        b3.add(gen);
        VBox.add(b1);
        VBox.add(Box.createRigidArea(new Dimension(0, 20)));
        VBox.add(b3);
        this.optFrame.add(this.opt);
        this.optFrame.setAlwaysOnTop(true);
        gen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapPanel.this.optFrame.dispose();
                MapPanel.this.PG = true;
                MapPanel.this.SizePanel();
            }
        });
        nm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapPanel.this.optFrame.dispose();
                MapPanel.this.SizePanel();
            }
        });
    }

    private void SizePanel() {
        this.optFrame = new JFrame();
        this.optFrame.setSize(this.frame.getWidth() / 2, this.frame.getHeight() / 3);
        this.optFrame.setVisible(true);
        this.optFrame.setLocation(this.frame.width / 2 - this.optFrame.getSize().width / 2, this.frame.height / 2 - this.optFrame.getSize().height / 2);
        this.opt = new JPanel();
        this.opt.setPreferredSize(new Dimension(this.frame.getHeight() / 2, this.frame.getWidth() / 4));
        this.add(this.opt);
        this.opt.setVisible(true);
        Box VBox = Box.createVerticalBox();
        Box b1 = Box.createHorizontalBox();
        Box b2 = Box.createHorizontalBox();
        Box b3 = Box.createHorizontalBox();
        Box b4 = Box.createHorizontalBox();
        Box b5 = Box.createHorizontalBox();
        this.opt.add(VBox);
        b1.add(new JLabel("Write dimensions:"));
        b1.add(Box.createRigidArea(new Dimension(20, 10)));
        final JTextField f1 = new JTextField("50");
        final JTextField f2 = new JTextField("50");
        b2.add(f1);
        b2.add(f2);
        JButton ok = new JButton("ok");
        ok.setMaximumSize(new Dimension(100, 200));
        JButton storno = new JButton("storno");
        ok.setMaximumSize(new Dimension(100, 200));
        b3.add(ok);
        b3.add(Box.createRigidArea(new Dimension(20, 0)));
        b3.add(storno);
        b4.add(new JLabel("min: 40, max: 99"));
        b5.add(new JLabel("Maps not big enough may not fit in all the rooms"));
        VBox.add(b1);
        VBox.add(Box.createRigidArea(new Dimension(0, 20)));
        VBox.add(b2);
        VBox.add(Box.createRigidArea(new Dimension(0, 20)));
        VBox.add(b3);
        VBox.add(Box.createRigidArea(new Dimension(0, 20)));
        VBox.add(b4);
        VBox.add(b5);
        this.optFrame.add(this.opt);
        this.optFrame.setAlwaysOnTop(true);
        storno.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapPanel.this.frame.ChangePanel(1);
                MapPanel.this.optFrame.dispose();
            }
        });
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (MapPanel.isInt(f1.getText()) && MapPanel.isInt(f2.getText())) {
                    int w = Integer.parseInt(f1.getText());
                    int h = Integer.parseInt(f1.getText());
                    if (w > 39 && w < 100 && h > 39 && h < 100) {
                        MapPanel.this.MapWidth = w;
                        MapPanel.this.MapHeight = h;
                        MapPanel.this.optFrame.dispose();
                        if (MapPanel.this.PG) {
                            MapPanel.this.ProcOptPanel();
                        } else {
                            MapPanel.this.SetMapPanel();
                        }
                    }
                }
            }
        });
    }

    private void ProcOptPanel() {
        boolean x = false;
        boolean y = false;
        this.optFrame = new JFrame();
        this.optFrame.setSize(this.frame.getWidth() / 2, this.frame.getHeight() / 3);
        this.optFrame.setVisible(true);
        this.optFrame.setLocation(this.frame.width / 2 - this.optFrame.getSize().width / 2, this.frame.height / 2 - this.optFrame.getSize().height / 2);
        this.opt = new JPanel();
        this.opt.setPreferredSize(new Dimension(this.frame.getHeight() / 3, this.frame.getWidth() / 8));
        this.add(this.opt);
        this.opt.setVisible(true);
        String[] countStrings = new String[]{"void", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"};
        final JComboBox<String> c = new JComboBox<String>(countStrings);
        String[] patStrings = new String[]{"void", "Labyrinth", "Trough", "Sun"};
        final JComboBox<String> p = new JComboBox<String>(patStrings);
        JButton man = new JButton("Rooms managment");
        c.setMaximumSize(new Dimension(200, 20));
        p.setMaximumSize(new Dimension(200, 20));
        man.setMaximumSize(new Dimension(200, 20));
        Box VBox = Box.createVerticalBox();
        Box b1 = Box.createHorizontalBox();
        Box b2 = Box.createHorizontalBox();
        Box b3 = Box.createHorizontalBox();
        Box b0 = Box.createHorizontalBox();
        b1.add(new JLabel("Count of rooms: "));
        b1.add(c);
        b2.add(new JLabel("Pattern: "));
        b2.add(p);
        b3.add(new JLabel("Rooms managment: "));
        b3.add(man);
        Box b = Box.createHorizontalBox();
        JButton yes = new JButton("yes");
        yes.setMaximumSize(new Dimension(100, 200));
        JButton no = new JButton("no");
        yes.setMaximumSize(new Dimension(100, 200));
        b.add(yes);
        b.add(Box.createRigidArea(new Dimension(20, 0)));
        b.add(no);
        b0.add(new JLabel("Do you have idea?"));
        VBox.add(b0);
        VBox.add(b1);
        VBox.add(b2);
        VBox.add(b3);
        VBox.add(b);
        this.opt.add(VBox);
        no.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapPanel.this.PG = true;
                try {
                    MapPanel.this.procgen = new ProcGen(MapPanel.this.MP);
                }
                catch (IOException ex) {
                    Logger.getLogger(MapPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                MapPanel.this.procgen.setSquares(MapPanel.this.squares);
                MapPanel.this.SetMapPanel();
            }
        });
        yes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapPanel.this.preSet = true;
                MapPanel.this.PG = true;
                try {
                    MapPanel.this.procgen = new ProcGen(MapPanel.this.MP);
                }
                catch (IOException ex) {
                    Logger.getLogger(MapPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                MapPanel.this.procgen.setSquares(MapPanel.this.squares);
                MapPanel.this.SetMapPanel();
                if (c.getSelectedIndex() != 0) {
                    MapPanel.this.countExactly.setEnabled(true);
                    MapPanel.this.countExactly.setText(c.getSelectedIndex() + "");
                    MapPanel.this.cor.setSelectedIndex(4);
                }
                if (p.getSelectedIndex() != 0) {
                    MapPanel.this.pot.setSelectedIndex(p.getSelectedIndex() - 1);
                }
                MapPanel.this.generate();
            }
        });
        man.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RoomManager m = new RoomManager(c.getSelectedIndex());
            }
        });
        this.optFrame.add(this.opt);
    }

    private void SetMapPanel() {
        this.optFrame.dispose();
        this.width = this.frame.getWidth();
        this.height = this.frame.getHeight();
        this.frame.repaint();
        this.keyboard = new Keyboard();
        this.frame.add(this.keyboard);
        this.keyboard.requestFocusInWindow();
        this.DPanel = new DrawPanel(this.MapWidth, this.MapHeight, null);
        this.SPanel = new SelectionPanel();
        this.setLayout(new FlowLayout());
        this.DPanel.setPreferredSize(new Dimension(2 * this.width / 3 - 40, this.height - 80));
        this.SPanel.setPreferredSize(new Dimension(this.width / 3 - 40, this.height - 80));
        this.add(this.DPanel);
        this.add(this.SPanel);
        JMenuBar menuBar = new JMenuBar();
        this.frame.setJMenuBar(menuBar);
        JMenu file = new JMenu("File");
        menuBar.add(file);
        JMenuItem newF = new JMenuItem("New");
        JMenuItem open = new JMenuItem("Open");
        JMenuItem save = new JMenuItem("Save");
        JMenuItem savePG = new JMenuItem("PG Save");
        JMenuItem exit = new JMenuItem("Return to Menu");
        file.add(newF);
        file.add(open);
        file.add(save);
        file.add(savePG);
        file.addSeparator();
        file.add(exit);
        this.frame.setVisible(true);
        this.setVisible(true);
        exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapPanel.this.frame.ChangePanel(1);
            }
        });
        newF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapPanel.this.frame.ChangePanel(6);
            }
        });
        open.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!MapPanel.this.PG) {
                    try {
                        Square[][] sq = MapPanel.this.open();
                        if (sq != null) {
                            MapPanel.this.DPanel.repaintMap(sq);
                            MapPanel.this.repaint();
                        }
                    }
                    catch (FileNotFoundException ex) {
                        Logger.getLogger(MapPanel.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(MapPanel.class.getName()).log(Level.SEVERE, null, ex);
                    }
                } else {
                    try {
                        MapPanel.this.open();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(MapPanel.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    if (MapPanel.this.loaded) {
                        MapPanel.this.PG = false;
                        MapPanel.this.SPanel.changePanel();
                        MapPanel.this.XC = -5;
                        MapPanel.this.YC = -5;
                        MapPanel.this.cY = 0;
                        MapPanel.this.cX = 0;
                        MapPanel.this.keyboard.requestFocusInWindow();
                        MapPanel.this.loaded = false;
                    }
                }
            }
        });
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    MapPanel.this.save(MapPanel.this.squares);
                }
                catch (IOException ex) {
                    Logger.getLogger(MapPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        savePG.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    MapPanel.this.savePG();
                }
                catch (IOException ex) {
                    Logger.getLogger(MapPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
    }

    private Square[][] open() throws FileNotFoundException, IOException {
        JFrame open = new JFrame("OPEN");
        JPanel op = new JPanel();
        op.setLayout(new BorderLayout());
        JTextArea log = new JTextArea(5, 20);
        log.setMargin(new Insets(5, 5, 5, 5));
        log.setEditable(false);
        JScrollPane logScrollPane = new JScrollPane(log);
        JFileChooser fc = new JFileChooser();
        op.add((Component)logScrollPane, "Center");
        if (this.PG) {
            JOptionPane.showMessageDialog(this.frame, "You can open procedural generated maps only");
        } else {
            JOptionPane.showMessageDialog(this.frame, "You can open drawn maps only");
        }
        int returnVal = fc.showOpenDialog(op);
        if (returnVal == 0) {
            Square[][] sq = new Square[this.MapWidth][this.MapHeight];
            File file = fc.getSelectedFile();
            BufferedReader br = new BufferedReader(new FileReader(file.getPath()));
            this.loaded = true;
            if (this.PG) {
                String option;
                int n;
                int n2;
                String[] stringArray;
                String str = br.readLine();
                String[] options = str.split(" ");
                this.SeedField.setText(options[0]);
                int count = Integer.parseInt(options[1]);
                if (count < 0) {
                    this.cor.setSelectedIndex(4);
                    this.countExactly.setText(Math.abs(count) + "");
                } else {
                    this.cor.setSelectedIndex(count);
                }
                this.pot.setSelectedIndex(Integer.parseInt(options[2]));
                this.MapWidth = Integer.parseInt(options[3]);
                this.MapHeight = Integer.parseInt(options[4]);
                this.DPanel = new DrawPanel(this.MapWidth, this.MapHeight, null);
                this.procgen.setSize(this.MapWidth, this.MapHeight);
                this.procgen.setSquares(this.squares);
                this.generate();
                str = br.readLine();
                if (!"X".equals(str)) {
                    stringArray = options = str.split(" ");
                    n2 = stringArray.length;
                    for (n = 0; n < n2; ++n) {
                        str = option = stringArray[n];
                        this.changeOpts.add(new ChangesOpt(str));
                    }
                }
                if (!"X".equals(str = br.readLine())) {
                    stringArray = options = str.split(" ");
                    n2 = stringArray.length;
                    for (n = 0; n < n2; ++n) {
                        str = option = stringArray[n];
                        this.changeSquares.add(new ChangesOfSquares(str));
                    }
                }
            } else {
                for (int i = 0; i < this.MapHeight; ++i) {
                    String str = br.readLine();
                    String[] strs = str.split(" ");
                    for (int j = 0; j < this.MapWidth; ++j) {
                        sq[i][j] = new Square(i, j, Integer.parseInt(strs[j]));
                    }
                }
            }
            return sq;
        }
        open.pack();
        open.setVisible(true);
        this.frame.repaint();
        open.dispose();
        return null;
    }

    private void savePG() throws IOException {
        JFrame save = new JFrame("SAVE");
        JPanel op = new JPanel();
        op.setLayout(new BorderLayout());
        JTextArea log = new JTextArea(5, 20);
        log.setMargin(new Insets(5, 5, 5, 5));
        log.setEditable(false);
        JScrollPane logScrollPane = new JScrollPane(log);
        JFileChooser fc = new JFileChooser();
        op.add((Component)logScrollPane, "Center");
        int returnVal = fc.showSaveDialog(save);
        if (returnVal == 0) {
            File f = fc.getSelectedFile();
            BufferedWriter output = new BufferedWriter(new FileWriter(f));
            String str = this.cor.getSelectedIndex() < 4 ? "" + this.seed + " " + this.cor.getSelectedIndex() + " " + this.pot.getSelectedIndex() : "" + this.seed + " " + "-" + this.countExactly.getText() + " " + this.pot.getSelectedIndex();
            str = str + " " + this.MapWidth + " " + this.MapHeight;
            output.write(str);
            output.newLine();
            str = "";
            if (!this.changeOpts.isEmpty()) {
                for (ChangesOpt change : this.changeOpts) {
                    str = str + change.print() + " ";
                }
            } else {
                str = str + "X";
            }
            output.write(str);
            output.newLine();
            str = "";
            if (!this.changeSquares.isEmpty()) {
                for (ChangesOfSquares changeSquare : this.changeSquares) {
                    str = str + changeSquare.print() + " ";
                }
            } else {
                str = str + "X";
            }
            output.write(str);
            output.close();
        }
    }

    private void save(Square[][] sq) throws IOException {
        JFrame save = new JFrame("SAVE");
        JPanel op = new JPanel();
        op.setLayout(new BorderLayout());
        JTextArea log = new JTextArea(5, 20);
        log.setMargin(new Insets(5, 5, 5, 5));
        log.setEditable(false);
        JScrollPane logScrollPane = new JScrollPane(log);
        JFileChooser fc = new JFileChooser();
        op.add((Component)logScrollPane, "Center");
        int returnVal = fc.showSaveDialog(save);
        if (returnVal == 0) {
            File f = fc.getSelectedFile();
            BufferedWriter output = new BufferedWriter(new FileWriter(f));
            for (Square[] sq1 : sq) {
                String str = "";
                for (Square sq11 : sq1) {
                    str = str + Integer.toString(sq11.data) + " ";
                }
                output.write(str);
                output.newLine();
            }
            output.close();
        }
    }

    public void makeChange(int x, int y, int prev, int act) {
        Iterator<ChangesOfSquares> iterator = this.changeSquares.iterator();
        while (iterator.hasNext()) {
            ChangesOfSquares changeSquare;
            ChangesOfSquares tmp = changeSquare = iterator.next();
            if (tmp.x != x || tmp.y != y) continue;
            changeSquare.actual = act;
            return;
        }
        this.changeSquares.add(new ChangesOfSquares(x, y, prev, act));
    }

    public Square[][] getSquares() {
        return this.squares;
    }

    public void repaintMap() {
        this.repaint();
    }

    public void readKeyboard() {
        this.keyboard.requestFocusInWindow();
    }

    public void generate() {
        String str = this.SeedField.getText();
        this.clearMap();
        this.seed = !str.isEmpty() ? Integer.parseInt(str) : Math.abs(this.rn.nextInt());
        this.SeedField.setText(this.seed + "");
        this.procgen.setSeed(this.seed);
        this.procgen.setPattern(this.pot.getSelectedIndex());
        if (this.cor.getSelectedIndex() < 4) {
            this.procgen.setCountOfRooms(this.cor.getSelectedIndex());
        } else {
            this.procgen.setCountOfRoomsExactly(Integer.parseInt(this.countExactly.getText()));
        }
        try {
            this.procgen.Generate();
            for (def defOfRoom : this.defOfRooms) {
                this.procgen.changeType(defOfRoom.room, defOfRoom.type);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(MapPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void clearMap() {
        for (int i = 0; i < this.MapWidth; ++i) {
            for (int j = 0; j < this.MapHeight; ++j) {
                this.squares[i][j].data = 6;
            }
        }
    }

    public void abort() {
        JOptionPane.showMessageDialog(this.frame, "I can't generate map. Too small map?");
    }

    public static boolean isInt(String str) {
        try {
            int n = Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    class def {
        int room;
        int type;

        public def(int r, int t) {
            this.room = r;
            this.type = t;
        }
    }

    final class ChangesOpt {
        int room;
        int type;

        public ChangesOpt(int r, int t) {
            this.room = r;
            this.type = t;
        }

        public ChangesOpt(String str) throws IOException {
            if (str.length() > 2) {
                this.room = Integer.parseInt(str.substring(0, 2));
                this.type = Integer.parseInt(str.substring(2));
            } else {
                this.room = str.charAt(0);
                this.type = str.charAt(1);
            }
            this.changeOpt();
        }

        public void changeOpt() throws IOException {
            MapPanel.this.procgen.changeType(this.room, this.type);
        }

        public String print() {
            String str = this.room < 10 ? "0" + this.room : this.room + "";
            str = str + this.type;
            return str;
        }
    }

    final class ChangesOfSquares {
        int x;
        int y;
        int initial = -1;
        int actual;

        public ChangesOfSquares(int x, int y, int prev, int act) {
            this.x = x;
            this.y = y;
            this.actual = act;
            if (this.initial == -1) {
                this.initial = prev;
            }
        }

        public ChangesOfSquares(String str) {
            this.x = Integer.parseInt(str.substring(0, 2));
            this.y = Integer.parseInt(str.substring(2, 4));
            this.actual = Integer.parseInt(str.substring(4));
            this.changeSquare();
        }

        public String print() {
            String str = this.x < 10 ? "0" + this.x : this.x + "";
            str = this.y < 10 ? str + "0" + this.y : str + this.y;
            str = str + this.actual;
            return str;
        }

        public void changeSquare() {
            MapPanel.this.squares[this.x][this.y].data = this.actual;
        }
    }

    class KeyboarddListener
    implements KeyListener {
        KeyboarddListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            Square[] square;
            int n;
            int n2;
            Square[][] squareArray;
            if (e.getKeyChar() == 'w') {
                MapPanel.this.YC = -1;
                --MapPanel.this.cY;
                squareArray = MapPanel.this.squares;
                n2 = squareArray.length;
                for (n = 0; n < n2; ++n) {
                    for (Square square1 : square = squareArray[n]) {
                        square1.changeY();
                    }
                }
            }
            if (e.getKeyChar() == 's') {
                MapPanel.this.YC = 1;
                ++MapPanel.this.cY;
                squareArray = MapPanel.this.squares;
                n2 = squareArray.length;
                for (n = 0; n < n2; ++n) {
                    for (Square square1 : square = squareArray[n]) {
                        square1.changeY();
                    }
                }
            }
            if (e.getKeyChar() == 'a') {
                MapPanel.this.XC = -1;
                --MapPanel.this.cX;
                squareArray = MapPanel.this.squares;
                n2 = squareArray.length;
                for (n = 0; n < n2; ++n) {
                    for (Square square1 : square = squareArray[n]) {
                        square1.changeX();
                    }
                }
            }
            if (e.getKeyChar() == 'd') {
                MapPanel.this.XC = 1;
                ++MapPanel.this.cX;
                squareArray = MapPanel.this.squares;
                n2 = squareArray.length;
                for (n = 0; n < n2; ++n) {
                    for (Square square1 : square = squareArray[n]) {
                        square1.changeX();
                    }
                }
            }
            MapPanel.this.repaint();
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }

    class Keyboard
    extends JPanel {
        public Keyboard() {
            KeyboarddListener listener = new KeyboarddListener();
            this.addKeyListener(listener);
            this.requestFocusInWindow();
            this.setFocusable(true);
        }
    }

    class RoomManager
    extends JFrame {
        public RoomManager() {
            JPanel p = new JPanel();
            this.add(p);
            final ArrayList<ProcGen.Room> rooms = MapPanel.this.procgen.rooms;
            this.setSize(300, rooms.size() * 50);
            final ArrayList<JComboBox<String>> boxes = new ArrayList<JComboBox<String>>();
            String[] roomsStrings = new String[]{"Kitchen", "Living Room", "Armory"};
            final ArrayList<JButton> buttons = new ArrayList<JButton>();
            Box vb = Box.createVerticalBox();
            for (int i = 0; i < rooms.size(); ++i) {
                Box b = Box.createHorizontalBox();
                b.add(new JLabel("Room " + i + ":"));
                JComboBox<String> combo = new JComboBox<String>(roomsStrings);
                boxes.add(combo);
                combo.setMaximumSize(new Dimension(400, 100));
                combo.setSelectedIndex(rooms.get((int)i).type.type);
                final JButton ch = new JButton("change");
                buttons.add(ch);
                ch.setMaximumSize(new Dimension(400, 100));
                b.add(combo);
                b.add(ch);
                vb.add(b);
                ch.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            MapPanel.this.procgen.changeType(buttons.indexOf(ch), ((JComboBox)boxes.get(buttons.indexOf(ch))).getSelectedIndex());
                            MapPanel.this.changeOpts.add(new ChangesOpt(buttons.indexOf(ch), ((JComboBox)boxes.get(buttons.indexOf(ch))).getSelectedIndex()));
                            RoomManager.this.repaint();
                            MapPanel.this.keyboard.requestFocusInWindow();
                        }
                        catch (IOException ex) {
                            Logger.getLogger(MapPanel.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                });
            }
            this.setVisible(true);
            JButton ok = new JButton("ok");
            Box b1 = Box.createHorizontalBox();
            b1.add(ok);
            vb.add(b1);
            p.add(vb);
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (int i = 0; i < rooms.size(); ++i) {
                        if (((ProcGen.Room)rooms.get((int)i)).type.type == ((JComboBox)boxes.get(i)).getSelectedIndex()) continue;
                        try {
                            for (int j = 0; j < MapPanel.this.defOfRooms.size(); ++j) {
                                if (MapPanel.this.defOfRooms.get((int)j).room != i) continue;
                                MapPanel.this.defOfRooms.remove(j);
                            }
                            MapPanel.this.procgen.changeType(i, ((JComboBox)boxes.get(i)).getSelectedIndex());
                            MapPanel.this.changeOpts.add(new ChangesOpt(i, ((JComboBox)boxes.get(i)).getSelectedIndex()));
                            RoomManager.this.repaint();
                            MapPanel.this.keyboard.requestFocusInWindow();
                            RoomManager.this.dispose();
                            continue;
                        }
                        catch (IOException ex) {
                            Logger.getLogger(MapPanel.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    RoomManager.this.dispose();
                }
            });
        }

        public RoomManager(int x) {
            final int c = x;
            JPanel p = new JPanel();
            this.add(p);
            this.setSize(300, c * 50);
            final ArrayList<JComboBox<String>> boxes = new ArrayList<JComboBox<String>>();
            String[] roomsStrings = new String[]{"void", "Kitchen", "Living Room", "Armory"};
            this.setVisible(true);
            Box Vb = Box.createVerticalBox();
            for (int i = 0; i < c; ++i) {
                Box b = Box.createHorizontalBox();
                b.add(new JLabel("Room " + i + ":"));
                JComboBox<String> combo = new JComboBox<String>(roomsStrings);
                boxes.add(combo);
                combo.setMaximumSize(new Dimension(400, 100));
                b.add(combo);
                Vb.add(b);
            }
            Box b1 = Box.createHorizontalBox();
            JButton ok = new JButton("ok");
            b1.add(ok);
            Vb.add(b1);
            p.add(Vb);
            MapPanel.this.defOfRooms = new ArrayList();
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (int i = 0; i < c; ++i) {
                        if (((JComboBox)boxes.get(i)).getSelectedIndex() <= 0) continue;
                        MapPanel.this.defOfRooms.add(new def(i, ((JComboBox)boxes.get(i)).getSelectedIndex() - 1));
                        MapPanel.this.changeOpts.add(new ChangesOpt(i, ((JComboBox)boxes.get(i)).getSelectedIndex() - 1));
                    }
                    RoomManager.this.dispose();
                }
            });
        }
    }

    final class SelectionPanel
    extends JPanel {
        public SelectionPanel() {
            this.setBackground(Color.LIGHT_GRAY);
            this.setBorder(BorderFactory.createLineBorder(Color.black));
            this.setLayout(new BoxLayout(this, 1));
            this.setVisible(true);
            this.changePanel();
        }

        public void changePanel() {
            this.removeAll();
            if (MapPanel.this.PG) {
                MapPanel.this.rn = new Random();
                if (MapPanel.this.changeSquares == null) {
                    MapPanel.this.changeSquares = new ArrayList();
                }
                if (MapPanel.this.changeOpts == null) {
                    MapPanel.this.changeOpts = new ArrayList();
                }
                if (MapPanel.this.defOfRooms == null) {
                    MapPanel.this.defOfRooms = new ArrayList();
                }
                MapPanel.this.procgen.setSize(MapPanel.this.MapWidth, MapPanel.this.MapHeight);
                MapPanel.this.procgen.setSquares(MapPanel.this.squares);
                MapPanel.this.SeedField = new JTextField("");
                JButton gen = new JButton("Generate");
                String[] countStrings = new String[]{"Few", "Some", "Many", "A lot of", "Exactly"};
                MapPanel.this.cor = new JComboBox<String>(countStrings);
                String[] patStrings = new String[]{"Labyrinth", "Trough", "Sun"};
                MapPanel.this.pot = new JComboBox<String>(patStrings);
                JButton ok = new JButton("OK");
                JButton man = new JButton("Rooms managment");
                JButton rand = new JButton("Random");
                JButton chs = new JButton("Change");
                MapPanel.this.countExactly = new JTextField("");
                MapPanel.this.cor.setSelectedIndex(0);
                MapPanel.this.cor.setMaximumSize(new Dimension(200, 20));
                MapPanel.this.SeedField.setMaximumSize(new Dimension(200, 20));
                gen.setMaximumSize(new Dimension(200, 20));
                ok.setMaximumSize(new Dimension(200, 20));
                rand.setMaximumSize(new Dimension(200, 20));
                man.setMaximumSize(new Dimension(200, 20));
                MapPanel.this.pot.setMaximumSize(new Dimension(200, 20));
                chs.setMaximumSize(new Dimension(100, 20));
                MapPanel.this.countExactly.setMaximumSize(new Dimension(200, 20));
                rand.setAlignmentX(0.5f);
                MapPanel.this.cor.setAlignmentX(0.5f);
                MapPanel.this.SeedField.setAlignmentX(0.5f);
                gen.setAlignmentX(0.5f);
                ok.setAlignmentX(0.5f);
                man.setAlignmentX(0.5f);
                MapPanel.this.pot.setAlignmentX(0.5f);
                MapPanel.this.countExactly.setAlignmentX(0.5f);
                Box b1 = Box.createHorizontalBox();
                b1.add(MapPanel.this.SeedField);
                b1.add(chs);
                this.add(b1);
                this.add(MapPanel.this.cor);
                this.add(MapPanel.this.countExactly);
                this.add(MapPanel.this.pot);
                this.add(rand);
                this.add(man);
                this.add(gen);
                this.add(ok);
                if (!MapPanel.this.preSet) {
                    this.makeRandomValues();
                    MapPanel.this.countExactly.setEnabled(false);
                }
                ok.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        MapPanel.this.PG = false;
                        SelectionPanel.this.changePanel();
                        MapPanel.this.keyboard.requestFocusInWindow();
                    }
                });
                gen.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        MapPanel.this.generate();
                    }
                });
                rand.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SelectionPanel.this.makeRandomValues();
                        MapPanel.this.generate();
                    }
                });
                man.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        RoomManager m = new RoomManager();
                    }
                });
                chs.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MapPanel.this.SeedField.setText(Math.abs(MapPanel.this.rn.nextInt()) + "");
                        MapPanel.this.generate();
                    }
                });
                MapPanel.this.cor.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (MapPanel.this.cor.getSelectedIndex() == 4) {
                            MapPanel.this.countExactly.setEnabled(true);
                        } else {
                            MapPanel.this.countExactly.setText("");
                            MapPanel.this.countExactly.setEnabled(false);
                        }
                    }
                });
            } else {
                if (MapPanel.this.changeSquares == null) {
                    MapPanel.this.changeSquares = new ArrayList();
                }
                JButton ground = new JButton("Ground");
                JButton water = new JButton("Water");
                JButton rock = new JButton("Rock");
                JButton tree = new JButton("Tree");
                JButton ground_stone = new JButton("Ground");
                JButton wall_stone = new JButton("Wall");
                JButton sel = new JButton("Select");
                JButton ite = new JButton("Item");
                JButton del = new JButton("DELETE");
                ground.setMaximumSize(new Dimension(100, 50));
                water.setMaximumSize(new Dimension(100, 50));
                rock.setMaximumSize(new Dimension(100, 50));
                tree.setMaximumSize(new Dimension(100, 50));
                ground_stone.setMaximumSize(new Dimension(100, 50));
                wall_stone.setMaximumSize(new Dimension(100, 50));
                sel.setMaximumSize(new Dimension(100, 50));
                ite.setMaximumSize(new Dimension(100, 50));
                del.setMaximumSize(new Dimension(100, 50));
                ground.setAlignmentX(0.5f);
                water.setAlignmentX(0.5f);
                rock.setAlignmentX(0.5f);
                tree.setAlignmentX(0.5f);
                ground_stone.setAlignmentX(0.5f);
                wall_stone.setAlignmentX(0.5f);
                sel.setAlignmentX(0.5f);
                ite.setAlignmentX(0.5f);
                del.setAlignmentX(0.5f);
                this.add(Box.createRigidArea(new Dimension(0, 20)));
                this.add(ground_stone);
                this.add(Box.createRigidArea(new Dimension(0, 20)));
                this.add(wall_stone);
                this.add(Box.createRigidArea(new Dimension(0, 20)));
                this.add(sel);
                this.add(Box.createRigidArea(new Dimension(0, 20)));
                this.add(ite);
                this.add(Box.createRigidArea(new Dimension(0, 20)));
                this.add(del);
                ground.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        MapPanel.this.Selected = 1;
                        MapPanel.this.keyboard.requestFocusInWindow();
                    }
                });
                water.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        MapPanel.this.Selected = 2;
                        MapPanel.this.keyboard.requestFocusInWindow();
                    }
                });
                rock.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        MapPanel.this.Selected = 3;
                        MapPanel.this.keyboard.requestFocusInWindow();
                    }
                });
                tree.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        MapPanel.this.Selected = 4;
                        MapPanel.this.keyboard.requestFocusInWindow();
                    }
                });
                ground_stone.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        MapPanel.this.Selected = 5;
                        MapPanel.this.keyboard.requestFocusInWindow();
                    }
                });
                wall_stone.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        MapPanel.this.Selected = 6;
                        MapPanel.this.keyboard.requestFocusInWindow();
                    }
                });
                sel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        MapPanel.this.Selected = 200;
                        MapPanel.this.keyboard.requestFocusInWindow();
                    }
                });
                ite.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        SelectionPanel.this.addItem();
                        MapPanel.this.keyboard.requestFocusInWindow();
                    }
                });
                del.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        MapPanel.this.Selected = 201;
                        MapPanel.this.keyboard.requestFocusInWindow();
                    }
                });
            }
            this.revalidate();
            this.repaint();
            MapPanel.this.keyboard.requestFocusInWindow();
        }

        public void addItem() {
            final JFrame f = new JFrame();
            f.setSize(150, 300);
            JPanel p = new JPanel();
            f.add(p);
            String[] itemStrings = new String[]{"Fire", "Table", "Chair", "Armory", "Chest", "Bed", "Cupboard"};
            final JComboBox<String> combo = new JComboBox<String>(itemStrings);
            combo.setMaximumSize(new Dimension(400, 100));
            combo.setSelectedIndex(0);
            p.add(combo);
            f.setVisible(true);
            JButton ok = new JButton("ok");
            p.add(ok);
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int choice = combo.getSelectedIndex();
                    switch (choice) {
                        case 0: {
                            MapPanel.this.Selected = 7;
                            break;
                        }
                        case 1: {
                            MapPanel.this.Selected = 8;
                            break;
                        }
                        case 2: {
                            MapPanel.this.Selected = 13;
                            break;
                        }
                        case 3: {
                            MapPanel.this.Selected = 15;
                            break;
                        }
                        case 4: {
                            MapPanel.this.Selected = 10;
                            break;
                        }
                        case 5: {
                            MapPanel.this.Selected = 14;
                            break;
                        }
                        case 6: {
                            MapPanel.this.Selected = 9;
                        }
                    }
                    f.dispose();
                }
            });
        }

        private void makeRandomValues() {
            MapPanel.this.SeedField.setText(Math.abs(MapPanel.this.rn.nextInt()) + "");
            MapPanel.this.cor.setSelectedIndex(Math.abs(MapPanel.this.rn.nextInt(4)));
            MapPanel.this.pot.setSelectedIndex(Math.abs(MapPanel.this.rn.nextInt(3)));
        }
    }

    class DrawPanel
    extends JPanel {
        int x;
        int y;

        public void repaintMap(Square[][] sq) {
            for (int i = 0; i < MapPanel.this.squares.length; ++i) {
                for (int j = 0; j < MapPanel.this.squares[i].length; ++j) {
                    MapPanel.this.Selected = sq[i][j].data;
                    MapPanel.this.squares[i][j].ChangeGround();
                }
            }
            this.repaint();
        }

        public DrawPanel(int x, int y, Square[][] sq) {
            this.x = x;
            this.y = y;
            this.setSize(new Dimension(x * 25, y * 25));
            MapPanel.this.squares = new Square[x][y];
            this.setBorder(BorderFactory.createLineBorder(Color.black));
            for (int i = 0; i < x; ++i) {
                for (int j = 0; j < y; ++j) {
                    MapPanel.this.squares[i][j] = new Square(i, j);
                }
            }
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    DrawPanel.this.findSquare(e.getX(), e.getY()).ChangeGround();
                    DrawPanel.this.repaint();
                    MapPanel.this.keyboard.requestFocusInWindow();
                }
            });
            MapPanel.this.keyboard.requestFocusInWindow();
        }

        private Square findSquare(int x, int y) {
            return MapPanel.this.squares[(x + MapPanel.this.cX * 25) / 25][(y + MapPanel.this.cY * 25) / 25];
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.drawImage(new ImageIcon("resources/map.jpg").getImage(), 0, 0, this.getWidth(), this.getHeight(), null);
            Square[][] squareArray = MapPanel.this.squares;
            int n = squareArray.length;
            for (int i = 0; i < n; ++i) {
                Square[] square;
                for (Square sq : square = squareArray[i]) {
                    sq.paintSquare(g);
                }
            }
        }
    }

    public class Square {
        int x;
        int y;
        int Xposition;
        int Yposition;
        Square predecessor = null;
        boolean seen = false;
        int size = 25;
        int data = 6;

        public void setX(int x) {
            this.x = x;
        }

        public int getX() {
            return this.x;
        }

        public void setY(int y) {
            this.y = y;
        }

        public int getY() {
            return this.y;
        }

        public Square(int x, int y) {
            this.Xposition = x;
            this.Yposition = y;
            this.x = x * this.size;
            this.y = y * this.size;
        }

        public Square(int x, int y, int c) {
            this.Xposition = x;
            this.Yposition = y;
            this.x = x * this.size;
            this.y = y * this.size;
            this.data = c;
        }

        public void changeY() {
            this.y -= MapPanel.this.YC * 25;
        }

        public void changeX() {
            this.x -= MapPanel.this.XC * 25;
        }

        public void paintSquare(Graphics g) {
            if (this.x < 1 || this.y < 1) {
                return;
            }
            g.fillRect(this.x, this.y, this.size, this.size);
            g.drawRect(this.x, this.y, this.size, this.size);
            if (this.data == 5) {
                g.drawImage(new ImageIcon("resources/img/ground_stone.jpg").getImage(), this.x + 1, this.y + 1, 25, 25, null);
            }
            if (this.data == 6) {
                g.drawImage(new ImageIcon("resources/img/wall_stone.jpg").getImage(), this.x + 1, this.y + 1, 25, 25, null);
            }
            if (this.data == 7) {
                g.drawImage(new ImageIcon("resources/img/fire.jpg").getImage(), this.x + 1, this.y + 1, 25, 25, null);
            }
            if (this.data == 9) {
                g.drawImage(new ImageIcon("resources/img/cupboard.jpg").getImage(), this.x + 1, this.y + 1, 25, 25, null);
            }
            if (this.data == 13) {
                g.drawImage(new ImageIcon("resources/img/chair.jpg").getImage(), this.x + 1, this.y + 1, 25, 25, null);
            }
            if (this.data == 12) {
                g.drawImage(new ImageIcon("resources/img/ltable.jpg").getImage(), this.x + 1, this.y + 1, 25, 25, null);
            }
            if (this.data == 8) {
                g.drawImage(new ImageIcon("resources/img/table.jpg").getImage(), this.x + 1, this.y + 1, 25, 25, null);
            }
            if (this.data == 14) {
                g.drawImage(new ImageIcon("resources/img/bed.jpg").getImage(), this.x + 1, this.y + 1, 25, 25, null);
            }
            if (this.data == 10) {
                g.drawImage(new ImageIcon("resources/img/chest.jpg").getImage(), this.x + 1, this.y + 1, 25, 25, null);
            }
            if (this.data == 15) {
                g.drawImage(new ImageIcon("resources/img/armory.jpg").getImage(), this.x + 1, this.y + 1, 25, 25, null);
            }
        }

        public void ChangeGround() {
            if (MapPanel.this.Selected == 200) {
                if (MapPanel.this.selectedItem != -1) {
                    MapPanel.this.makeChange(this.Xposition, this.Yposition, this.data, MapPanel.this.selectedItem);
                    this.data = MapPanel.this.selectedItem;
                    MapPanel.this.selectedItem = -1;
                } else if (this.data > 6 && MapPanel.this.selectedItem == -1) {
                    MapPanel.this.makeChange(this.Xposition, this.Yposition, this.data, 5);
                    MapPanel.this.selectedItem = this.data;
                    this.data = 5;
                }
            } else if (MapPanel.this.Selected == 201) {
                if (this.data > 6) {
                    MapPanel.this.makeChange(this.Xposition, this.Yposition, this.data, 5);
                    this.data = 5;
                }
            } else {
                MapPanel.this.makeChange(this.Xposition, this.Yposition, this.data, MapPanel.this.Selected);
                this.data = MapPanel.this.Selected;
            }
        }
    }
}

