/*
 * Decompiled with CFR 0.152.
 */
package d.d;

import d.d.MapPanel;
import d.d.MersenneTwister;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;

public class ProcGen {
    static final int GRASS = 1;
    static final int WATER = 2;
    static final int ROCK = 3;
    static final int TREE = 4;
    static final int GROUND_STONE = 5;
    static final int WALL_STONE = 6;
    static final int FIRE = 7;
    static final int TABLE = 8;
    static final int CUPBOARD = 9;
    static final int CHEST = 10;
    static final int LTABLER = 11;
    static final int LTABLEL = 12;
    static final int CHAIR = 13;
    static final int BED = 14;
    static final int ARMORY = 15;
    static final int KITCHEN = 0;
    static final int LIVINGROOM = 1;
    static final int ARMORYROOM = 2;
    int SquareSize = 25;
    MapPanel MP;
    MersenneTwister MT;
    private int seed;
    private int countOfRooms = -1;
    MapPanel.Square[][] squares;
    int countOfOpt;
    int pattern;
    int height = 50;
    int width = 50;
    ArrayList<Room> rooms;
    MapPanel.Square[] room;

    public ProcGen(MapPanel mp) throws IOException {
        this.MP = mp;
    }

    public void setSquares(MapPanel.Square[][] s) {
        this.squares = s;
    }

    public void setSize(int w, int h) {
        this.width = w;
        this.height = h;
    }

    public void setSeed(int s) {
        this.MT = new MersenneTwister(s);
        this.seed = s;
    }

    public void setCountOfRooms(int c) {
        switch (c) {
            case 0: {
                this.countOfRooms = this.getAbsInt(2) + 3;
                --this.countOfOpt;
                break;
            }
            case 1: {
                this.countOfRooms = this.getAbsInt(3) + 4;
                --this.countOfOpt;
                break;
            }
            case 2: {
                this.countOfRooms = this.getAbsInt(5) + 6;
                --this.countOfOpt;
                break;
            }
            case 3: {
                this.countOfRooms = this.getAbsInt(6) + 10;
                --this.countOfOpt;
            }
        }
    }

    public void setCountOfRoomsExactly(int c) {
        this.countOfRooms = c;
    }

    public void setPattern(int c) {
        this.pattern = c;
    }

    public void Generate() throws IOException {
        this.countOfOpt = 50;
        if (this.countOfRooms == -1) {
            Random rn = new Random();
            int count = rn.nextInt(4);
            this.setCountOfRooms(count);
            this.MP.cor.setSelectedIndex(count);
            --this.countOfOpt;
        }
        for (int i = 0; i < this.countOfOpt; ++i) {
            this.getAbsInt();
        }
        if (this.pattern == 0) {
            this.lab();
        }
        if (this.pattern == 1) {
            this.runaway();
        }
        if (this.pattern == 2) {
            this.sun();
        }
        this.MP.repaintMap();
        this.MP.readKeyboard();
    }

    private void lab() throws IOException {
        int i;
        this.rooms = new ArrayList();
        Room r = this.makeRoom(4, 10, 0);
        this.rooms.add(r);
        int c = 0;
        while (this.rooms.size() != this.countOfRooms) {
            r = this.makeRoom(4, 10, 0);
            for (int j = 0; j < this.rooms.size() && !this.intersection(r, this.rooms.get(j)); ++j) {
                if (j != this.rooms.size() - 1) continue;
                this.rooms.add(r);
            }
            if (++c <= 500) continue;
            this.MP.abort();
            return;
        }
        for (i = 1; i < this.rooms.size(); ++i) {
            this.makePath(this.rooms.get(i - 1), this.rooms.get(i));
        }
        for (i = 0; i < this.countOfRooms; ++i) {
            this.rooms.get(i).roomSave();
            int type = this.getAbsInt(3);
            this.rooms.get(i).setType(type);
        }
    }

    private void runaway() throws IOException {
        int i;
        this.rooms = new ArrayList();
        Room r = this.makeRoom(4, 7, 0);
        this.rooms.add(r);
        int c = 0;
        while (this.rooms.size() != this.countOfRooms) {
            ++c;
            r = this.makeRoom(3, 7, 0);
            for (int j = 0; j < this.rooms.size() && !this.intersection(r, this.rooms.get(j)); ++j) {
                if (j != this.rooms.size() - 1) continue;
                this.rooms.add(r);
            }
            if (c <= 500) continue;
            this.MP.abort();
            return;
        }
        int[] list = this.makeRlist();
        for (i = 1; i < this.rooms.size(); ++i) {
            this.makePath(this.rooms.get(list[i - 1]), this.rooms.get(list[i]));
        }
        for (i = 0; i < this.countOfRooms; ++i) {
            this.rooms.get(i).roomSave();
            int type = this.getAbsInt(3);
            this.rooms.get(i).setType(type);
        }
    }

    private void sun() throws IOException {
        int i;
        this.rooms = new ArrayList();
        Room r = this.makeRoom(10, 15, 1);
        this.rooms.add(r);
        int c = 0;
        while (this.rooms.size() != this.countOfRooms) {
            ++c;
            r = this.makeRoom(4, 7, 0);
            for (int j = 0; j < this.rooms.size() && !this.intersection(r, this.rooms.get(j)); ++j) {
                if (j != this.rooms.size() - 1) continue;
                this.rooms.add(r);
            }
            if (c <= 500) continue;
            this.MP.abort();
            return;
        }
        for (i = 1; i < this.rooms.size(); ++i) {
            this.makePath(this.rooms.get(0), this.rooms.get(i));
        }
        for (i = 0; i < this.countOfRooms; ++i) {
            this.rooms.get(i).roomSave();
            int type = this.getAbsInt(3);
            this.rooms.get(i).setType(type);
        }
    }

    private boolean intersection(Room r1, Room r2) {
        if (r1.startPoint.Xposition == r2.startPoint.Xposition && r1.startPoint.Yposition == r2.startPoint.Yposition) {
            return true;
        }
        if (r1.startPoint.Xposition < r2.startPoint.Xposition) {
            if (r1.startPoint.Xposition + r1.w + 1 < r2.startPoint.Xposition) {
                return false;
            }
            if (r1.startPoint.Yposition < r2.startPoint.Yposition ? r1.startPoint.Yposition + r1.h + 1 < r2.startPoint.Yposition : r1.startPoint.Yposition > r2.startPoint.Yposition + r2.h + 1) {
                return false;
            }
        }
        if (r1.startPoint.Xposition > r2.startPoint.Xposition) {
            if (r1.startPoint.Xposition > r2.startPoint.Xposition + r2.w + 1) {
                return false;
            }
            if (r1.startPoint.Yposition < r2.startPoint.Yposition ? r1.startPoint.Yposition + r1.h + 1 < r2.startPoint.Yposition : r1.startPoint.Yposition > r2.startPoint.Yposition + r2.h + 1) {
                return false;
            }
        }
        return true;
    }

    private Room makeRoom(int min, int max, int opt) {
        int w = this.width;
        int h = this.height;
        int x = this.width;
        int y = this.height;
        if (opt == 0) {
            while (x + w >= this.width || w < min || x == 0) {
                w = this.getAbsInt() % max;
                x = this.getAbsInt(this.width);
            }
            while (y + h >= this.height || h < min || y == 0) {
                h = this.getAbsInt() % max;
                y = this.getAbsInt(this.height);
            }
        }
        if (opt == 1) {
            while (x + w >= this.width || w < min || x == 0) {
                w = this.getAbsInt() % max;
                x = 18 + this.getAbsInt(10);
            }
            while (y + h >= this.height || h < min || y == 0) {
                h = this.getAbsInt() % max;
                y = 18 + this.getAbsInt(10);
            }
        }
        return new Room(h, w, x, y);
    }

    private void makePath(Room r1, Room r2) {
        if (this.MT.nextBoolean()) {
            int i;
            int x = r1.startPoint.Xposition + this.getAbsInt() % r1.w;
            int y = r2.startPoint.Yposition + this.getAbsInt() % r2.h;
            if (r2.startPoint.Xposition > x) {
                for (i = x; i < r2.startPoint.Xposition; ++i) {
                    this.squares[i][y].data = 5;
                }
            } else {
                for (i = x; i > r2.startPoint.Xposition; --i) {
                    this.squares[i][y].data = 5;
                }
            }
            if (r1.startPoint.Yposition > y) {
                for (i = y; i < r1.startPoint.Yposition; ++i) {
                    this.squares[x][i].data = 5;
                }
            } else {
                for (i = y; i > r1.startPoint.Yposition; --i) {
                    this.squares[x][i].data = 5;
                }
            }
        } else {
            int i;
            int x = r2.startPoint.Xposition + this.getAbsInt() % r2.w;
            int y = r1.startPoint.Yposition + this.getAbsInt() % r1.h;
            if (r1.startPoint.Xposition > x) {
                for (i = x; i < r1.startPoint.Xposition; ++i) {
                    this.squares[i][y].data = 5;
                }
            } else {
                for (i = x; i > r1.startPoint.Xposition; --i) {
                    this.squares[i][y].data = 5;
                }
            }
            if (r2.startPoint.Yposition > y) {
                for (i = y; i < r2.startPoint.Yposition; ++i) {
                    this.squares[x][i].data = 5;
                }
            } else {
                for (i = y; i > r2.startPoint.Yposition; --i) {
                    this.squares[x][i].data = 5;
                }
            }
        }
    }

    private int[] makeRlist() {
        int rightValue = 50;
        int right = 1;
        int[] list = new int[this.rooms.size()];
        for (int i = 0; i < this.rooms.size(); ++i) {
            if (this.rooms.get((int)i).startPoint.Xposition >= rightValue) continue;
            right = i;
        }
        Room[] roomsTemp = new Room[this.rooms.size()];
        for (int i = 0; i < roomsTemp.length; ++i) {
            roomsTemp[i] = this.rooms.get(i);
        }
        Room tmp = roomsTemp[right];
        roomsTemp[right] = null;
        list[0] = right;
        for (int i = 0; i < roomsTemp.length; ++i) {
            int next = i;
            double best = 9999.0;
            for (int j = 0; j < roomsTemp.length; ++j) {
                double v;
                if (roomsTemp[j] == null || !(1.0 - (v = (double)(Math.abs(tmp.startPoint.Xposition - roomsTemp[j].startPoint.Xposition) + Math.abs(tmp.startPoint.Yposition - roomsTemp[j].startPoint.Yposition))) < best)) continue;
                next = j;
                best = v;
            }
            tmp = roomsTemp[next];
            roomsTemp[next] = null;
            list[i] = next;
        }
        return list;
    }

    private int getAbsInt() {
        return Math.abs(this.MT.nextInt());
    }

    private int getAbsInt(int c) {
        if (c == 0) {
            return 0;
        }
        return Math.abs(this.MT.nextInt(c));
    }

    private int getInt() {
        return this.MT.nextInt();
    }

    private int getInt(int c) {
        if (c == 0) {
            return 0;
        }
        return this.MT.nextInt(c);
    }

    public void changeType(int r, int t) throws IOException {
        this.rooms.get(r).clearRoom();
        this.rooms.get(r).setType(t);
        this.MP.repaintMap();
    }

    class Item {
        int x;
        int y;
        int name;
        Item[] succ;

        public Item(String s) {
            String[] strs = s.split(",");
            this.name = Integer.parseInt(strs[0]);
            this.succ = new Item[Integer.parseInt(strs[1])];
        }

        public Item(int i) {
            this.name = i;
        }
    }

    class Room {
        ArrayList<MapPanel.Square> roomSquares;
        MapPanel.Square startPoint;
        MapPanel.Square midPoint;
        int w;
        int h;
        Type type;
        ArrayList<Item> items;
        int roomSize;

        private Room(int h, int w, int x, int y) {
            this.h = h;
            this.w = w;
            this.startPoint = ProcGen.this.squares[x][y];
            this.midPoint = ProcGen.this.squares[x + w / 2][y + h / 2];
            this.roomSquares = new ArrayList();
            this.items = new ArrayList();
        }

        private void clearRoom() {
            for (int i = this.startPoint.Xposition; i < this.w + this.startPoint.Xposition; ++i) {
                for (int j = this.startPoint.Yposition; j < this.h + this.startPoint.Yposition; ++j) {
                    ProcGen.this.squares[i][j].data = 5;
                }
            }
        }

        private void roomSave() {
            for (int i = this.startPoint.Xposition; i < this.w + this.startPoint.Xposition; ++i) {
                for (int j = this.startPoint.Yposition; j < this.h + this.startPoint.Yposition; ++j) {
                    this.roomSquares.add(ProcGen.this.squares[i][j]);
                    ProcGen.this.squares[i][j].data = 5;
                }
            }
            this.roomSize = this.roomSquares.size();
        }

        private void setType(int t) throws FileNotFoundException, IOException {
            this.type = new Type(t);
        }

        class Type {
            String[] itemStrings;
            int c;
            int type;

            public Type(int i) throws FileNotFoundException, IOException {
                this.type = i;
                if (i == 0) {
                    this.makeKitchen();
                }
                if (i == 1) {
                    this.makeLivingRoom();
                }
                if (i == 2) {
                    this.makeArmory();
                }
            }

            private void makeKitchen() throws FileNotFoundException, IOException {
                Room.this.items = this.kitchenItems();
                this.setLocation();
            }

            private void makeLivingRoom() {
                Room.this.items = this.livingRoomItems();
                this.setLocation();
            }

            private void makeArmory() {
                Room.this.items = this.armoryItems();
                this.setLocation();
            }

            private ArrayList<Item> kitchenItems() {
                int i;
                ArrayList<Item> a = new ArrayList<Item>();
                for (i = 0; i < Room.this.roomSize / 18; ++i) {
                    a.add(new Item(7));
                }
                for (i = 0; i < Room.this.roomSize / 15; ++i) {
                    a.add(new Item(9));
                }
                for (i = 0; i < Room.this.roomSize / 4; ++i) {
                    if (i % 4 == 0) {
                        a.add(new Item(8));
                        continue;
                    }
                    a.add(new Item(13));
                }
                return a;
            }

            private ArrayList<Item> livingRoomItems() {
                int i;
                ArrayList<Item> a = new ArrayList<Item>();
                for (i = 0; i < Room.this.roomSize / 54; ++i) {
                    a.add(new Item(7));
                }
                for (i = 0; i < Room.this.roomSize / 15; ++i) {
                    a.add(new Item(9));
                }
                for (i = 0; i < Room.this.roomSize / 3; ++i) {
                    if (i % 4 == 0) {
                        a.add(new Item(10));
                        continue;
                    }
                    a.add(new Item(14));
                }
                return a;
            }

            private ArrayList<Item> armoryItems() {
                int i;
                ArrayList<Item> a = new ArrayList<Item>();
                for (i = 0; i < Room.this.roomSize / 8; ++i) {
                    a.add(new Item(15));
                }
                for (i = 0; i < Room.this.roomSize / 15; ++i) {
                    a.add(new Item(9));
                }
                for (i = 0; i < Room.this.roomSize / 12; ++i) {
                    if (i % 4 > 1) {
                        a.add(new Item(10));
                        continue;
                    }
                    a.add(new Item(8));
                    a.add(new Item(13));
                }
                return a;
            }

            private void setLocation() {
                ArrayList itlist = (ArrayList)Room.this.items.clone();
                int counter = 0;
                int b = 0;
                int x = 0;
                int y = 0;
                while (!itlist.isEmpty()) {
                    int in;
                    ++counter;
                    Item it = (Item)itlist.get(0);
                    if (it.name == 7) {
                        x = Room.this.midPoint.Xposition + ProcGen.this.getInt(Room.this.w / 3);
                        y = Room.this.midPoint.Yposition + ProcGen.this.getInt(Room.this.h / 3);
                    }
                    if (it.name == 9 || it.name == 15) {
                        int tmp = ProcGen.this.getAbsInt() % 4;
                        if (tmp == 0) {
                            x = Room.this.startPoint.Xposition;
                            y = Room.this.midPoint.Yposition + ProcGen.this.getInt() % (Room.this.h / 2);
                        }
                        if (tmp == 1) {
                            x = Room.this.startPoint.Xposition + Room.this.w - 1;
                            y = Room.this.midPoint.Yposition + ProcGen.this.getInt() % (Room.this.h / 2);
                        }
                        if (tmp == 2) {
                            x = Room.this.midPoint.Xposition + ProcGen.this.getInt() % (Room.this.w / 2);
                            y = Room.this.startPoint.Yposition;
                        }
                        if (tmp == 3) {
                            x = Room.this.midPoint.Xposition + ProcGen.this.getInt() % (Room.this.w / 2);
                            y = Room.this.startPoint.Yposition + Room.this.h - 1;
                        }
                    }
                    if (it.name == 8 || it.name == 14) {
                        in = ProcGen.this.getAbsInt(Room.this.roomSize);
                        x = Room.this.roomSquares.get((int)in).Xposition;
                        y = Room.this.roomSquares.get((int)in).Yposition;
                        b = 1;
                    }
                    if (it.name == 13 || it.name == 10) {
                        if (b == 5) {
                            Room.this.items.remove(itlist.remove(0));
                        }
                        if (b == 4) {
                            ++x;
                            --y;
                        }
                        if (b == 3) {
                            --x;
                            --y;
                        }
                        if (b == 2) {
                            --x;
                            ++y;
                        }
                        if (b == 1) {
                            ++x;
                        }
                        ++b;
                    }
                    if (counter > 200) {
                        in = ProcGen.this.getAbsInt(Room.this.roomSize);
                        x = Room.this.roomSquares.get((int)in).Xposition;
                        y = Room.this.roomSquares.get((int)in).Yposition;
                    }
                    if (x <= 0 || y <= 0 || ProcGen.this.squares[x][y].data >= 6 || !Room.this.roomSquares.contains(ProcGen.this.squares[x][y])) continue;
                    it.x = x;
                    it.y = y;
                    ProcGen.this.squares[x][y].data = it.name;
                    itlist.remove(0);
                    counter = 0;
                }
            }

            private void saveItem(Item it) {
                for (int i = 0; i < Room.this.roomSize; ++i) {
                    MapPanel.Square s = Room.this.roomSquares.get(i);
                    if (s.Xposition != it.x || s.Yposition != it.y) continue;
                    s.data = it.name;
                }
            }
        }
    }
}

