/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package d.d;

/**
 *
 * @author pospis
 */
import java.awt.*;
import java.awt.event.*;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.*;

public class Battle {

    MainFrame frame;
    BPanel panel;
    static final int Main = 1;
    static final int HeroesEditor = 2;
    static final int HeroesManagment = 3;
    static final int Battle = 4;
    static final int Creatures = 5;
    static final int Map = 6;
    static final Color GRASS = Color.YELLOW;
    static final Color WATER = Color.BLUE;
    static final Color ROCK = Color.BLACK;
    static final Color TREE = Color.green;
    static final int name = 0;
    static final int race = 1;
    static final int profession = 2;
    static final int level = 3;
    static final int height = 5;
    static final int health = 4;
    static final int mass = 6;
    static final int power = 7;
    static final int ability = 8;
    static final int hardness = 9;
    static final int intelligence = 10;
    static final int charisma = 11;
    static final int others = 12;
    
    int ScreenWidth;
    int ScreenHeight;
    private ArrayList<Hero> heroes= new ArrayList<Hero>();
    private ArrayList<creature> creatures= new ArrayList<creature>();
    ArrayList<Item> items;
            DrawPanel d;
        SelectionPanel p2;
    Color ChangedGround = GRASS;
    Square selected=null;
    private boolean del=false;
    
    ArrayList<String> images = new ArrayList<String>();
    private JLabel p2health;

    public Battle(MainFrame frame) throws FileNotFoundException, IOException {
        this.frame = frame;
        panel = new BPanel();
    }

    public JPanel getPanel() {
        return panel;
    }

    class BPanel extends JPanel {

        int MapWidth = 25;
        int MapHeight = 25;


        public BPanel() throws FileNotFoundException, IOException {
            ScreenWidth = frame.getWidth();
            ScreenHeight = frame.getHeight();

            JMenuBar menuBar = new JMenuBar();
            frame.setJMenuBar(menuBar);
            JMenu file = new JMenu("File");
            menuBar.add(file);

            JMenuItem open = new JMenuItem("Open");
            JMenuItem exit = new JMenuItem("Return to Menu");

            file.add(open);
            file.addSeparator();
            file.add(exit);
            frame.setVisible(true);
            
            
            images.add("resources/img/player1.jpg");
            images.add("resources/img/player2.jpg");
            BufferedReader br = new BufferedReader(new FileReader("resources/armor.txt"));
            String str=br.readLine();
            items=new ArrayList<Item>();
            while(str!=null){
                items.add(new Item(str,"armor"));
                str=br.readLine();
            }
            br.close();
            br=new BufferedReader(new FileReader("resources/weapons.txt"));
            str=br.readLine();
            while(str!=null){
                items.add(new Item(str,"weapon"));
                str=br.readLine();
            }
            br.close();
            br=new BufferedReader(new FileReader("resources/items.txt"));
            str=br.readLine();
            while(str!=null){
                items.add(new Item(str,"item"));
                str=br.readLine();
            }
            br.close();


            this.setLayout(new GridLayout(1, 2));

            d = new DrawPanel(MapWidth, MapHeight, null);
            p2 = new SelectionPanel();

            d.setPreferredSize(new Dimension(ScreenWidth / 2, ScreenHeight));
            p2.setPreferredSize(new Dimension(ScreenWidth / 2, ScreenHeight));


            add(d);
            add(p2);

            exit.addActionListener(new ActionListener() {

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    frame.ChangePanel(Main);
                }
            });

            open.addActionListener(new ActionListener() {

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    try {
                        Square[][] sq;
                        sq = open();
                        if (sq != null) {
                            d.repaintMap(sq);
                        }
                    } catch (FileNotFoundException ex) {
                        Logger.getLogger(MapPanel.class.getName()).log(Level.SEVERE, null, ex);
                    } catch (IOException ex) {
                        Logger.getLogger(MapPanel.class.getName()).log(Level.SEVERE, null, ex);
                    }


                }
            });
        }

        private Square[][] open() throws FileNotFoundException, IOException {
            JFrame open = new JFrame("OPEN");

            JPanel op = new JPanel();
            op.setLayout(new BorderLayout());
            JTextArea log = new JTextArea(5, 20);
            log.setMargin(new Insets(5, 5, 5, 5));
            log.setEditable(false);
            JScrollPane logScrollPane = new JScrollPane(log);
            JFileChooser fc = new JFileChooser();
            op.add(logScrollPane, BorderLayout.CENTER);


            int returnVal = fc.showOpenDialog(op);

            if (returnVal == JFileChooser.APPROVE_OPTION) {
                Square[][] sq = new Square[MapWidth][MapHeight];
                File file = fc.getSelectedFile();
                BufferedReader br = new BufferedReader(new FileReader(file.getPath()));
                String str;
                for (int i = 0; i < MapHeight; i++) {
                    str = br.readLine();
                    for (int j = 0; j < MapWidth; j++) {
                        sq[i][j] = new Square(i, j, MakeGround(str.charAt(j)));
                    }
                }
                return sq;
            }

            open.pack();
            open.setVisible(true);
            frame.repaint();
            open.dispose();
            return null;


        }

        private Color MakeGround(char c) {
            switch (c) {
                case 'g':
                    return GRASS;
                case 'w':
                    return WATER;
                case 'r':
                    return ROCK;
                case 't':
                    return TREE;
            }
            return GRASS;

        }
        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.drawImage(new ImageIcon("resources/edit3.jpg").getImage(),0,0, this.getWidth(), this.getHeight(), null);
        }
    }
    
    private void isfire(Person h1, Person h2, int distance){
            int n = JOptionPane.showConfirmDialog(
            frame,
            h1.name+" fire on "+h2.name,
            "Continue?",
            JOptionPane.YES_NO_OPTION);

            if(n==JOptionPane.YES_OPTION){
                fire(h1,h2,distance);
            }
            selected=null;
    }
    
    private void fire(final Person p1, final Person p2, int d){
        final JFrame f = new JFrame("Fire!");
        final JPanel p = new JPanel();
        
        p.setLayout(new BoxLayout(p, BoxLayout.Y_AXIS));
        
        Box box = Box.createHorizontalBox();
        Box box1 = Box.createVerticalBox();
        Box box2 = Box.createVerticalBox();
        box.add(box1);
        box.add(Box.createRigidArea(new Dimension(200,0)));
        box.add(box2);
        box2.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        
        
        
        /*********person1**********/
        
        box1.add(Box.createRigidArea(new Dimension(0,20)));
        box1.add(new JLabel(p1.name));
        box1.add(Box.createRigidArea(new Dimension(0,20)));
        box1.add(new JLabel(p1.type));
        box1.add(Box.createRigidArea(new Dimension(0,20)));
        box1.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        
        int offbonus = Integer.parseInt(((Hero)p1).atr.get(ability)) / 2 - 5;
        if(offbonus<0){offbonus=0;}
        int fireoff;
        if(((Hero)p1).leftHand != null){
            fireoff=offbonus+((Hero)p1).leftHand.power;
        }else{
            fireoff=offbonus+((Hero)p1).rightHand.power;
        }
        
        JLabel p1health =  new JLabel("Health: "+p1.health);
        JLabel p1off =  new JLabel("Offensive: "+fireoff);
        JLabel p1def =  new JLabel("Defend: "+p1.def);
        
        Box box3 = Box.createHorizontalBox();
        final JTextField offield = new JTextField();
        box3.add(new JLabel("Attack power: "));
        offield.setMaximumSize(new Dimension(50,20));
        box3.add(offield);
                
                
                
        box1.add(p1health);
        box1.add(Box.createRigidArea(new Dimension(0,20)));
        box1.add(p1off);
        box1.add(Box.createRigidArea(new Dimension(0,20)));
        box1.add(p1def);
        box1.add(Box.createRigidArea(new Dimension(0,20)));
        box1.add(box3);
       
        
        /**************person2************/
        box2.add(Box.createRigidArea(new Dimension(0,20)));
        box2.add(new JLabel(p2.name));
        box2.add(Box.createRigidArea(new Dimension(0,20)));
        box2.add(new JLabel(p2.type));
        box2.add(Box.createRigidArea(new Dimension(0,20)));
        
        p2health =  new JLabel("Health: "+p2.health);
        JLabel p2off =  new JLabel("Offensive: "+p2.off);
        JLabel p2def =  new JLabel("Defend: "+p2.def);
        
        Box box4 = Box.createHorizontalBox();
        final JTextField defield = new JTextField();
        box4.add(new JLabel("Defend power: "));
        defield.setMaximumSize(new Dimension(50,20));
        box4.add(defield);
        
                
                
        box2.add(p2health);
        box2.add(Box.createRigidArea(new Dimension(0,20)));
        box2.add(p2off);
        box2.add(Box.createRigidArea(new Dimension(0,20)));
        box2.add(p2def);
        box2.add(Box.createRigidArea(new Dimension(0,20)));
        box2.add(box4);
        
        
        p.add(box);
        f.add(p);
        f.setSize(500, 300);
        f.setVisible(true);
        f.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        
        JButton rec =new JButton("Result");
        p.add(rec);
        
        rec.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if(offield.getText()!=null && defield.getText()!=null){
                    summary(f,p1,p2,Integer.parseInt(offield.getText()),Integer.parseInt(defield.getText()));
                }else{
                    JOptionPane.showMessageDialog(f, "Wrong settings!");
                }
            }
        });
        
        
    }
    
    private int findDistance(Square s1, Square s2){
        return Math.abs(s1.x/36 - s2.x/36)+Math.abs(s1.y/36 - s2.y/36);
    }
    
    private void isfight(Person h1, Person h2){
            int n = JOptionPane.showConfirmDialog(
            frame,
            h1.name+" attack on "+h2.name,
            "Continue?",
            JOptionPane.YES_NO_OPTION);

            if(n==JOptionPane.YES_OPTION){
                fight(h1,h2);
            }
            selected=null;
    }
    
    private boolean nextto(Square s1, Square s2){
        int s1x =s1.x/36;
        int s1y =s1.y/36;
        int s2x =s2.x/36;
        int s2y =s2.y/36;
        if(s1x==s2x || s1x==s2x-1 || s1x == s2x+1){
            if(s1y == s2y || s1y == s2y-1 || s1y == s2y+1){
                return true;
            }
        }
        
        return false;
        
    }
    
    private void fight(final Person p1, final Person p2){
        final JFrame f = new JFrame("Fight!");
        final JPanel p = new JPanel();
        
        p.setLayout(new BoxLayout(p, BoxLayout.Y_AXIS));
        
        Box box = Box.createHorizontalBox();
        Box box1 = Box.createVerticalBox();
        Box box2 = Box.createVerticalBox();
        box.add(box1);
        box.add(Box.createRigidArea(new Dimension(200,0)));
        box.add(box2);
        box2.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        
        /*****person1*********/
        box1.add(Box.createRigidArea(new Dimension(0,20)));
        box1.add(new JLabel(p1.name));
        box1.add(Box.createRigidArea(new Dimension(0,20)));
        box1.add(new JLabel(p1.type));
        box1.add(Box.createRigidArea(new Dimension(0,20)));
        box1.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        
        JLabel p1health =  new JLabel("Health: "+p1.health);
        JLabel p1off =  new JLabel("Offensive: "+p1.off);
        JLabel p1def =  new JLabel("Defend: "+p1.def);
        
        Box box3 = Box.createHorizontalBox();
        final JTextField offield = new JTextField();
        box3.add(new JLabel("Attack power: "));
        offield.setMaximumSize(new Dimension(50,20));
        box3.add(offield);
                
                
                
        box1.add(p1health);
        box1.add(Box.createRigidArea(new Dimension(0,20)));
        box1.add(p1off);
        box1.add(Box.createRigidArea(new Dimension(0,20)));
        box1.add(p1def);
        box1.add(Box.createRigidArea(new Dimension(0,20)));
        box1.add(box3);
        
        
        /**************person2************/
        box2.add(Box.createRigidArea(new Dimension(0,20)));
        box2.add(new JLabel(p2.name));
        box2.add(Box.createRigidArea(new Dimension(0,20)));
        box2.add(new JLabel(p2.type));
        box2.add(Box.createRigidArea(new Dimension(0,20)));
        
        p2health =  new JLabel("Health: "+p2.health);
        JLabel p2off =  new JLabel("Offensive: "+p2.off);
        JLabel p2def =  new JLabel("Defend: "+p2.def);
        
        Box box4 = Box.createHorizontalBox();
        final JTextField defield = new JTextField();
        box4.add(new JLabel("Defend power: "));
        defield.setMaximumSize(new Dimension(50,20));
        box4.add(defield);
        
                
                
        box2.add(p2health);
        box2.add(Box.createRigidArea(new Dimension(0,20)));
        box2.add(p2off);
        box2.add(Box.createRigidArea(new Dimension(0,20)));
        box2.add(p2def);
        box2.add(Box.createRigidArea(new Dimension(0,20)));
        box2.add(box4);
        
        /***************************/
        
        p.add(box);
        f.add(p);
        f.setSize(500, 300);
        f.setVisible(true);
        f.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        
        JButton rec =new JButton("Result");
        p.add(rec);
        
        rec.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if(offield.getText()!=null && defield.getText()!=null){
                    summary(f,p1,p2,Integer.parseInt(offield.getText()),Integer.parseInt(defield.getText()));
                }else{
                    JOptionPane.showMessageDialog(f, "Wrong settings!");
                }
            }
        });
    }
    
    private void summary(JFrame f,Person p1, Person p2,int offdice, int defdice){

        int damage=p1.off+offdice-p2.def-defdice;
        
        if(damage>0){
            JOptionPane.showMessageDialog(f, p1.name+" hit "+p2.name+"\n"+p2.name+" earned damage: "+damage);
            p2.health-=damage;
        }else{
            JOptionPane.showMessageDialog(f, p1.name+" missed "+p2.name);
        }
        p2health.setText("Health: "+p2.health);
        f.revalidate();
        f.getContentPane().repaint();

    }

    class DrawPanel extends JPanel {

        public Square[][] square;

        public void repaintMap(Square[][] sq) {
            for (int i = 0; i < square.length; i++) {
                for (int j = 0; j < square[i].length; j++) {
                    ChangedGround = sq[i][j].data;
                    square[i][j].ChangeGround();
                }
            }
            repaint();
        }

        public DrawPanel(int x, int y, Square[][] sq) {
            square = new Square[x][y];
            setBorder(BorderFactory.createLineBorder(Color.black));
            setOpaque(false);

            for (int i = 0; i < x; i++) {
                for (int j = 0; j < y; j++) {
                    square[i][j] = new Square(i, j);
                }
            }


            addMouseListener(new MouseAdapter() {

                @Override
                public void mousePressed(MouseEvent e) {
                    if(selected==null){
                        if(findSquare(e.getX(), e.getY()).onme != null){
                           if(del){
                               findSquare(e.getX(), e.getY()).onme=null;
                           }else{
                            selected=findSquare(e.getX(), e.getY());
                           }
                        }
                    }else{
                       if(findSquare(e.getX(), e.getY()).data==GRASS && findSquare(e.getX(), e.getY()).onme==null){ 
                        findSquare(e.getX(), e.getY()).onme=selected.onme;
                        selected.onme=null;
                        selected=null;
                       }else{
                           if(findSquare(e.getX(), e.getY()).data==GRASS && findSquare(e.getX(), e.getY()).onme!=null){
                               if(selected.onme != findSquare(e.getX(), e.getY()).onme){
                                   if(selected.onme.typeOfweapon.equals("melee") && nextto(selected,findSquare(e.getX(), e.getY()))){
                                       isfight(selected.onme,findSquare(e.getX(), e.getY()).onme);  
                                   }else{   
                                       if(selected.onme.typeOfweapon.equals("fire")){
                                        isfire(selected.onme,findSquare(e.getX(), e.getY()).onme,findDistance((selected),findSquare(e.getX(), e.getY())));
                                       }
                                   }
                               }
                           }         
                       }
                    }
                    repaint();
                }
            });
        }

        private Square findSquare(int x, int y) {
            return square[x / 36][y / 36];
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);

            for (int i = 0; i < square.length; i++) {
                for (int j = 0; j < square[i].length; j++) {
                    Square sq = square[i][j];
                    sq.paintSquare(g);
                }
            }
        }
        
    }

    class SelectionPanel extends JPanel implements ActionListener {

        private final JButton addHero;
        private final Box b2;
        private final ArrayList<JButton> Hbuttons=new ArrayList<JButton>();
        private final ArrayList<JButton> Cbuttons=new ArrayList<JButton>();
        private JLabel loff;
        private JLabel ldef;
        private final JButton DelHero;
        private final Box b4;
        private final JButton addCreature;
        
        
        public SelectionPanel() {

            setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
            add(Box.createRigidArea(new Dimension(0,100)));
            
            addHero = new JButton("add hero");           
            b2 = Box.createVerticalBox();
            b2.add(addHero);
            add(b2);
            setVisible(true);
            setOpaque(false);
            
            addHero.setAlignmentX(CENTER_ALIGNMENT);
            addHero.addActionListener(this);
            
            
            
            /***************creature****************/
            add(Box.createRigidArea(new Dimension(0,100)));     
            addCreature = new JButton("add creature");
            b4 = Box.createVerticalBox();
            b4.add(addCreature);
            add(b4);

            addCreature.setAlignmentX(CENTER_ALIGNMENT);
            addCreature.addActionListener(this);
            
            /**********************************/
            add(Box.createRigidArea(new Dimension(0,100)));
            DelHero = new JButton("Delete");
            DelHero.setBackground(Color.LIGHT_GRAY);
            add(DelHero);
            
            DelHero.setAlignmentX(CENTER_ALIGNMENT);
            DelHero.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            
            
            if (e.getSource() == addHero) {
                JPanel op = new JPanel();
                op.setLayout(new BorderLayout());
                JTextArea log = new JTextArea(5, 20);
                log.setMargin(new Insets(5, 5, 5, 5));
                log.setEditable(false);
                JScrollPane logScrollPane = new JScrollPane(log);
                JFileChooser fc = new JFileChooser();
                op.add(logScrollPane, BorderLayout.CENTER);

                int returnVal = fc.showOpenDialog(op);

                if (returnVal == JFileChooser.APPROVE_OPTION) {
                    File file = fc.getSelectedFile();
                    try {
                        heroes.add(new Hero(file));
                    } catch (IOException ex) {
                        Logger.getLogger(Battle.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    JButton b = new JButton(heroes.get(heroes.size()-1).atr.get(name));
                    b.addActionListener(this);
                    Hbuttons.add(b);
                    b.setAlignmentX(CENTER_ALIGNMENT);
                    d.square[0][heroes.size()-1].onme=heroes.get(heroes.size()-1);
                    d.square[0][heroes.size()-1].onme.x=0;
                    d.square[0][heroes.size()-1].onme.y=heroes.size()-1;
                    d.repaint();
                    b2.add(b);
                    validate();
                    repaint();
                    
                }
            }
            
            if(e.getSource()==DelHero){
               if(del){ 
                DelHero.setBackground(Color.LIGHT_GRAY);
                del=false;
                
               }else{
                   DelHero.setBackground(Color.GREEN);
                   del=true;
               }    
            }
            
            if(e.getSource()==addCreature){
                JPanel op = new JPanel();
                op.setLayout(new BorderLayout());
                JTextArea log = new JTextArea(5, 20);
                log.setMargin(new Insets(5, 5, 5, 5));
                log.setEditable(false);
                JScrollPane logScrollPane = new JScrollPane(log);
                JFileChooser fc = new JFileChooser();
                op.add(logScrollPane, BorderLayout.CENTER);

                int returnVal = fc.showOpenDialog(op);

                if (returnVal == JFileChooser.APPROVE_OPTION) {
                    File file = fc.getSelectedFile();
                    try {
                        creatures.add(new creature(file));
                    } catch (IOException ex) {
                        Logger.getLogger(Battle.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    JButton b = new JButton(creatures.get(creatures.size()-1).name);
                    b.addActionListener(this);
                    Cbuttons.add(b);
                    d.square[2][creatures.size()-1+10].onme=creatures.get(creatures.size()-1);
                    d.square[2][creatures.size()-1+10].onme.x=2;
                    d.square[2][creatures.size()-1+10].onme.y=creatures.size()-1+10;
                    d.repaint();
                    b.setAlignmentX(CENTER_ALIGNMENT);
                    b4.add(b);
                    validate();
                    repaint();
                }
            }
            
            for(int i=0; i < Hbuttons.size(); i++){
                if(e.getSource()==Hbuttons.get(i)){
                    if(del){
                       Cbuttons.get(i).setVisible(false);
                       repaint();
                   }else{
                        showHero(heroes.get(i));
                   }
                }
            }
            for (int i = 0; i < Cbuttons.size(); i++) {
                if(e.getSource()==Cbuttons.get(i)){
                   if(del){
                       Cbuttons.get(i).setVisible(false);
                       repaint();
                   }else{
                    showCreature(creatures.get(i));
                   }
                }
            }
        }
    
    private void showCreature(creature c){
        final JFrame f = new JFrame();
        f.setSize(200,200);
        f.setVisible(true);
        
        JPanel p = new JPanel();
        f.add(p);
        p.setLayout(new BoxLayout(p,BoxLayout.Y_AXIS));
        JLabel lname =new JLabel(c.name);
        p.add(lname);
        
        JLabel ltype = new JLabel(c.type);
        JLabel lhealth = new JLabel("Health: "+c.health);
        JLabel laoff = new JLabel("Offensive: "+c.off);
        JLabel ladef = new JLabel("Defend: "+c.def);
        
        ltype.setAlignmentX(CENTER_ALIGNMENT);
        lhealth.setAlignmentX(CENTER_ALIGNMENT);
        laoff.setAlignmentX(CENTER_ALIGNMENT);
        ladef.setAlignmentX(CENTER_ALIGNMENT);
        
        add(Box.createRigidArea(new Dimension(0,20)));
        p.add(ltype);
        add(Box.createRigidArea(new Dimension(0,20)));
        p.add(lhealth);
        add(Box.createRigidArea(new Dimension(0,20)));
        p.add(laoff);
        add(Box.createRigidArea(new Dimension(0,20)));
        p.add(ladef);
        
        f.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
    }
        
    private void showHero(final Hero h){
        final JFrame f = new JFrame();
        f.setSize(500,500);
        f.setVisible(true);
        
        JPanel p = new JPanel();
        f.add(p);
        p.setLayout(new BoxLayout(p,BoxLayout.Y_AXIS));
        
        JLabel lname =new JLabel(h.atr.get(name));
        JLabel ltype = new JLabel(h.type);
        JLabel lhealth = new JLabel("Health: "+h.health);
        JLabel laoff = new JLabel("Offensive: "+h.off);
        JLabel ladef = new JLabel("Defend: "+h.def);

        lname.setAlignmentX(CENTER_ALIGNMENT);
        ltype.setAlignmentX(CENTER_ALIGNMENT);
        lhealth.setAlignmentX(CENTER_ALIGNMENT);
        laoff.setAlignmentX(CENTER_ALIGNMENT);
        ladef.setAlignmentX(CENTER_ALIGNMENT);
        
        p.add(Box.createRigidArea(new Dimension(0,20)));
        p.add(lname);
        p.add(Box.createRigidArea(new Dimension(0,20)));
        p.add(ltype);
        p.add(Box.createRigidArea(new Dimension(0,20)));
        p.add(lhealth);
        p.add(Box.createRigidArea(new Dimension(0,20)));
        p.add(laoff);
        p.add(Box.createRigidArea(new Dimension(0,20)));
        p.add(ladef);
        p.add(Box.createRigidArea(new Dimension(0,20)));
        
        Box box1= Box.createHorizontalBox();
        JLabel larmor = new JLabel("Armor:  ");
        final JComboBox combo = new JComboBox();
        combo.setMaximumSize(new Dimension(200, 50));
        box1.add(larmor);
        box1.add(combo);
        p.add(box1);
        combo.addItem("Nothing");
        for (int i = 0; i < h.it.size(); i++) {
                if ("armor".equals(h.it.get(i).type) && h.it.get(i).c < 10) {
                    combo.addItem(h.it.get(i).name);
                }
        }
        /**********************************/
            Box box2 = Box.createHorizontalBox();

            box2.add(new JLabel("Right Hand: "));
            final JComboBox combo2 = new JComboBox();
            final JComboBox combo3 = new JComboBox();
            combo2.setMaximumSize(new Dimension(200, 50));
            box2.add(combo2);
            combo2.addItem("Nothing");
            
            combo3.addItem("Nothing");
            Box box3 = Box.createHorizontalBox();
            box3.add(new JLabel("Left Hand:  "));
            combo3.setMaximumSize(new Dimension(200, 50));
            box3.add(combo3);
            
            
            
            for (int i = 0; i < h.it.size(); i++) {
                if (h.rightHand != h.it.get(i)) {
                    if ("weapon".equals(h.it.get(i).type)) {
                        if (h.it.get(i).c > 100) {
                            combo2.addItem(h.it.get(i).name);
                        }
                        if (h.it.get(i).c < 100) {
                            if (h.rightHand == null) {
                                combo2.addItem(h.it.get(i).name);
                            } else {
                                if (h.rightHand.c < 100) {
                                    combo2.addItem(h.it.get(i).name);
                                }
                            }
                        }
                    }
                    if ("armor".equals(h.it.get(i).type) && h.it.get(i).c > 10) {
                        if (h.rightHand == null) {
                            combo2.addItem(h.it.get(i).name);
                        } else {
                            if (h.rightHand.c < 100) {
                                combo2.addItem(h.it.get(i).name);
                            }
                        }
                    }
                }
            }
            for (int i = 0; i < h.it.size(); i++) {
                       if(h.leftHand!=h.it.get(i)){
                        if("weapon".equals(h.it.get(i).type)){
                           if(h.it.get(i).c>100){ 
                            combo3.addItem(h.it.get(i).name); 
                           }
                           if(h.it.get(i).c<100){
                              if(h.leftHand == null){
                                  combo3.addItem(h.it.get(i).name); 
                              }else{
                               if(h.leftHand.c<100){
                                   combo3.addItem(h.it.get(i).name); 
                               }
                              }
                           }
                        }
                        if("armor".equals(h.it.get(i).type) && h.it.get(i).c>10){
                            if(h.leftHand == null){
                                  combo3.addItem(h.it.get(i).name); 
                              }else{
                               if(h.leftHand.c<100){
                                   combo3.addItem(h.it.get(i).name);
                               }
                              }
                            
                        }
                       }
                    }
            p.add(box2);
            p.add(box3);

            /***********************************/
            p.add(Box.createRigidArea(new Dimension(0,20)));
            Box box4 = Box.createHorizontalBox();
            
            loff = new JLabel("Offensive: "+h.recalculateoff());
            ldef = new JLabel("Defend: "+h.recalculatearmor());
            
            box4.add(loff);
            box4.add(Box.createRigidArea(new Dimension(20,0)));
            box4.add(ldef);
            
            p.add(box4);

            p.add(Box.createRigidArea(new Dimension(0,20)));
            /**********/
            final JButton bok = new JButton("recalculate and save");
            p.add(bok);
            p.add(Box.createRigidArea(new Dimension(0,20)));
            bok.addActionListener(new ActionListener() {

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if(((String)combo2.getSelectedItem()).equals("Nothing")){
                        h.rightHand=null;
                    }else{
                        h.rightHand=fin((String)combo2.getSelectedItem());
                    }
                    if(((String)combo3.getSelectedItem()).equals("Nothing")){
                        h.leftHand=null;
                    }else{
                        h.leftHand=fin((String)combo3.getSelectedItem());
                    }
                    if(((String)combo.getSelectedItem()).equals("Nothing")){
                        h.armor=null;
                    }else{
                        h.armor=fin((String)combo.getSelectedItem());
                    }
                    
                    if(check(h)){
                        ldef.setText("Defend: "+h.recalculatearmor()+"  ");
                        h.def=h.recalculatearmor();
                        h.off=h.recalculateoff();
                        loff.setText("Offensive: "+h.recalculateoff());
                    }else{
                        JOptionPane.showMessageDialog(f, "Wrong settings!");
                    }
                }
            });
            
            Box box5 = Box.createHorizontalBox();
            JButton ok = new JButton("ok");
            box5.add(ok);
            box5.add(Box.createRigidArea(new Dimension(20,0)));
            JButton cancel = new JButton("cancel");
            box5.add(cancel);
            
            p.add(box5);
            ok.addActionListener(new ActionListener() {

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    f.dispose();
                }
            });
            cancel.addActionListener(new ActionListener() {

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    h.leftHand=null;
                    h.rightHand=null;
                    h.armor=null;
                    f.dispose();
                }
            });
            
            
            f.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        }

    }
    
    private boolean check(Hero h){
        if (h.leftHand==null) {
            if(h.rightHand.c>1000){
                h.typeOfweapon="fire";
            }else{
                h.typeOfweapon="melee";
            }
            return true;
        }
        if (h.rightHand==null) {
            if(h.leftHand.c>1000){
                h.typeOfweapon="fire";
            }else{
                h.typeOfweapon="melee";
            }
            return true;
        }
        if(h.leftHand.c>100 && h.rightHand != null){
            return false;
        }
        if(h.rightHand.c>100 && h.leftHand != null){
            return false;
        }
        if(h.rightHand==h.leftHand){
            return false;
        }
        if(h.leftHand.c>100 && h.rightHand == null){
            
        }
        
        if(h.leftHand.c>1000 || h.rightHand.c>1000){
                h.typeOfweapon="fire";
        }else{
                h.typeOfweapon="melee";
        }
        return true;
                
    }

    private Item finditemname(String str) {
        for (int i = 0; i < items.size(); i++) {
            if (str.equals(items.get(i).name)) {
                Item it = new Item(items.get(i));
                return it;
            }
        }
        return null;
    }
    
    private Item fin(String str){
            for (int i = 0; i < items.size(); i++) {
                if(str.equals(items.get(i).name)){
                    return items.get(i);
                }
            }
            return null;
        }

    private Item finditemc(int code) {
        for (int i = 0; i < items.size(); i++) {
            if (code == (items.get(i).c)) {
                return items.get(i);
            }
        }
        return null;
    }

    class Person{
        String name;
        String type;
        int health;
        int off;
        int def;
        int image;
        int x; 
        int y;
        
        int defbonus;
        int offbonus;
        
        String typeOfweapon;
    }
    
    
    class Hero extends Person{

        int coins;
        Item armor = null;
        Item leftHand = null;
        Item rightHand = null;
        ArrayList<String> atr = new ArrayList<String>();
        ArrayList<Item> it = new ArrayList<Item>();
        

        public Hero(File file) throws FileNotFoundException, IOException {
            String str = null;
            BufferedReader br = new BufferedReader(new FileReader(file.getPath()));
            String[] strline;
            for (int i = 0; i < 13; i++) {
                str = br.readLine();
                strline = str.split(":");
                atr.add(strline[1]);
            }
            str = br.readLine();
            coins = Integer.parseInt(str);
            str = br.readLine();
            while (str != null) {
                it.add(finditemc(Integer.parseInt(str)));
                str = br.readLine();
            }
            offbonus = Integer.parseInt(atr.get(power)) / 2 - 5;
            defbonus = Integer.parseInt(atr.get(ability)) / 2 - 5;
            image=heroes.size();
            name=atr.get(0);
            type="Hero";
            health=Integer.parseInt(atr.get(4));
            typeOfweapon="melee";
            
            if(offbonus > 0 ){
                off=offbonus;
            }else{
                off=0;
            }
            if(defbonus >0 ){
                def=defbonus;
            }else{
                def=0;
            }
                
        }
        public int recalculatearmor(){
            int x =defbonus;
            if(armor != null){
                x+=armor.def;
            }
            if(leftHand != null){
                x+=leftHand.def;
            }
            if(rightHand != null){
                x+=rightHand.def;
            }
            if(x>0){
                return x;
            }else{
                return 0;
            }
        }
        public int recalculateoff(){
            int x =offbonus;
            if(leftHand != null){
                x+=leftHand.power; 
            }
            if(rightHand != null){
                x+=rightHand.power;
            }
            if(x>0){
                return x;
            }else{
                return 0;
            }
        }
    }
    
    class creature extends Person{

        private creature(File file) throws FileNotFoundException, IOException {
            BufferedReader br = new BufferedReader(new FileReader(file.getPath()));
            String[] strline;
            
            this.name=br.readLine();
            this.type=br.readLine();
            this.health=Integer.parseInt(br.readLine());
            this.off=Integer.parseInt(br.readLine());
            this.def=Integer.parseInt(br.readLine());
            images.add(br.readLine());
            this.typeOfweapon="melee";
            this.image=images.size()-1;
        }
        
    }

    class Item {

        String name;
        String type;
        int c = 0;
        int cost = 0;
        int power = 0;
        int off = 0;
        int def = 0;
        int range[];

        public Item(Item it) {
            this.name = it.name;
            this.type = it.type;
            this.c = it.c;
            this.cost = it.cost;
            this.power = it.power;
            this.off = it.off;
            this.def = it.def;
            this.range = it.range;

        }
        public Item(String item, String type){
            String[] str = item.split(" ");
            if("armor".equals(type)){
                this.type=type;
                c=Integer.parseInt(str[0]);
                name=str[1];
                cost=Integer.parseInt(str[2]);
                if(c>10){
                    def=c-10;
                }else{
                    def=c;
                }
            }
            if("weapon".equals(type)){
                this.type=type;
                c=Integer.parseInt(str[0]);
                name=str[1];
                power= Integer.parseInt(str[2]);
                off=Integer.parseInt(str[3]);
                if(c< 1000){
                    def=Integer.parseInt(str[4]);
                    cost=Integer.parseInt(str[5]);
                }else{
                    range= new int[3];
                    range[0]=Integer.parseInt(str[4]);
                    range[1]=Integer.parseInt(str[5]);
                    range[2]=Integer.parseInt(str[6]);
                    cost=Integer.parseInt(str[7]);
                    
                }
            }
            if("item".equals(type)){
                this.type=type;
                c=Integer.parseInt(str[0]);
                name=str[1];
                cost=Integer.parseInt(str[2]);
            }
        }
    }

    class Square{
        
        int x;
        int y;
        int size = 36;
        Color data = GRASS;
        public Person onme =null;

        public void setX(int x) {
            this.x = x;
        }

        public int getX() {
            return x;
        }

        public void setY(int y) {
            this.y = y;
        }

        public int getY() {
            return y;
        }

        public Square(int x, int y) {
            this.x = x * size;
            this.y = y * size;
        }

        public Square(int x, int y, Color c) {
            this.x = x * size;
            this.y = y * size;
            data = c;
        }

        public void paintSquare(Graphics g) {
            g.setColor(data);
            g.fillRect(x, y, size, size);
            g.setColor(Color.BLACK);
            g.drawRect(x, y, size, size);
            
            if(onme != null){
                g.drawImage(new ImageIcon(images.get(onme.image)).getImage(), x+1, y+1,null);
            }else{
                if(data==GRASS){
                g.drawImage(new ImageIcon("resources/img/ground.jpg").getImage(), x+1, y+1,null);
        
            }
             if(data==TREE){
                g.drawImage(new ImageIcon("resources/img/tree.jpg").getImage(), x+1, y+1,null);
        
            }
              if(data==ROCK){
                g.drawImage(new ImageIcon("resources/img/rock.jpg").getImage(), x+1, y+1,null);
        
            }
               if(data==WATER){
                g.drawImage(new ImageIcon("resources/img/water.jpg").getImage(), x+1, y+1,null);
            }
            }
        }

        public void ChangeGround() {
            data = ChangedGround;
        }
        

    }
}
