/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package d.d;

/**
 *
 * @author pospis
 */

import java.awt.*;
import java.awt.event.*;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.*;

public class Creature {
    MainFrame frame;
    
    static final int Main = 1;
    static final int HeroesEditor = 2;
    static final int HeroesManagment = 3;
    static final int Battle = 4;
    static final int Creatures = 5;
    static final int Map = 6;
    
    int ScreenWidth;
    int ScreenHeight;
    
    CPanel panel;
    
    public Creature(MainFrame frame){
            this.frame=frame;
            panel = new CPanel(); 
    }
    
    public JPanel getPanel(){
        return panel;
    }
    
    class CPanel extends JPanel implements ActionListener{
        private final JMenuItem open;
        private final JMenuItem save;
        private final JMenuItem exit;
        private final JButton bt1;
        private final JLabel lname;
        private final JButton bt2;
        private final JLabel ltype;
        private final JButton bt3;
        private final JLabel loff;
        private final JButton bt4;
        private final JLabel ldef;
        private final JButton bt5;
        //private final JButton bt6;
        private final creature c;
        private final JLabel lhealth;
        
        public CPanel(){
            ScreenWidth=frame.getWidth();
            ScreenHeight=frame.getHeight();
            
            JMenuBar menuBar = new JMenuBar();
            frame.setJMenuBar(menuBar);
            JMenu file = new JMenu("File");
            menuBar.add(file);
            
            this.setOpaque(false);
            open = new JMenuItem("Open");
            save = new JMenuItem("Save");
            exit = new JMenuItem("Return to Menu");

            file.add(open);
            file.add(save);
            file.addSeparator();
            file.add(exit);
            frame.setVisible(true);
            
            setLayout(new BoxLayout(this,BoxLayout.Y_AXIS));
            
            
            c=new creature();
            /***********/
            Box b1 =Box.createHorizontalBox();
            
            bt1 = new JButton("Change");
            lname = new JLabel("Name: ");
            
            bt1.setMaximumSize(new Dimension(ScreenWidth/10, ScreenHeight/25));
            lname.setMaximumSize(new Dimension(ScreenWidth/10, ScreenHeight/25));
            
            b1.add(bt1);
            b1.add(Box.createRigidArea(new Dimension(20,0)));
            b1.add(lname);
            
            add(Box.createRigidArea(new Dimension(0,100)));
            add(b1);
            /*******************/
            Box b2 =Box.createHorizontalBox();
            
            bt2 = new JButton("Change");
            ltype = new JLabel("Type: ");
            
            bt2.setMaximumSize(new Dimension(ScreenWidth/10, ScreenHeight/25));
            ltype.setMaximumSize(new Dimension(ScreenWidth/10, ScreenHeight/25));
            
            b2.add(bt2);
            b2.add(Box.createRigidArea(new Dimension(20,0)));
            b2.add(ltype);
            
            add(Box.createRigidArea(new Dimension(0,50)));
            add(b2);
            /*******************/
            
            Box b5 =Box.createHorizontalBox();
            
            bt5 = new JButton("Change");
            lhealth = new JLabel("Health: ");
            lhealth.setMaximumSize(new Dimension(ScreenWidth/10, ScreenHeight/25));
            bt5.setMaximumSize(new Dimension(ScreenWidth/10, ScreenHeight/25));
            
            add(Box.createRigidArea(new Dimension(0,50)));
            bt5.setAlignmentX(CENTER_ALIGNMENT);

            b5.add(bt5);
            b5.add(Box.createRigidArea(new Dimension(20,0)));
            b5.add(lhealth);
           
            add(b5);
            
            /******************/
            Box b3 =Box.createHorizontalBox();
            
            bt3 = new JButton("Change");
            loff = new JLabel("Offensive: ");
            
            bt3.setMaximumSize(new Dimension(ScreenWidth/10, ScreenHeight/25));
            loff.setMaximumSize(new Dimension(ScreenWidth/10, ScreenHeight/25));
            
            b3.add(bt3);
            b3.add(Box.createRigidArea(new Dimension(20,0)));
            b3.add(loff);
            
            add(Box.createRigidArea(new Dimension(0,50)));
            add(b3);
            /*******************/
            Box b4 =Box.createHorizontalBox();
            
            bt4 = new JButton("Change");
            ldef = new JLabel("Defend: ");
            
            bt4.setMaximumSize(new Dimension(ScreenWidth/10, ScreenHeight/25));
            ldef.setMaximumSize(new Dimension(ScreenWidth/10, ScreenHeight/25));
            
            b4.add(bt4);
            b4.add(Box.createRigidArea(new Dimension(20,0)));
            b4.add(ldef);
            
            add(Box.createRigidArea(new Dimension(0,50)));
            add(b4);
            
            
            /*
            bt6 = new JButton("Items");
            
            bt6.setMaximumSize(new Dimension(ScreenWidth/10, ScreenHeight/25));
            
            add(Box.createRigidArea(new Dimension(0,50)));
            add(bt6);
            bt6.setAlignmentX(CENTER_ALIGNMENT);
             
            bt6.addActionListener(this);
            */
            bt1.addActionListener(this);
            bt2.addActionListener(this);
            bt3.addActionListener(this);
            bt4.addActionListener(this);
            bt5.addActionListener(this);
            
            exit.addActionListener(this);
            open.addActionListener(this);
            save.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if(e.getSource()==exit){
                frame.ChangePanel(Main);
            }
            if(e.getSource()==bt1){
                final JFrame f = new JFrame("Name");
                    f.setSize(200,300);
                    
                    
                    JPanel p = new JPanel();
                    p.setLayout(new BoxLayout(p,BoxLayout.Y_AXIS));
                    f.add(p);
                    
                    p.add(new JLabel("Write name: "));
                    final JTextField tf = new JTextField();
                    tf.setMaximumSize(new Dimension(300,40));
                    p.add(tf);
                    JButton b = new JButton("ok");
                    p.add(b);
                    b.addActionListener(new ActionListener() {

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            lname.setText("Name: "+tf.getText());
                            c.name=tf.getText();
                            f.dispose();
                        }
                    });
                    f.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
                    f.setVisible(true);
            }
            if(e.getSource()==bt2){
                final JFrame f = new JFrame("Type");
                    f.setSize(200,300);
                    
                    
                    JPanel p = new JPanel();
                    p.setLayout(new BoxLayout(p,BoxLayout.Y_AXIS));
                    f.add(p);
                    
                    p.add(new JLabel("Write type of creature: "));
                    final JTextField tf = new JTextField();
                    tf.setMaximumSize(new Dimension(300,40));
                    p.add(tf);
                    JButton b = new JButton("ok");
                    p.add(b);
                    b.addActionListener(new ActionListener() {

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            ltype.setText("Type: "+tf.getText());
                            c.type=tf.getText();
                            f.dispose();
                        }
                    });
                    f.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
                    f.setVisible(true);
            }
            if(e.getSource()==bt3){
                final JFrame f = new JFrame("Offensive");
                    f.setSize(200,300);
                    
                    
                    JPanel p = new JPanel();
                    p.setLayout(new BoxLayout(p,BoxLayout.Y_AXIS));
                    f.add(p);
                    
                    p.add(new JLabel("Write Offensive power: "));
                    final JTextField tf = new JTextField();
                    tf.setMaximumSize(new Dimension(300,40));
                    p.add(tf);
                    JButton b = new JButton("ok");
                    p.add(b);
                    b.addActionListener(new ActionListener() {

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            loff.setText("Offensive: "+tf.getText());
                            c.off=tf.getText();
                            f.dispose();
                        }
                    });
                    f.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
                    f.setVisible(true);
            }
            if(e.getSource()==bt4){
                final JFrame f = new JFrame("Defend");
                    f.setSize(200,300);
                    
                    
                    JPanel p = new JPanel();
                    p.setLayout(new BoxLayout(p,BoxLayout.Y_AXIS));
                    f.add(p);
                    
                    p.add(new JLabel("Write Defend: "));
                    final JTextField tf = new JTextField();
                    tf.setMaximumSize(new Dimension(300,40));
                    p.add(tf);
                    JButton b = new JButton("ok");
                    p.add(b);
                    b.addActionListener(new ActionListener() {

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            ldef.setText("Defende: "+tf.getText());
                            c.def=tf.getText();
                            f.dispose();
                        }
                    });
                    f.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
                    f.setVisible(true);
            }
            
            if(e.getSource()==bt5){
                final JFrame f = new JFrame("Health");
                    f.setSize(200,300);
                    
                    
                    JPanel p = new JPanel();
                    p.setLayout(new BoxLayout(p,BoxLayout.Y_AXIS));
                    f.add(p);
                    
                    p.add(new JLabel("Write Health: "));
                    final JTextField tf = new JTextField();
                    tf.setMaximumSize(new Dimension(300,40));
                    p.add(tf);
                    JButton b = new JButton("Ok");
                    p.add(b);
                    b.addActionListener(new ActionListener() {

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            lhealth.setText("Health: "+tf.getText());
                            c.health=tf.getText();
                            f.dispose();
                        }
                    });
                    f.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
                    f.setVisible(true);
            }
            
            
            if(e.getSource()==open){
                try {
                    open();
                } catch (FileNotFoundException ex) {
                    Logger.getLogger(Creature.class.getName()).log(Level.SEVERE, null, ex);
                } catch (IOException ex) {
                    Logger.getLogger(Creature.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            
            if(e.getSource()==save){
                try {
                    save();
                } catch (IOException ex) {
                    Logger.getLogger(Creature.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            
        }
        private void open() throws FileNotFoundException, IOException{
            
            JPanel op = new JPanel();
            op.setLayout(new BorderLayout());
            JTextArea log = new JTextArea(5, 20);
            log.setMargin(new Insets(5, 5, 5, 5));
            log.setEditable(false);
            JScrollPane logScrollPane = new JScrollPane(log);
            JFileChooser fc = new JFileChooser();
            op.add(logScrollPane, BorderLayout.CENTER);
            
            int returnVal = fc.showOpenDialog(op);
            
            if (returnVal == JFileChooser.APPROVE_OPTION){
                File file = fc.getSelectedFile();
                BufferedReader br = new BufferedReader(new FileReader(file.getPath()));
                c.name=br.readLine();
                c.type=br.readLine();
                c.health=br.readLine();
                c.off=br.readLine();
                c.def=br.readLine();
                
                lname.setText("Name:"+c.name);
                ltype.setText("Type:"+c.type);
                lhealth.setText("Health:"+c.type);
                loff.setText("Offensive:"+c.off);
                ldef.setText("Defend:"+c.def);
            }
        }
        
        private void save() throws IOException{
            
            JOptionPane.showMessageDialog(frame, "Saved!");
            
                BufferedWriter output = new BufferedWriter(new FileWriter("resources/creatures/"+c.name+".creature"));
                output.write(c.name);
                output.newLine();
                output.write(c.type);
                output.newLine();
                output.write(c.health);
                output.newLine();
                output.write(c.off);
                output.newLine();
                output.write(c.def);
                output.close();
                
            
        }
        @Override
       protected void paintComponent(Graphics g) {
            super.paintComponent(g);

                g.drawImage(new ImageIcon("resources/creature1.jpg").getImage(),0,0, this.getWidth(), this.getHeight(), null);

        }
    }
    
    class creature{
        String name;
        String type;
        String health;
        String off;
        String def;
    }
}
