/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package d.d;

import java.awt.*;
import java.awt.event.*;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.*;

/**
 *
 * @author pospis
 */
public class Hedit {

    HeditPanel panel;
    MainFrame frame;

    static final int Main = 1;
    static final int HeroesEditor = 2;
    static final int HeroesManagment = 3;
    static final int Battle = 4;
    static final int Creatures = 5;
    static final int Map = 6;

    int width;
    int height;
    Hero hero;

    boolean raceimage = false;
    boolean professionimage = false;
    boolean lastimage = false;

    public Hedit(MainFrame frame) {
        this.frame = frame;
        panel = new HeditPanel();

    }

    public JPanel getPanel() {
        return panel;
    }

    class HeditPanel extends JPanel implements ActionListener {

        JButton Human;
        JButton Barbar;
        JButton Dwarf;
        JButton Troll;
        JButton Elf;
        JButton Hobbit;
        JButton Magician;
        JButton Warrior;
        JButton Thief;
        JButton Borderer;
        JButton Alchemist;
        JButton ok;
        JButton cancel;
        JTextField nameField;
        JTextField atrField;
        JTextField heightherot;
        JTextField masst;
        JTextField powert;
        JTextField agilityt;
        JTextField hardnesst;
        JTextField intelligencet;
        JTextField charismat;

        public HeditPanel() {
            width = frame.getWidth();
            height = frame.getHeight();
            hero = new Hero();
            race();

        }

        private void race() {

            BoxLayout layout = new BoxLayout(this, BoxLayout.Y_AXIS);
            this.setAlignmentX(CENTER_ALIGNMENT);
            setLayout(layout);
            raceimage = true;

            JLabel label = new JLabel("Choose race");
            Hobbit = new JButton("Hobbit");
            Human = new JButton("Human");
            Elf = new JButton("Elf");
            Troll = new JButton("Troll");
            Dwarf = new JButton("Dwarf");
            Barbar = new JButton("Barbar");

            label.setFont(label.getFont().deriveFont(28.0f));

            label.setMaximumSize(new Dimension(width / 8, height / 20));
            Hobbit.setMaximumSize(new Dimension(width / 10, height / 25));
            Human.setMaximumSize(new Dimension(width / 10, height / 25));
            Elf.setMaximumSize(new Dimension(width / 10, height / 25));
            Troll.setMaximumSize(new Dimension(width / 10, height / 25));
            Dwarf.setMaximumSize(new Dimension(width / 10, height / 25));
            Barbar.setMaximumSize(new Dimension(width / 10, height / 25));

            label.setAlignmentX(CENTER_ALIGNMENT);
            Hobbit.setAlignmentX(CENTER_ALIGNMENT);
            Human.setAlignmentX(CENTER_ALIGNMENT);
            Elf.setAlignmentX(CENTER_ALIGNMENT);
            Troll.setAlignmentX(CENTER_ALIGNMENT);
            Dwarf.setAlignmentX(CENTER_ALIGNMENT);
            Barbar.setAlignmentX(CENTER_ALIGNMENT);

            add(Box.createRigidArea(new Dimension(0, 100)));
            add(label);
            add(Box.createRigidArea(new Dimension(0, 100)));
            add(Hobbit);
            add(Box.createRigidArea(new Dimension(0, 50)));
            add(Human);
            add(Box.createRigidArea(new Dimension(0, 50)));
            add(Elf);
            add(Box.createRigidArea(new Dimension(0, 50)));
            add(Troll);
            add(Box.createRigidArea(new Dimension(0, 50)));
            add(Barbar);
            add(Box.createRigidArea(new Dimension(0, 50)));
            add(Dwarf);

            Hobbit.addActionListener(this);
            Human.addActionListener(this);
            Elf.addActionListener(this);
            Troll.addActionListener(this);
            Dwarf.addActionListener(this);
            Barbar.addActionListener(this);

        }

        private void profession() {
            raceimage = false;
            professionimage = true;
            removeAll();
            revalidate();
            repaint();

            BoxLayout layout = new BoxLayout(this, BoxLayout.Y_AXIS);
            this.setAlignmentX(CENTER_ALIGNMENT);
            setLayout(layout);

            JLabel label = new JLabel("Choose profession");
            Magician = new JButton("Magician");
            Alchemist = new JButton("Alchemist");
            Borderer = new JButton("Borderer");
            Thief = new JButton("Thief");
            Warrior = new JButton("Warrior");

            label.setFont(label.getFont().deriveFont(28.0f));

            label.setMaximumSize(new Dimension(width / 5, height / 16));
            Magician.setMaximumSize(new Dimension(width / 10, height / 25));
            Alchemist.setMaximumSize(new Dimension(width / 10, height / 25));
            Borderer.setMaximumSize(new Dimension(width / 10, height / 25));
            Thief.setMaximumSize(new Dimension(width / 10, height / 25));
            Warrior.setMaximumSize(new Dimension(width / 10, height / 25));

            label.setAlignmentX(CENTER_ALIGNMENT);
            Magician.setAlignmentX(CENTER_ALIGNMENT);
            Alchemist.setAlignmentX(CENTER_ALIGNMENT);
            Borderer.setAlignmentX(CENTER_ALIGNMENT);
            Thief.setAlignmentX(CENTER_ALIGNMENT);
            Warrior.setAlignmentX(CENTER_ALIGNMENT);

            add(Box.createRigidArea(new Dimension(0, 100)));
            add(label);
            add(Box.createRigidArea(new Dimension(0, 100)));
            add(Magician);
            add(Box.createRigidArea(new Dimension(0, 50)));
            add(Alchemist);
            add(Box.createRigidArea(new Dimension(0, 50)));
            add(Borderer);
            add(Box.createRigidArea(new Dimension(0, 50)));
            add(Thief);
            add(Box.createRigidArea(new Dimension(0, 50)));
            add(Warrior);

            Magician.addActionListener(this);
            Alchemist.addActionListener(this);
            Borderer.addActionListener(this);
            Thief.addActionListener(this);
            Warrior.addActionListener(this);

            setVisible(true);

        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == Hobbit) {
                hero.setRace("Hobbit");
                profession();

            }
            if (e.getSource() == Human) {
                hero.setRace("Human");
                profession();
            }
            if (e.getSource() == Dwarf) {
                hero.setRace("Dwarf");
                profession();
            }
            if (e.getSource() == Troll) {
                hero.setRace("Kroll");
                profession();
            }
            if (e.getSource() == Elf) {
                hero.setRace("Elf");
                profession();
            }
            if (e.getSource() == Barbar) {
                hero.setRace("Barbar");
                profession();
            }
            if (e.getSource() == Warrior) {
                hero.setProfession("Warrior");
                attributes();

            }
            if (e.getSource() == Alchemist) {
                hero.setProfession("Alchemist");
                attributes();
            }
            if (e.getSource() == Magician) {
                hero.setProfession("Magician");
                attributes();
            }
            if (e.getSource() == Borderer) {
                hero.setProfession("Borderer");
                attributes();
            }
            if (e.getSource() == Thief) {
                hero.setProfession("Thief");
                attributes();
            }
            if (e.getSource() == ok) {
                try {
                    checkAndSave();
                } catch (IOException ex) {
                    Logger.getLogger(Hedit.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (e.getSource() == cancel) {
                frame.ChangePanel(Main);
            }
        }

        private void checkAndSave() throws IOException {
            String[] str = new String[9];
            try {
                str[0] = nameField.getText();
                str[1] = atrField.getText();
                str[2] = heightherot.getText();
                str[3] = masst.getText();
                str[4] = powert.getText();
                str[5] = agilityt.getText();
                str[6] = hardnesst.getText();
                str[7] = intelligencet.getText();
                str[8] = charismat.getText();
            } catch (Exception e) {
                JOptionPane.showMessageDialog(frame,
                        "You must complete all!.");
                return;
            }
            hero.setOther(str);
            frame.ChangePanel(Main);
        }

        private String DiceNumbers(String race) {

            if ("Hobbit".equals(race)) {
                return "On charisma throw 2x";
            }
            if ("Human".equals(race)) {
                return "On charisma and power throw 2x";
            }
            if ("Elf".equals(race)) {
                return "On charisma throw 2x";
            }
            if ("Kroll".equals(race)) {
                return "On charisma throw 2x";
            }
            if ("Barbar".equals(race)) {
                return "On charisma throw 2x";
            }
            return "";
        }

        private void attributes() {

            professionimage = false;
            lastimage = true;
            removeAll();
            revalidate();
            repaint();
            setVisible(true);
            setLayout(new GridLayout(1, 2));

            JPanel left = new JPanel();
            JPanel right = new JPanel();

            left.setPreferredSize(new Dimension(height, width / 2));
            right.setPreferredSize(new Dimension(height, width / 2));

            left.setOpaque(false);
            right.setOpaque(false);
            add(left);
            add(right);

            right.setLayout(new BoxLayout(right, BoxLayout.Y_AXIS));
            left.setLayout(new BoxLayout(left, BoxLayout.Y_AXIS));
            left.setAlignmentX(CENTER_ALIGNMENT);
            right.setAlignmentX(CENTER_ALIGNMENT);

            left.setVisible(true);
            right.setVisible(true);

            repaint();

            JLabel name = new JLabel("Name :");
            JLabel atr = new JLabel("Other Atrributes :");
            nameField = new JTextField();
            atrField = new JTextField();

            ok = new JButton("OK");
            cancel = new JButton("CANCEL");
            ok.setMaximumSize(new Dimension(width / 10, height / 25));
            cancel.setMaximumSize(new Dimension(width / 10, height / 25));
            ok.setAlignmentX(CENTER_ALIGNMENT);
            cancel.setAlignmentX(CENTER_ALIGNMENT);
            ok.addActionListener(this);
            cancel.addActionListener(this);

            name.setMaximumSize(new Dimension(width / 10, height / 25));
            atr.setMaximumSize(new Dimension(width / 10, height / 25));
            nameField.setMaximumSize(new Dimension(width / 5, height / 25));
            atrField.setMaximumSize(new Dimension(width / 5, height / 25));

            nameField.addActionListener(this);

            left.add(Box.createRigidArea(new Dimension(0, 50)));
            left.add(name);
            left.add(nameField);

            left.add(Box.createRigidArea(new Dimension(0, 50)));
            left.add(atr);
            left.add(atrField);

            left.add(Box.createRigidArea(new Dimension(0, 200)));
            left.add(ok);
            left.add(Box.createRigidArea(new Dimension(0, 50)));
            left.add(cancel);

            JLabel dice = new JLabel(DiceNumbers(hero.race));
            JLabel heighthero = new JLabel("Vyska :");
            JLabel mass = new JLabel("Hmotnost :");
            JLabel power = new JLabel("Sila :");
            JLabel agility = new JLabel("Obratnost :");
            JLabel hardness = new JLabel("Odolnost :");
            JLabel intelligence = new JLabel("Inteligencia :");
            JLabel charisma = new JLabel("Charizma :");
            powert = new JTextField();
            agilityt = new JTextField();
            hardnesst = new JTextField();
            intelligencet = new JTextField();
            charismat = new JTextField();
            heightherot = new JTextField();
            masst = new JTextField();

            dice.setMaximumSize(new Dimension(width / 5, height / 25));
            power.setMaximumSize(new Dimension(width / 10, height / 25));
            mass.setMaximumSize(new Dimension(width / 10, height / 25));
            agility.setMaximumSize(new Dimension(width / 10, height / 25));
            hardness.setMaximumSize(new Dimension(width / 10, height / 25));
            intelligence.setMaximumSize(new Dimension(width / 10, height / 25));
            charisma.setMaximumSize(new Dimension(width / 10, height / 25));
            heighthero.setMaximumSize(new Dimension(width / 10, height / 25));

            powert.setMaximumSize(new Dimension(width / 10, height / 25));
            agilityt.setMaximumSize(new Dimension(width / 10, height / 25));
            hardnesst.setMaximumSize(new Dimension(width / 10, height / 25));
            intelligencet.setMaximumSize(new Dimension(width / 10, height / 25));
            charismat.setMaximumSize(new Dimension(width / 10, height / 25));
            heightherot.setMaximumSize(new Dimension(width / 10, height / 25));
            masst.setMaximumSize(new Dimension(width / 10, height / 25));

            right.add(Box.createRigidArea(new Dimension(0, 50)));
            right.add(dice);
            right.add(Box.createRigidArea(new Dimension(0, 50)));
            right.add(heighthero);
            right.add(heightherot);
            right.add(Box.createRigidArea(new Dimension(0, 50)));
            right.add(mass);
            right.add(masst);
            right.add(Box.createRigidArea(new Dimension(0, 50)));
            right.add(power);
            right.add(powert);
            right.add(Box.createRigidArea(new Dimension(0, 50)));
            right.add(agility);
            right.add(agilityt);
            right.add(Box.createRigidArea(new Dimension(0, 50)));
            right.add(hardness);
            right.add(hardnesst);
            right.add(Box.createRigidArea(new Dimension(0, 50)));
            right.add(intelligence);
            right.add(intelligencet);
            right.add(Box.createRigidArea(new Dimension(0, 50)));
            right.add(charisma);
            right.add(charismat);

        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);

            if (raceimage) {
                g.drawImage(new ImageIcon("resources/edit1.jpg").getImage(), 0, 0, this.getWidth(), this.getHeight(), null);
            }
            if (professionimage) {
                g.drawImage(new ImageIcon("resources/edit2.jpg").getImage(), 0, 0, this.getWidth(), this.getHeight(), null);
            }
            if (lastimage) {
                g.drawImage(new ImageIcon("resources/edit3.jpg").getImage(), 0, 0, this.getWidth(), this.getHeight(), null);
            }
        }
    }

    class Hero {

        String race;
        String Profession;

        Race myPerson;
        String Name;
        String MyHeight;
        String MyMass;
        String MyPower;
        String MyAgility;
        String MyHardness;
        String MyIntelligence;
        String MyCharisma;

        void setRace(String str) {
            race = str;
        }

        void setProfession(String str) {
            Profession = str;
        }

        void setOther(String[] str) throws IOException {
            Me me = new Me(race, Profession);
            BufferedWriter output = new BufferedWriter(new FileWriter("resources/heroes/" + str[0] + ".hero"));
            output.write("Name:" + str[0]);
            output.newLine();
            output.write("Race:" + race);
            output.newLine();
            output.write("Profession:" + Profession);
            output.newLine();
            output.write("Level:0");
            output.newLine();
            output.write("Health:" + setNumber(1, Profession));
            output.newLine();
            output.write("Height:" + setNumber(2, str[2]));
            output.newLine();
            output.write("Mass:" + setNumber(3, str[3]));
            output.newLine();
            output.write("Power:" + setNumber(4, str[4]));
            output.newLine();
            output.write("Ability:" + setNumber(5, str[5]));
            output.newLine();
            output.write("Hardness:" + setNumber(6, str[6]));
            output.newLine();
            output.write("Intelligence:" + setNumber(7, str[7]));
            output.newLine();
            output.write("Charisma:" + setNumber(8, str[8]));
            output.newLine();
            output.write("Other:" + str[1]);
            output.newLine();
            output.write("0");

            output.close();
        }

        String setNumber(int a, String x) {

            if (a == 1) {
                if ("Magician".equals(x)) {
                    return 6 + "";
                }
                if ("Thief".equals(x)) {
                    return 6 + "";
                }
                if ("Borderer".equals(x)) {
                    return 8 + "";
                }
                if ("Warrior".equals(x)) {
                    return 10 + "";
                }
                if ("Alchemist".equals(x)) {
                    return 7 + "";
                }
            }
            int number = Integer.parseInt(x);
            if (a == 2) {
                return (String.valueOf(myPerson.height.min + 10 * (number - 1)));
            }
            if (a == 3) {
                return (String.valueOf(myPerson.mass.min + 10 * (number - 1)));
            }
            if (a == 4) {
                if (myPerson.power.max - myPerson.power.min > 5) {
                    number--;
                }
                return (String.valueOf(myPerson.power.min + (number - 1)));
            }
            if (a == 5) {
                if (myPerson.ability.max - myPerson.ability.min > 5) {
                    number--;
                }
                return (String.valueOf(myPerson.ability.min + (number - 1)));
            }
            if (a == 6) {
                if (myPerson.hardness.max - myPerson.hardness.min > 5) {
                    number--;
                }
                return (String.valueOf(myPerson.hardness.min + (number - 1)));
            }
            if (a == 7) {
                if (myPerson.intelligence.max - myPerson.intelligence.min > 5) {
                    number--;
                }
                return (String.valueOf(myPerson.intelligence.min + (number - 1)));
            }
            if (a == 8) {
                if (myPerson.charisma.max - myPerson.charisma.min > 5) {
                    number--;
                }
                return (String.valueOf(myPerson.charisma.min + (number - 1)));
            }

            return "";

        }

        class Me {

            String race;
            String profession;

            public Me(String race, String profession) {
                this.race = race;
                this.profession = profession;
                setMe();
            }

            private void setMe() {

                myPerson = null;
                Profession myProfession = null;

                if ("Hobbit".equals(race)) {
                    myPerson = new Hobbit();
                }
                if ("Human".equals(race)) {
                    myPerson = new Human();
                }
                if ("Elf".equals(race)) {
                    myPerson = new Elf();
                }
                if ("Kroll".equals(race)) {
                    myPerson = new Kroll();
                }
                if ("Barbar".equals(race)) {
                    myPerson = new Barbar();
                }
                if ("Dwarf".equals(race)) {
                    myPerson = new Dwarf();
                }

                if ("Magician".equals(profession)) {
                    myProfession = new Magician();
                }
                if ("Warrior".equals(profession)) {
                    myProfession = new Warrior();
                }
                if ("Alchemist".equals(profession)) {
                    myProfession = new Alchemist();
                }
                if ("Thief".equals(profession)) {
                    myProfession = new Thief();
                }
                if ("Borderer".equals(profession)) {
                    myProfession = new Borderer();
                }

                setProfesion(myProfession);
            }

            private void setProfesion(Profession pr) {
                if (pr.power != null) {
                    myPerson.power = pr.power;
                }
                if (pr.ability != null) {
                    myPerson.ability = pr.ability;
                }
                if (pr.charisma != null) {
                    myPerson.charisma = pr.charisma;
                }
                if (pr.hardness != null) {
                    myPerson.hardness = pr.hardness;
                }
                if (pr.intelligence != null) {
                    myPerson.intelligence = pr.intelligence;
                }

            }
        }

        class Race {

            Interval height;
            Interval mass;
            Interval power;
            Interval ability;
            Interval hardness;
            Interval intelligence;
            Interval charisma;

            int cp;
            int ca;
            int ch;
            int ci;
            int cc;

            public Race(Interval h, Interval m, Interval p, Interval a, Interval hard, Interval i, Interval c, int cp, int ca, int ch, int ci, int cc) {
                this.cc = cc;
                this.ca = ca;
                this.ch = ch;
                this.ci = ci;
                this.cp = cp;
                height = h;
                mass = m;
                power = p;
                ability = a;
                hardness = hard;
                intelligence = i;
                charisma = c;

            }
        }

        class Hobbit extends Race {

            public Hobbit() {
                super(new Interval(70, 120), new Interval(40, 90), new Interval(5, 8),
                        new Interval(11, 16), new Interval(8, 13), new Interval(10, 15),
                        new Interval(8, 18), -5, 2, 0, -2, 3);
            }

        }

        class Human extends Race {

            public Human() {
                super(new Interval(165, 210), new Interval(70, 120), new Interval(6, 16),
                        new Interval(9, 14), new Interval(9, 14), new Interval(10, 15),
                        new Interval(2, 17), 0, 0, 0, 0, 0);
            }

        }

        class Elf extends Race {

            public Elf() {
                super(new Interval(140, 190), new Interval(50, 100), new Interval(6, 11),
                        new Interval(10, 15), new Interval(6, 11), new Interval(12, 17),
                        new Interval(8, 18), 0, 1, -4, 2, 2);
            }

        }

        class Kroll extends Race {

            public Kroll() {
                super(new Interval(190, 240), new Interval(150, 200), new Interval(11, 16),
                        new Interval(5, 10), new Interval(13, 18), new Interval(2, 7),
                        new Interval(1, 11), 3, -4, 3, -6, -5);
            }

        }

        class Dwarf extends Race {

            public Dwarf() {
                super(new Interval(90, 140), new Interval(50, 100), new Interval(7, 12),
                        new Interval(7, 12), new Interval(12, 17), new Interval(8, 13),
                        new Interval(7, 12), 1, -2, 3, -3, -2);
            }

        }

        class Barbar extends Race {

            public Barbar() {
                super(new Interval(170, 220), new Interval(90, 140), new Interval(10, 15),
                        new Interval(8, 13), new Interval(11, 16), new Interval(6, 11),
                        new Interval(11, 16), 1, -1, 1, 0, -2);
            }
        }

        class Profession {

            Interval power;
            Interval ability;
            Interval hardness;
            Interval intelligence;
            Interval charisma;

            public Profession(Interval p, Interval a, Interval hard, Interval i, Interval c) {
                power = p;
                ability = a;
                hardness = hard;
                intelligence = i;
                charisma = c;

                if (p != null) {
                    power = new Interval(p.min + myPerson.cp, p.max + myPerson.cp);
                }
                if (a != null) {
                    ability = new Interval(a.min + myPerson.ca, a.max + myPerson.ca);
                }
                if (hard != null) {
                    hardness = new Interval(hard.min + myPerson.ch, hard.max + myPerson.ch);
                }
                if (i != null) {
                    intelligence = new Interval(i.min + myPerson.ci, i.max + myPerson.ci);
                }
                if (c != null) {
                    charisma = new Interval(c.min + myPerson.cc, c.max + myPerson.cc);
                }

            }

        }

        class Magician extends Profession {

            public Magician() {
                super(null, null, null, new Interval(14, 19), new Interval(13, 18));
            }
        }

        class Warrior extends Profession {

            public Warrior() {
                super(new Interval(13, 18), null, new Interval(13, 18), null, null);
            }
        }

        class Borderer extends Profession {

            public Borderer() {
                super(new Interval(11, 16), null, null, new Interval(12, 17), null);
            }
        }

        class Thief extends Profession {

            public Thief() {
                super(null, new Interval(14, 19), null, null, new Interval(12, 17));
            }
        }

        class Alchemist extends Profession {

            public Alchemist() {
                super(null, new Interval(13, 18), new Interval(12, 17), null, null);
            }
        }

        class Interval {

            int min;
            int max;

            public Interval(int x, int y) {
                min = x;
                max = y;
            }
        }

    }

}
