using System;
using System.Xml;
using System.Collections.Generic;
using Orienteering.Standard;

namespace Orienteering.Competition {
    public class Club {
        internal Orienteering.Data.Club data;

        public Club(Competition competition) {
            data = new Orienteering.Data.Club();
            Competition = competition;
        }

        public Club(Orienteering.Data.Club data) {
            this.data = data;
        }

        public Club(string name, string abbr, string country) {
            data = new Orienteering.Data.Club(name, abbr, country);
        }
        
        public string Name {
            get { return data.Name; }
            set { data.Name = value; }
        }

        public string Abbreviation {
            get { return data.Abbreviation; }
            set { data.Abbreviation = value; }
        }

        public string Country {
            get { return data.Country; }
            set { data.Country = value; }
        }

        public Competition Competition {
            get { return new Competition(data.Competition); }
            set { data.Competition = value.data; } 
        }

        public Club(XmlNode xml, Competition comp, DataBase dataBase) {
            data = new Orienteering.Data.Club();
            Competition = comp;

            foreach (XmlAttribute xmlattr in xml.Attributes) {
                if (xmlattr.Name == "name")
                    Name = xmlattr.Value;
                if (xmlattr.Name == "abbreviation") {
                    if (comp.Clubs(xmlattr.Value, dataBase).Count>0)
                        throw new AlreadyExists();
                    Abbreviation = xmlattr.Value;
                }
                if (xmlattr.Name == "country")
                    Country = xmlattr.Value;
            }

            foreach (XmlNode node in xml.ChildNodes) 
                if (node.Name == "runner")
                    new Runner(node, this, dataBase);

        }

        public void Save(DataBase dataBase) {
            data.Save(dataBase.data);
        }

        public List<Runner> Runners(DataBase dataBase) {
            List<Runner> res = new List<Runner>();
            foreach (Orienteering.Data.Runner runner in data.Runners(dataBase.data))
                res.Add(new Runner(runner));
            return res;
        }

        public XmlNode Xml(XmlDocument xml, DataBase dataBase) {
            XmlNode res = xml.CreateNode("element", "club", "");

            XmlAttribute nameAttr = (XmlAttribute)xml.CreateNode("attribute", "name", "");
            nameAttr.Value = Name.ToString();
            res.Attributes.Append(nameAttr);

            XmlAttribute abbreviationAttr = (XmlAttribute)xml.CreateNode("attribute", "abbreviation", "");
            abbreviationAttr.Value = Abbreviation;
            res.Attributes.Append(abbreviationAttr);

            XmlAttribute countryAttr = (XmlAttribute)xml.CreateNode("attribute", "country", "");
            countryAttr.Value = Country;
            res.Attributes.Append(countryAttr);

            foreach (Runner runner in Runners(dataBase))
                res.AppendChild(runner.Xml(xml, dataBase));

            return res;
        }
    }
}
