using System;
using System.Collections.Generic;

namespace Orienteering.Data {
    public class Category {
        private Course course;
        private string name;
        private int firstTime, interval;

        public Category() {
        }

        public Category(string _name, Course _course) {
            course = _course;
            name = _name;
        }

        public Course Course {
            get { return course; }
            set { course = value; }
        }
        
        public string Name {
            get { return name; }
            set { name = value; }
        }

        public int FirstTime {
            get { return firstTime; }
            set { firstTime = value; }
        }

        public int Interval {
            get { return interval; }
            set { interval = value; }
        }

        public void Save(DataBase dataBase) {
            dataBase.db.Set(this);
        }

        public List<Result> Results(DataBase dataBase) {
            return new List<Result>(
                dataBase.db.Query<Result>(
                    delegate(Result result) {
                        return result.Category == this;
                    }
                )
            );
        }
    }
}
