using System;
using System.Collections.Generic;

namespace Orienteering.Data {
    public class Club {
        private string name, abbreviation, country;
        private Competition competition;

        public Club() {
        }

        public Club(string name, string abbr, string country) {
            this.name = name;
            this.abbreviation = abbr;
            this.country = country;
        }

        public string Name {
            get { return name; }
            set { name = value; }
        }

        public string Abbreviation {
            get { return abbreviation; }
            set { abbreviation = value; }
        }

        public string Country {
            get { return country; }
            set { country = value; }
        }

        public Competition Competition {
            get { return competition; }
            set { competition = value; }
        }

        public List<Runner> Runners(DataBase dataBase) {
            return new List<Runner>(
                dataBase.db.Query<Runner>(
                    delegate(Runner runner) {
                        return runner.Club == this;
                    }
                )
            );
        }

        public void Save(DataBase dataBase) {
            dataBase.db.Set(this);
        }
    }
}
