using System;
using System.Collections.Generic;
using Orienteering.Standard;

namespace Orienteering.Data {
    public class Competition {
        private string name;

        public Competition() {
        }

        public Competition(string _name) {
            name = _name;
        }

        public string Name {
            get { return name; }
            set { name = value; }
        }

        public List<Stage> Stages(DataBase dataBase) {
            return new List<Stage>(
                dataBase.db.Query<Stage>(
                    delegate(Stage stage) {
                        return stage.Competition == this;
                    }
                )
            );
        }

        public Stage Stage(int num, DataBase dataBase) {
            IList<Stage> res = dataBase.db.Query<Stage>(
                delegate(Stage stage) {
                    return stage.Competition == this && stage.Number == num;
                }
            );
            if (res.Count==0)
                throw new DoesntExist();
            else return res[0];
        }

        public List<Club> Clubs(string abbr, DataBase dataBase) {
            return new List<Club>(
                dataBase.db.Query<Club>(delegate(Club club) {
                   return club.Competition == this && club.Abbreviation == abbr;
               })
            );
        }

        public List<Club> Clubs(DataBase dataBase) {
            return new List<Club>(
                dataBase.db.Query<Club>(
                    delegate(Club club) {
                        return club.Competition == this;
                    }
                )
            );
        }
        
        public void Save(DataBase dataBase) {
            dataBase.db.Set(this);
        }
    }
}
