using System;
using Orienteering.Standard;

namespace Orienteering.Data {
    public class Result {
        private Runner runner;
        private Category category;
        private DateTime start, finish;
        private ResultType resultType;

        public Result() {
            ResultType = ResultType.None;
        }

        public Runner Runner {
            get { return runner; }
            set { runner = value; }
        }

        public Category Category {
            get { return category; }
            set { category = value; }
        }

        public DateTime Start {
            get { return start; }
            set { start = value; }
        }

        public DateTime Finish {
            get { return finish; }
            set { finish = value; }
        }

        public ResultType ResultType {
            get { return resultType; }
            set { resultType = value; }
        }

        public void Save(DataBase dataBase) {
            dataBase.db.Set(this);
        }
    }
}
