using System;
using System.Collections.Generic;
using Orienteering.Standard;

namespace Orienteering.Data {
    public class Runner {
        private string name;
        private int regNumber;
        private Club club;

        public Runner() {
        }

        public string Name {
            get { return name; }
            set { name = value; }
        }

        public int RegNumber {
            get { return regNumber; }
            set { regNumber = value; }
        }

        public Club Club {
            get { return club; }
            set { club = value; }
        }

        public void Save(DataBase dataBase) {
            dataBase.db.Set(this);
        }

        public List<Result> Results(DataBase dataBase) {
            return new List<Result>(
                dataBase.db.Query<Result>(
                    delegate(Result result) {
                        return result.Runner == this;
                    }
                )
            );
        }

        public Result Result(Stage stage, DataBase dataBase) {
            IList<Result> res = dataBase.db.Query<Result>(
                    delegate(Result result) {
                        return result.Category.Course.Stage == stage && result.Runner == this;
                    }
                );
            if (res.Count == 0)
                throw new DoesntExist();
            else return res[0];
        }
    }
}
