using System;

namespace Orienteering.GUI {
    public static class Config {
        private static double lineWidth, radius;
        private static double numberOffset, offset, start;
        private static double zoom, zoomFactor, finishRadius;
        private static double mapScale;
        private static System.Drawing.Pen[] pen;
        private static System.Drawing.Font[] font;
        private static GUIMode mode;
        private static double dpi, fontSize;
        private static bool draw_map;
        private static PenStyle style; 
        private static FontStyle fstyle; 
        private static System.Drawing.SolidBrush brush;
        private static Cairo.Color courseColor;

        static Config() {
            lineWidth = 0.35/25.4;
            offset = 5/25.4;
            radius = 3/25.4;
            finishRadius = 2.5/25.4;
            start = 3.5/25.4;
            zoom = 0.5;
            zoomFactor = 0.9;
            dpi = 150;
            numberOffset = 2/25.4;
            fontSize = 4/25.4/0.77;
            mode = GUIMode.None;
            mapScale = 1.0/10000;
            draw_map = true;

            font = new System.Drawing.Font[2];
            font[0] = new System.Drawing.
                Font(System.Drawing.FontFamily.GenericSansSerif, (int)FontSize);
            font[1] = new System.Drawing.
                Font(System.Drawing.FontFamily.GenericSansSerif, (int)(FontSize*0.7));

            courseColor = new Cairo.Color (0.93, 0, 0.55, 0.6);

            pen = new System.Drawing.Pen[2];
            style = PenStyle.Dark;
            pen[0] = new System.Drawing.Pen 
                (System.Drawing.Color.FromArgb(190, 237, 0, 140));
            pen[1] = new System.Drawing.Pen 
                (System.Drawing.Color.FromArgb(120, 237, 0, 140));
            for (int i=0; i<pen.Length; i++)
                pen[i].LineJoin = System.Drawing.Drawing2D.LineJoin.Bevel;
        }

        public enum GUIMode {
            Start, Control, Finish, None 
        }

        public enum PenStyle {
            Dark, Light
        }

        public enum FontStyle {
            Big, Small
        }

        public static double MapScale {
            get { return mapScale; }
            set { mapScale = value; }
        }

        public static System.Drawing.SolidBrush Brush {
            get { return new System.Drawing.SolidBrush(pen[(int)style].Color); }
        }

        public static System.Drawing.Font Font {
            get { return font[(int)fstyle]; }
        }

        public static bool DrawMap {
            get { return draw_map; }
            set { draw_map = value; }
        }

        public static GUIMode Mode {
            get { return mode; }
            set { mode = value; }
        }

        public static PenStyle Style {
            get { return style; }
            set { style = value; }
        }

        public static FontStyle FStyle {
            get { return fstyle; }
            set { fstyle = value; }
        }

        public static double Dpi {
            get { return dpi; }
            set { dpi = value; }
        }

        public static double LineWidth {
            get { return dpi*lineWidth; }
            set { lineWidth = value; }
        }

        public static double Radius {
            get { return dpi*radius; }
            set { radius = value; }
        }

        public static double NumberOffset {
            get { return dpi*numberOffset; }
            set { numberOffset = value; }
        }

        public static double Offset {
            get { return dpi*offset; }
            set { offset = value; }
        }

        public static double Start {
            get { return dpi*start; }
            set { start = value; }
        }

        public static double FinishRadius {
            get { return dpi*finishRadius; }
            set { finishRadius = value; }
        }

        public static double FontSize {
            get { return dpi*fontSize; }
            set { fontSize = value; }
        }

        public static double Zoom {
            get { return zoom; }
            set {
                zoom = Math.Max(0.1, Math.Min(value, 10.0));
            }
        }

        public static double ZoomFactor {
            get { return zoomFactor; }
            set { zoomFactor = value; }
        }

        public static System.Drawing.Pen Pen {
            get {
                pen[(int)style].Width = (float)LineWidth;
                return pen[(int)style];
            }
        }

        public static Cairo.Color CourseColor {
            get { return courseColor; }
            set { courseColor = value; }
        }
    }
}
