using System;
using Gtk;
using Orienteering.Standard;

namespace Orienteering.GUI {
    public static class Standard {
        public static double String2Double(string s) {
            try {
                return Convert.ToDouble(s);
            }
            catch (FormatException) {
                Error("Zlý formát čísla");
                throw new Exception();
            }
            catch (OverflowException) {
                Error("Príliš veľké alebo príliš malé číslo");
                throw new Exception();
            }
        }

        public static int String2Int32(string s) {
            try {
                return Convert.ToInt32(s);
            }
            catch (FormatException) {
                Error("Zlý formát čísla");
                throw new Exception();
            }
            catch (OverflowException) {
                Error("Príliš veľké alebo príliš malé číslo");
                throw new Exception();
            }
        }

        public static double hypot(double x, double y) {
            return Math.Sqrt(x*x+y*y);
        }


        private static string Dialog(Window win, string title) {
            Dialog dialog = new Dialog(title, win, DialogFlags.DestroyWithParent);
            dialog.AddButton("OK", ResponseType.Ok);
            dialog.AddButton("Cancel", ResponseType.Cancel);

            dialog.VBox.Add(new Label(title));
            Entry entry = new Entry();
            dialog.VBox.Add(entry);

            dialog.ShowAll();
            if (dialog.Run() == (int)ResponseType.Ok) {
                dialog.Destroy();
                return entry.Text;
            }
            else {
                dialog.Destroy();
                throw new None();
            }
        }

        public static int Code(Window win, string title) {
            try {
                return String2Int32(Dialog(win,title));
            }
            catch {
                throw new None();
            }
        }

        public static string Name(Window win, string title) {
            return Dialog(win, title);
        }

        public static Gtk.TreeViewColumn treeColText(string title, 
                TreeCellDataFunc func, EditedHandler edited) {
            return treeColText(title, func, edited, 400);
        }

        public static Gtk.TreeViewColumn treeColText(string title,
                TreeCellDataFunc func, EditedHandler edited, int width) {
            CellRendererText renderer = new CellRendererText();
            if (edited != null) {
                renderer.Editable = true;
                renderer.Edited += edited;
            }
            else renderer.Editable = false;
            renderer.WrapWidth = width;

            TreeViewColumn res = new TreeViewColumn();
            res.Title = title;
            res.PackStart(renderer, true);
            res.SetCellDataFunc(renderer, func);
            return res;
        }

        public static Gtk.TreeViewColumn treeColComb(string title,
                ListStore tmpListStore, TreeCellDataFunc func, EditedHandler edited) {
            CellRendererCombo renderer = new CellRendererCombo();
            if (edited != null) {
                renderer.Editable = true;
                renderer.Edited += edited;
            }
            renderer.Model = tmpListStore;
            renderer.HasEntry = false;
            renderer.TextColumn = 0;

            TreeViewColumn res = new TreeViewColumn();
            res.Title = title;
            res.PackStart(renderer, true);
            res.SetCellDataFunc(renderer, func);
            return res;
        }

        public static Gtk.TreeViewColumn treeColRadio(string title,
                TreeCellDataFunc func, ToggledHandler edited) {
            CellRendererToggle crt = new CellRendererToggle();
            crt.Activatable = true;
            crt.Toggled += edited;
            crt.Radio = true;

            TreeViewColumn res = new TreeViewColumn();
            res.Title = title;
            res.PackStart(crt, true);
            res.SetCellDataFunc(crt, func);
            return res;
        }

        public static Gtk.TreeViewColumn treeColTogg(string title,
                TreeCellDataFunc func, ToggledHandler edited) {
            CellRendererToggle crt = new CellRendererToggle();
            crt.Activatable = true;
            crt.Toggled += edited;
            crt.Radio = false;

            TreeViewColumn res = new TreeViewColumn();
            res.Title = title;
            res.PackStart(crt, true);
            res.SetCellDataFunc(crt, func);
            return res;
        }

        public static void Error(string s) {
            MessageDialog md = new MessageDialog (null, DialogFlags.DestroyWithParent,
                    MessageType.Error, ButtonsType.Close, s);
            md.Run();
            md.Destroy();
        }

        public static void Info(string s) {
            MessageDialog md = new MessageDialog (null, DialogFlags.DestroyWithParent,
                    MessageType.Info, ButtonsType.Close, s);
            md.Run();
            md.Destroy();
        }

        public static void MapPoint(double a, double b, ScrolledWindow scr, out double x, out double y) {
            x = (scr.Hadjustment.Value+a-2)/Config.Zoom;
            y = (scr.Vadjustment.Value+b-2)/Config.Zoom;
        }
    }
    
    public enum ExportFormat {
        PS, PDF, SVG, PNG
    }
}
