#include "stdafx.h"
#include "FunctionDataInfo.h"
#include "ParamDataInfo.h"
#include <stdio.h>
#include <iostream>


using  namespace std;
HANDLE hFile;
ICorProfilerInfo2* pInfo;
void logData(char data[], bool console);

// functions below parse concrete types of arguments

// addr is address of function argument in memory, temp is output buffer


bool FunctionDataInfo::parseString(UINT_PTR addr, char* temp) {
	bool param = false;
	if (IsBadCodePtr((FARPROC)addr) == 0 && IsBadCodePtr((FARPROC)temp) == 0) {
		ObjectID oid = *(PUINT_PTR)addr;

		ULONG bufferLengthOffset;
		ULONG stringLengthOffset;
		ULONG bufferOffset = 0;

		if (oid == NULL) {
			strcpy(temp, "NULL");
			param = true;
		}
		else {

			if (IsBadCodePtr((FARPROC)oid) == 0) {
				HRESULT hres = E_FAIL;

				// get offset from StringObjectId to string value
				hres = pInfo->GetStringLayout(&bufferLengthOffset, &stringLengthOffset, &bufferOffset);

				if (SUCCEEDED(hres)) {

					param = true;
					ULONG_PTR pointer = oid + bufferOffset;
					char qmark[2];
					qmark[0] = '"';
					qmark[1] = '\0';
					strcpy(temp, qmark);
					wcstombs(temp + 1, (wchar_t*)pointer, maxStringLength);
					strcat(temp, qmark);

				}
			}
		}
	}
	char tmp[50];
	if (!param) { sprintf(tmp, "INVALID_ADDR=0x%x", addr);  strcat(temp, tmp); param = true; }

	return param;
}


bool FunctionDataInfo::parseBool(UINT_PTR addr, char* temp) {
	bool param = false;
	if (IsBadCodePtr((FARPROC)addr) == 0 && IsBadCodePtr((FARPROC)temp) == 0) {
		bool *boolean = (bool*)addr;
		param = true;
		if (*boolean)  { strcpy(temp, "TRUE"); }
		else { strcpy(temp, "FALSE"); }
	}
	if (!param) { strcat(temp, "INVALID_ADDR"); param = true; }

	return param;
}

bool FunctionDataInfo::parseChar(UINT_PTR addr, char* temp) {
	bool param = false;
	if (IsBadCodePtr((FARPROC)addr) == 0 && IsBadCodePtr((FARPROC)temp) == 0){
		char *character = (char*)addr;
		sprintf(temp, "%c", *character);
		param = true;
	}
	if (!param) { strcat(temp, "INVALID_ADDR"); param = true; }

	return param;
}


bool FunctionDataInfo::parseByte(UINT_PTR addr, char* temp){
	bool param = false;
	if (IsBadCodePtr((FARPROC)addr) == 0 && IsBadCodePtr((FARPROC)temp) == 0){
		byte *byte_ = (byte*)addr;
		sprintf(temp, "0x%02x", *byte_);
		param = true;
	}
	if (!param) { strcat(temp, "INVALID_ADDR"); param = true; }
	return param;
}


bool FunctionDataInfo::parseFloat(UINT_PTR addr, char* temp) {
	bool param = false;
	if (IsBadCodePtr((FARPROC)addr) == 0 && IsBadCodePtr((FARPROC)temp) == 0){
		float *float_ = (float*)addr;
		sprintf(temp, "%f", *float_);
		param = true;
	}
	if (!param) { strcat(temp, "INVALID_ADDR"); param = true; }
	return param;
}

bool FunctionDataInfo::parseDouble(UINT_PTR addr, char* temp) {
	bool param = false;
	if (IsBadCodePtr((FARPROC)addr) == 0 && IsBadCodePtr((FARPROC)temp) == 0){
		double *double_ = (double*)addr;
		sprintf(temp, "%f", *double_);
		param = true;
	}
	if (!param) { strcat(temp, "INVALID_ADDR"); param = true; }
	return param;
}




bool FunctionDataInfo::parseInt(UINT_PTR addr, char* temp) {
	bool param = false;
	if (IsBadCodePtr((FARPROC)addr) == 0 && IsBadCodePtr((FARPROC)temp) == 0){
		int *integer = (int*)addr;
		sprintf(temp, "%d", *integer);
		param = true;
	}
	if (!param) { strcat(temp, "INVALID_ADDR"); param = true; }
	return param;
}


bool FunctionDataInfo::parseUint(UINT_PTR addr, char* temp) {
	bool param = false;

	if (IsBadCodePtr((FARPROC)addr) == 0 && IsBadCodePtr((FARPROC)temp) == 0){
		unsigned int *uinteger = (unsigned int*)addr;
		sprintf(temp, "%u", *uinteger);
		param = true;
	}
	if (!param) { strcat(temp, "INVALID_ADDR"); param = true; }
	return param;
}

bool FunctionDataInfo::parseInt64(UINT_PTR addr, char* temp) {
	bool param = false;
	if (IsBadCodePtr((FARPROC)addr) == 0 && IsBadCodePtr((FARPROC)temp) == 0){
		int64_t *integer64 = (int64_t*)addr;
		sprintf(temp, "%d", *integer64);
		param = true;
	}
	if (!param) { strcat(temp, "INVALID_ADDR"); param = true; }
	return param;
}

bool FunctionDataInfo::parseUint64(UINT_PTR addr, char* temp) {
	bool param = false;
	if (IsBadCodePtr((FARPROC)addr) == 0 && IsBadCodePtr((FARPROC)temp) == 0){
		UINT64 *uinteger64 = (UINT64*)addr;
		sprintf(temp, "%u", *uinteger64);
		param = true;
	}
	if (!param) { strcat(temp, "INVALID_ADDR"); param = true; }
	return param;
}

bool FunctionDataInfo::parseInt8(UINT_PTR addr, char* temp) {
	bool param = false;
	if (IsBadCodePtr((FARPROC)addr) == 0 && IsBadCodePtr((FARPROC)temp) == 0){
		int8_t *INT8 = (int8_t*)addr;
		sprintf(temp, "%d", *INT8);
		param = true;
	}
	if (!param) { strcat(temp, "INVALID_ADDR"); param = true; }
	return param;
}

bool FunctionDataInfo::parseShort(UINT_PTR addr, char* temp) {
	bool param = false;
	if (IsBadCodePtr((FARPROC)addr) == 0 && IsBadCodePtr((FARPROC)temp) == 0){
		short *shortint = (short*)addr;
		sprintf(temp, "%d", *shortint);
		param = true;
	}
	if (!param) { strcat(temp, "INVALID_ADDR"); param = true; }
	return param;
}


bool FunctionDataInfo::parseUshort(UINT_PTR addr, char* temp) {
	bool param = false;
	if (IsBadCodePtr((FARPROC)addr) == 0 && IsBadCodePtr((FARPROC)temp) == 0){
		unsigned short *ushortint = (unsigned short *)addr;
		sprintf(temp, "%u", *ushortint);
		param = true;
	}
	if (!param) { strcat(temp, "INVALID_ADDR"); param = true; }
	return param;
}

bool FunctionDataInfo::parseUintPointer(UINT_PTR addr, char* temp) {
	bool param = false;


	if (IsBadCodePtr((FARPROC)addr) == 0 && IsBadCodePtr((FARPROC)temp) == 0) {
		unsigned int **uinteger = (unsigned int**)addr;

		if (*uinteger == NULL) {
			sprintf(temp, "NULL");
			param = true;

		}
		else {

			if (IsBadCodePtr((FARPROC)*uinteger) == 0){
				param = true;
				sprintf(temp, "%u", **uinteger);
			}
			else {
				param = true;
				char err[30];
				sprintf(err, "INVALID_ADDRPTR=0x%x", *uinteger);
				strcat(temp, err);
			}
		}
	}
	if (!param) { strcat(temp, "INVALID_ADDR"); param = true; }
	return param;
}



bool FunctionDataInfo::parseDoublePointer(UINT_PTR addr, char* temp) {
	bool param = false;


	if (IsBadCodePtr((FARPROC)addr) == 0 && IsBadCodePtr((FARPROC)temp) == 0) {
		double **integer = (double**)addr;

		if (*integer == NULL) {
			sprintf(temp, "NULL");
			param = true;

		}
		else {

			if (IsBadCodePtr((FARPROC)*integer) == 0){
				param = true;
				sprintf(temp, "%f", **integer);
			}
			else {
				param = true;
				char err[30];
				sprintf(err, "INVALID_ADDRPTR=0x%x", *integer);
				strcat(temp, err);
			}
		}
	}
	if (!param) { strcat(temp, "INVALID_ADDR"); param = true; }
	return param;
}


bool FunctionDataInfo::parseIntPointer(UINT_PTR addr, char* temp) {
	bool param = false;


	if (IsBadCodePtr((FARPROC)addr) == 0 && IsBadCodePtr((FARPROC)temp) == 0) {
		int **integer = (int**)addr;

		if (*integer == NULL) {
			sprintf(temp, "NULL");
			param = true;

		}
		else {

			if (IsBadCodePtr((FARPROC)*integer) == 0){
				param = true;
				sprintf(temp, "%d", **integer);
			}
			else {
				param = true;
				char err[30];
				sprintf(err, "INVALID_ADDRPTR=0x%x", *integer);
				strcat(temp, err);
			}
		}
	}
	if (!param) { strcat(temp, "INVALID_ADDR"); param = true; }
	return param;
}

bool FunctionDataInfo::parseCharPointer(UINT_PTR addr, char* temp) {

	bool param = false;


	if (IsBadCodePtr((FARPROC)addr) == 0 && IsBadCodePtr((FARPROC)temp) == 0) {
		char **charBuf = (char**)addr;
		param = true;
		char character[2];
		character[1] = '\0';
		strcpy(temp, "{");
		for (int i = 0; i < maxStringLength; i += 2){
			if (IsBadCodePtr((FARPROC)(*charBuf + i)) != 0) { param = false; break; }
			character[0] = *(*charBuf + i);
			strcat(temp, character);
			if (character[0] == 0) break;
		}
	}
	char tmp[50];
	if (!param) { sprintf(tmp, "INVALID_ADDR=0x%x", addr);  strcat(temp, tmp); param = true; }
	strcat(temp, "}");
	return param;
}

bool FunctionDataInfo::parseIntArray(UINT_PTR addr, char* temp) {
	bool param = false;
	if (IsBadCodePtr((FARPROC)addr) == 0 && IsBadCodePtr((FARPROC)temp) == 0) {
		ULONG count = 0;
		ObjectID oid = *(PUINT_PTR)addr;
		// we parse only single dimensional array
		const ULONG32 dimensions = 1;
		ULONG32 dimSizes[dimensions];
		int lowerBounds[dimensions];
		BYTE **ppData = new BYTE*[dimensions];

		// get info about ArrayObject
		HRESULT hres = pInfo->GetArrayObjectInfo(oid, dimensions, dimSizes, lowerBounds, ppData);

		if (SUCCEEDED(hres)) {
			ULONG32 dimSize = dimSizes[0];
			ULONG32 dimLowerBound = lowerBounds[0];

			strcpy(temp, "{");
			param = true;

			for (ULONG32 j = dimLowerBound; j < dimSize; j++) {
				count++;
				int v = **ppData;
				char number[2];
				_itoa(v, number, 10);
				strcat(temp, number);
				if (count == maxBufferCount) break;
				if (j != dimSize - 1) strcat(temp, ",");
				*ppData += sizeof(int);

			}

			strcat(temp, "}");
		}
	}
	if (!param) { strcat(temp, "INVALID_ADDR"); param = true; }
	return param;
}

bool FunctionDataInfo::parseCharArray(UINT_PTR addr, char* temp) {
	bool param = false;
	if (IsBadCodePtr((FARPROC)addr) == 0 && IsBadCodePtr((FARPROC)temp) == 0) {
		ObjectID oid = *(PUINT_PTR)addr;
		const ULONG32 dimensions = 1;
		ULONG32 dimSizes[dimensions];
		int lowerBounds[dimensions];
		BYTE **ppData = new BYTE*[dimensions];

		HRESULT hres = pInfo->GetArrayObjectInfo(oid, dimensions, dimSizes, lowerBounds, ppData);

		if (SUCCEEDED(hres)) {
			ULONG32 dimSize = dimSizes[0];
			ULONG32 dimLowerBound = lowerBounds[0];

			strcpy(temp, "{");
			param = true;
			char stringChr[2];
			stringChr[1] = '\0';
			ULONG count = 0;

			for (ULONG32 j = dimLowerBound; j < dimLowerBound + dimSize; j++) {
				count++;
				char v = (char)**ppData;
				stringChr[0] = v;
				strcat(temp, stringChr);
				if (count == maxBufferCount) break;
				if (j != dimSize - 1) strcat(temp, ",");
				*ppData += (sizeof(char) + 1); // unicode

			}
			delete ppData;
			strcat(temp, "}");
		}

	}
	if (!param) { strcat(temp, "INVALID_ADDR"); param = true; }
	return param;
}

bool FunctionDataInfo::parseByteArray(UINT_PTR addr, char* temp) {
	bool param = false;
	PDWORD lpflOldProtect = 0;


	if (IsBadCodePtr((FARPROC)addr) == 0) {
		ULONG count = 0;
		ObjectID oid = *(ObjectID*)addr;
		const ULONG32 dimensions = 1;
		ULONG32 dimSizes[dimensions];
		int lowerBounds[dimensions];
		BYTE **ppData = new BYTE*[dimensions + 1];
		HRESULT hres = E_FAIL;


		if (oid != NULL && oid != -1) {

			hres = pInfo->GetArrayObjectInfo(oid, dimensions, dimSizes, lowerBounds, ppData);
			if (!SUCCEEDED(hres)) printf("getarrayobjectFAIL %d \r\n", oid);
		}


		if (SUCCEEDED(hres)) {
			ULONG32 dimSize = dimSizes[0];
			ULONG32 dimLowerBound = lowerBounds[0];

			strcpy(temp, "{");
			param = true;

			for (ULONG32 j = dimLowerBound; j < dimSize; j++) {
				count++;
				byte v = **ppData;
				char number[10];
				sprintf(number, "0x%02x", v);
				strcat(temp, number);
				if (count == maxBufferCount) break;
				if (j != dimSize - 1) strcat(temp, ",");
				*ppData += sizeof(byte);

			}

			strcat(temp, "}");
		}
	}
	char err[30];
	sprintf(err, "INVALID_ADDR=0x%x", addr);
	if (!param) { strcat(temp, err); param = true; }
	return param;
}


HRESULT FunctionDataInfo::getMethodNameAndClassType(char * buffer){

	if (methodDataFlag == false) return NULL;

	memset(buffer, 0, sizeof(buffer));
	strncpy(buffer, methodName, methodLength);

	return S_OK;

}


HRESULT FunctionDataInfo::getClassName(char * buffer) {

	ULONG length;
	memset(buffer, 0, sizeof(buffer));
	hr = ppImport->GetTypeDefProps(Class, widebuffer, bufSize, &length, NULL, NULL);
	wcstombs((char*)buffer, widebuffer, length);
	strcpy(this->className, buffer);
	return hr;

}


// gets name of module in which function is called
HRESULT FunctionDataInfo::getModuleName(char * buffer){

	ULONG length;
	GUID guid;
	memset(buffer, 0, sizeof(buffer));
	hr = ppImport->GetScopeProps(widebuffer, bufSize, &length, &guid);
	wcstombs((char*)buffer, widebuffer, length);
	return hr;
}

HRESULT FunctionDataInfo::getAddress(){

	return NULL;
}

void FunctionDataInfo::release(){

	ppImport->Release();
}


HRESULT FunctionDataInfo::getArguments(char * buffer) {
	DWORD written = 0;
	mdParamDef  paramDefToken[smallBufSize * 10];
	ULONG paramsCount;
	ULONG paramSeq;
	ULONG nameLen;
	DWORD valueType;
	char temp[bufSize];
	bool param = false;
	bool error = false;
	ULONG numGenericParams;

	memset(buffer, 0, sizeof(buffer));

	// get Token of each param using IMetadataImport interface
	ppImport->EnumParams(&paramEnumerator, methodToken, paramDefToken, bufSize, &paramsCount);

	/* Parse function Signature. Data in signature are in compressed form
	   CorSigUncompressData decompresses data and returns number of bytes, by which compressed value
	   was represented in signature. We then move forward in signature to get other information
	   */

	//   get calling convention, its value is logical OR of muliple flags 
	pSignatureFunc += CorSigUncompressData(pSignatureFunc, &this->callingConvention);

	// check generic params, we have to move in signature, although we are not interested in number of gen. params
	if ((this->callingConvention & 0x10) == 0x10) { pSignatureFunc += CorSigUncompressData(pSignatureFunc, &numGenericParams); }

	// check hasthis, if it has, the first argument function is this pointer, save this information
	if ((this->callingConvention & 0x20) == 0x20) this->hasThis = true;

	// number of function parameters
	pSignatureFunc += CorSigUncompressData(pSignatureFunc, &this->paramCount);

	// return value type
	this->pReturnInfo = ParamDataInfo::ParseSignature(&pSignatureFunc, ppImport);

	// check if signature contains type of this parameter. Flag is set only if  hasthis too (0x20)
	if ((this->callingConvention & 0x40) == 0x40)  ParamDataInfo::ParseSignature(&pSignatureFunc, ppImport);

	// parse param types
	for (ULONG count = 0; count < this->paramCount; count++) {
		ParamDataInfo* argument = ParamDataInfo::ParseSignature(&pSignatureFunc, ppImport);
		// save param
		parameters.push_back(argument);
	}


	// formatting stuff
	strcat(buffer, " (");
	strcat(buffer, this->pReturnInfo->valueTypeName);
	strcat(buffer, ") ");
	strcat(buffer, "(");

	int index = 0;

	// has this is first argument, we want to parse only function arguments, not value of pointer this
	if (this->hasThis) index = 1;

	for (ULONG i = 0; i < this->paramCount; i++) {

		COR_PRF_FUNCTION_ARGUMENT_RANGE range = argumentInfo->ranges[i + index];

		// get MetadataToken and name for each param
		hr = ppImport->GetParamProps(paramDefToken[i], &methodToken, &paramSeq, widebuffer, 2 * largeBufSize, &nameLen, NULL, &valueType, NULL, NULL);

		if (!SUCCEEDED(hr)) { logData("Error getting arguments");   error = true; break; }

		ParamDataInfo *arg = parameters.at(i);

		//-----------------------------------------------------------------------------------------------

		param = false;

		// variable type name
		if (isTypeNameEnabled()) {
			arg->getName(temp);
			strcat(buffer, temp);
			strcat(buffer, " ");
		}

		wcstombs((char*)temp, widebuffer, nameLen);

		// variable name
		if (isVarNameEnabled()) strcat(buffer, temp);

		memset(temp, 0, sizeof(temp));

		// parse variable values--------------------------------------------------------------------

		if (this->isVarValueEnabled()){

			if (!param && strcmp(arg->valueTypeName, "String") == 0) param = this->parseString(range.startAddress, temp);
			if (!param && strcmp(arg->valueTypeName, "byte[]") == 0) param = this->parseByteArray(range.startAddress, temp);
			if (!param && strcmp(arg->valueTypeName, "int[]") == 0) param = this->parseIntArray(range.startAddress, temp);
			if (!param && strcmp(arg->valueTypeName, "char[]") == 0) param = this->parseCharArray(range.startAddress, temp);
			if (!param && strcmp(arg->valueTypeName, "int*") == 0) param = this->parseIntPointer(range.startAddress, temp);
			if (!param && strcmp(arg->valueTypeName, "uint*") == 0) param = this->parseUintPointer(range.startAddress, temp);
			if (!param && strcmp(arg->valueTypeName, "int") == 0) param = this->parseInt(range.startAddress, temp);
			if (!param && strcmp(arg->valueTypeName, "uint") == 0) param = this->parseUint(range.startAddress, temp);
			if (!param && strcmp(arg->valueTypeName, "int8") == 0) param = this->parseInt8(range.startAddress, temp);
			if (!param && strcmp(arg->valueTypeName, "short") == 0) param = this->parseShort(range.startAddress, temp);
			if (!param && strcmp(arg->valueTypeName, "ushort") == 0) param = this->parseUshort(range.startAddress, temp);
			if (!param && strcmp(arg->valueTypeName, "float") == 0) param = this->parseFloat(range.startAddress, temp);
			if (!param && strcmp(arg->valueTypeName, "double") == 0) param = this->parseDouble(range.startAddress, temp);
			if (!param && strcmp(arg->valueTypeName, "int64") == 0) param = this->parseInt64(range.startAddress, temp);
			if (!param && strcmp(arg->valueTypeName, "uint64") == 0) param = this->parseUint64(range.startAddress, temp);
			if (!param && strcmp(arg->valueTypeName, "byte") == 0) param = this->parseByte(range.startAddress, temp);
			if (!param && strcmp(arg->valueTypeName, "char") == 0) param = this->parseChar(range.startAddress, temp);
			if (!param && strcmp(arg->valueTypeName, "bool") == 0) param = this->parseBool(range.startAddress, temp);
			if (!param && strcmp(arg->valueTypeName, "char*") == 0) param = this->parseCharPointer(range.startAddress, temp);
			if (!param && strcmp(arg->valueTypeName, "double*") == 0) param = this->parseDoublePointer(range.startAddress, temp);



			if (param) {
				if (this->isVarNameEnabled() && this->isVarValueEnabled()) strcat(buffer, "=");
				strcat(buffer, temp);
			}

		}
		if (i != this->paramCount - 1)  strcat(buffer, ",");
	}

	strcat(buffer, ")");

	// free memory
	for (ULONG i = 0; i < parameters.size(); i++) {
		delete parameters[i];
	}

	parameters.clear();
	ppImport->CloseEnum(paramEnumerator);


	if (error) return E_FAIL;
	return S_OK;
}

bool FunctionDataInfo::isClassNameEnabled(){
	return classNameEnabled;
}

bool FunctionDataInfo::isParamNameEnabled(){
	return paramNameEnabled;
}

bool FunctionDataInfo::isModuleNameEnabled(){
	return moduleNameEnabled;
}

bool FunctionDataInfo::isVarNameEnabled(){
	return varNameEnabled;
}

bool FunctionDataInfo::isVarValueEnabled(){
	return varValueEnabled;
}

bool FunctionDataInfo::isTypeNameEnabled(){
	return typeNameEnabled;
}

void FunctionDataInfo::setClassName(bool val){
	classNameEnabled = val;
}


void FunctionDataInfo::setParamName(bool val){
	paramNameEnabled = val;
}

void FunctionDataInfo::setModuleName(bool val){
	moduleNameEnabled = val;
}

void FunctionDataInfo::setVarName(bool val){
	varNameEnabled = val;
}

void FunctionDataInfo::setVarValue(bool val){
	varValueEnabled = val;
}

void FunctionDataInfo::setTypeName(bool val){
	typeNameEnabled = val;
}

