﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Diagnostics;

namespace Wrapper
{

    public partial class Form1 : Form
    {

        public 
            
        OpenFileDialog openFileDialog1;
        // default values for filtering
        String filePath;
        String antidebug="1";
        String classnames="1";
        String console = "0";
        String modulenames = "1";
        String varnames = "1";
        String typenames = "1";
        String system = "0";
        String inline = "0";
        String varvalues = "1";
        String currmodulefilter = "0";
        String funcid = "0";
        String exceptions = "0";

        // GUID of our Profiler DLL
        String GUID = "{91C7BD20-6CB9-4C83-82D2-15A3F491FB91}";
        

        public Form1()
        {
            InitializeComponent();

            // antidebug
            checkBox1.Checked = true;
            // class name
            checkBox2.Checked = true;
            // variable values
            checkBox8.Checked = true;
            // type names
            checkBox3.Checked = true;
            // variable names
            checkBox7.Checked = true;
            // module names
            checkBox5.Checked = true;


            openFileDialog1 = new OpenFileDialog();
            openFileDialog1.Title = "Select an Application to Profile";
            openFileDialog1.Filter = "Applications |*.exe";
        }

        // on click get path of application to profile
        private void button1_Click(object sender, EventArgs e)
        {

            if (this.openFileDialog1.ShowDialog() == System.Windows.Forms.DialogResult.OK)   {

                filePath = openFileDialog1.FileName;
                maskedTextBox1.Text = openFileDialog1.FileName;
                
            }

            else
            {
                MessageBox.Show("Error");
                
            }

        }

        // start profiling
        private void button2_Click(object sender, EventArgs e)
        {

            if(!File.Exists(filePath)) {

                MessageBox.Show("The file not exists");
            }

            else {

            ProcessStartInfo psi;
            psi=new ProcessStartInfo(filePath);

            if (!psi.EnvironmentVariables.ContainsKey("MODULE_"))
            {
                psi.EnvironmentVariables.Add("MODULE_",filePath);
            }


                // Set environment variables for process to be started

            // profiling variables
            if (!psi.EnvironmentVariables.ContainsKey("COR_ENABLE_PROFILING"))
            {
                psi.EnvironmentVariables.Add("COR_ENABLE_PROFILING","1");
                psi.EnvironmentVariables.Add("COR_PROFILER", GUID);             

            }

            // this variable is set in order profiler for .NET 2 could profile .NET application of higher version
            if (!psi.EnvironmentVariables.ContainsKey("COMPLUS_ProfAPI_ProfilerCompatibilitySetting"))
            {
                psi.EnvironmentVariables.Add("COMPLUS_ProfAPI_ProfilerCompatibilitySetting", "EnableV2Profiler");

            }

            // filtering variables
            if (!psi.EnvironmentVariables.ContainsKey("ANTIDEBUG_"))
            {
                psi.EnvironmentVariables.Add("ANTIDEBUG_",antidebug);  

            } else psi.EnvironmentVariables["ANTIDEBUG_"]=antidebug;

            if (!psi.EnvironmentVariables.ContainsKey("CONSOLE_"))
            {
                psi.EnvironmentVariables.Add("CONSOLE_", console);

            }
            else psi.EnvironmentVariables["CONSOLE_"] = console;

            if (!psi.EnvironmentVariables.ContainsKey("CURRMODULE_"))
            {
                psi.EnvironmentVariables.Add("CURRMODULE_", currmodulefilter);

            }
            else psi.EnvironmentVariables["CURRMODULE_"] = currmodulefilter;

            if (!psi.EnvironmentVariables.ContainsKey("CLASSNAMES_"))
            {
                psi.EnvironmentVariables.Add("CLASSNAMES_", classnames);
            }
            else psi.EnvironmentVariables["CLASSNAMES_"] = classnames;

            if (!psi.EnvironmentVariables.ContainsKey("TYPENAMES_"))
            {
                psi.EnvironmentVariables.Add("TYPENAMES_", typenames);

            } else psi.EnvironmentVariables["TYPENAMES_"] = typenames;

            if (!psi.EnvironmentVariables.ContainsKey("SYSTEM_"))
            {
                psi.EnvironmentVariables.Add("SYSTEM_", system);

            } else psi.EnvironmentVariables["SYSTEM_"] = system;

            if (!psi.EnvironmentVariables.ContainsKey("MODULENAMES_"))
            {
                psi.EnvironmentVariables.Add("MODULENAMES_", modulenames);
            }
            else psi.EnvironmentVariables["MODULENAMES_"] = modulenames;

            if (!psi.EnvironmentVariables.ContainsKey("VARNAMES_"))
            {
                psi.EnvironmentVariables.Add("VARNAMES_", varnames);
            }
            else psi.EnvironmentVariables["VARNAMES_"] = varnames;

            if (!psi.EnvironmentVariables.ContainsKey("VARVALUES_"))
            {
                psi.EnvironmentVariables.Add("VARVALUES_", varvalues);
            }
            else psi.EnvironmentVariables["VARVALUES_"] = varvalues;

            if (!psi.EnvironmentVariables.ContainsKey("INLINE_"))
            {
                psi.EnvironmentVariables.Add("INLINE_", inline);
            }
            else psi.EnvironmentVariables["INLINE_"] = inline;

            if (!psi.EnvironmentVariables.ContainsKey("EXCEPTIONS_"))
            {
                psi.EnvironmentVariables.Add("EXCEPTIONS_", exceptions);
            }
            else psi.EnvironmentVariables["EXCEPTIONS_"] = exceptions;

            if (!psi.EnvironmentVariables.ContainsKey("FUNCID_"))
            {
                psi.EnvironmentVariables.Add("FUNCID_", funcid);
            }
            else psi.EnvironmentVariables["FUNCID_"] = funcid;

            // PROCESS START
            psi.UseShellExecute = false;
            Process p = Process.Start(psi);
            }
        }



        // change values on checkbox change

        private void checkBox1_CheckedChanged(object sender, EventArgs e)
        {
            if (checkBox1.Checked) antidebug = "1";
            else { antidebug = "0"; }
        }

        private void checkBox2_CheckedChanged(object sender, EventArgs e)
        {
            if (checkBox2.Checked) classnames = "1";
            else { classnames = "0"; }
        }

        private void checkBox3_CheckedChanged(object sender, EventArgs e)
        {
            if (checkBox3.Checked) typenames = "1";
            else { typenames = "0"; }
        }

        private void checkBox4_CheckedChanged(object sender, EventArgs e)
        {
            if (checkBox4.Checked) currmodulefilter = "1";
            else { currmodulefilter = "0"; }
        }

        private void checkBox6_CheckedChanged(object sender, EventArgs e)
        {
            if (checkBox6.Checked) inline = "1";
            else { inline = "0"; }
        }

        private void checkBox5_CheckedChanged(object sender, EventArgs e)
        {
            if (checkBox5.Checked) modulenames= "1";
            else { modulenames = "0"; }
        }

        private void checkBox7_CheckedChanged(object sender, EventArgs e)
        {
            if (checkBox7.Checked) varnames = "1";
            else { varnames = "0"; }
        }

        private void checkBox8_CheckedChanged(object sender, EventArgs e)
        {
            if (checkBox8.Checked) varvalues = "1";
            else { varvalues = "0"; }
        }

        private void checkBox9_CheckedChanged(object sender, EventArgs e)
        {
            if (checkBox9.Checked) console = "1";
            else { console = "0"; }
        }

        private void checkBox10_CheckedChanged(object sender, EventArgs e)
        {
            if (checkBox10.Checked) system = "1";
            else { system = "0"; }
        }

        private void checkBox11_CheckedChanged(object sender, EventArgs e)
        {
            if (checkBox11.Checked) exceptions = "1";
            else { exceptions = "0"; }
        }

        private void checkBox12_CheckedChanged(object sender, EventArgs e)
        {
            if (checkBox12.Checked) funcid= "1";
            else { funcid = "0"; }
        }
    }
}
