#! /bin/sh
#
# urandom	This script saves the random seed between reboots.
#		It is called from the boot, halt and reboot scripts.
#
# Version:	@(#)urandom  1.33  22-Jun-1998  miquels@cistron.nl
#

[ -c /dev/urandom ] || exit 0
#. /etc/default/rcS

case "$1" in
	start|"")
		# check for read only file system
		if ! touch /etc/random-seed 2>/dev/null
		then
			echo "read-only file system detected...done"
			exit
		fi
		if [ "$VERBOSE" != no ]
		then
			printf "Initializing random number generator... "
		fi
		# Load and then save 512 bytes,
		# which is the size of the entropy pool
		cat /etc/random-seed >/dev/urandom
		rm -f /etc/random-seed
		umask 077
		dd if=/dev/urandom of=/etc/random-seed count=1 \
			>/dev/null 2>&1 || echo "urandom start: failed."
		umask 022
		[ "$VERBOSE" != no ] && echo "done."
		;;
	stop)
		if ! touch /etc/random-seed 2>/dev/null
		then
			exit
		fi
		# Carry a random seed from shut-down to start-up;
		# see documentation in linux/drivers/char/random.c
		[ "$VERBOSE" != no ] && printf "Saving random seed... "
		umask 077
		dd if=/dev/urandom of=/etc/random-seed count=1 \
			>/dev/null 2>&1 || echo "urandom stop: failed."
		[ "$VERBOSE" != no ] && echo "done."
		;;
	*)
		echo "Usage: urandom {start|stop}" >&2
		exit 1
		;;
esac
