#!/bin/sh
# post-image.sh for Deadlock Neptunite Controller

BOARD_DIR="$( dirname "${0}" )"
GENIMAGE_CFG="${BOARD_DIR}/genimage.cfg"
GENIMAGE_TMP="${BUILD_DIR}/genimage.tmp"

rm -rf "${GENIMAGE_TMP}"

# Generate relevant filesystem images. This tool is also capable of generaing images of SD cards
# and such, but config options are limited and GPT is not supported as far as I can tell.
genimage                           \
	--rootpath "${TARGET_DIR}"     \
	--tmppath "${GENIMAGE_TMP}"    \
	--inputpath "${BINARIES_DIR}"  \
	--outputpath "${BINARIES_DIR}" \
	--config "${GENIMAGE_CFG}"

# Output should be boot.vfat (containing config and env for uboot) and kernel.vfat (kernel and
# devicetree)

echo "Creating SD card image..."
dd if=/dev/zero of=${BINARIES_DIR}/sdcard.img bs=512 count=207000 status=none
# Create partition table and partitions. Relocate main GPT table to sector 2048 (from default 2).
# This is done so that U-boot can be flashed to the card starting at sector 16, where it is
# expected by the boot ROM of Allwinner H2+
sgdisk ${BINARIES_DIR}/sdcard.img \
	--new=1:4096:6143     	--change-name=1:uboot			--typecode=1:8300 \
	--new=2:6144:71679    	--change-name=2:controllerdata	--typecode=2:8300 \
	--new=3:71680:88063		--change-name=3:kernelA 		--typecode=3:8300 \
	--new=4:88064:139263	--change-name=4:rootfsA			--typecode=4:8307 \
	--new=5:139264:155647	--change-name=5:kernelB			--typecode=5:8300 \
	--new=6:155648:206847	--change-name=6:rootfsB			--typecode=6:8307 \
	-j 2048 \
	> /dev/null

echo "Installing U-Boot to SD card..."
dd if=${BINARIES_DIR}/u-boot-sunxi-with-spl.bin \
   bs=512 seek=16 conv=notrunc \
   of=${BINARIES_DIR}/sdcard.img \
   status=none

echo "Adding U-Boot config and environment partition..."
dd if=${BINARIES_DIR}/boot.vfat \
   bs=512 seek=4096 conv=notrunc \
   of=${BINARIES_DIR}/sdcard.img \
   status=none

echo "Adding kernel"
dd if=${BINARIES_DIR}/kernel.vfat \
	bs=512 seek=71680 conv=notrunc \
	of=${BINARIES_DIR}/sdcard.img \
	status=none

echo "Adding rootfs"
dd if=${BINARIES_DIR}/rootfs.squashfs \
	bs=512 seek=88064 conv=notrunc \
	of=${BINARIES_DIR}/sdcard.img \
	status=none

echo "Adding filesystem for configs"
dd if=/dev/zero of=${BINARIES_DIR}/config.f2fs bs=512 count=65534 status=none
mkfs.ext4 -L "data_and_configs" ${BINARIES_DIR}/config.f2fs
dd if=${BINARIES_DIR}/config.f2fs \
	bs=512 seek=6144 conv=notrunc \
	of=${BINARIES_DIR}/sdcard.img \
	status=none
