// this is basically a fork of https://github.com/y-js/y-text because
// cannot use `bindMonaco` function as it is outdated and throws an error
// monaco sends it's changes in format `{changes: Array(1), …}`, but yjs-text
// expects the content of the array. I have changed the code a bit to work for now

var diff = require("fast-diff");
var monacoIdentifierTemplate = { major: 0, minor: 0 };

function extend(Y) {
  Y.requestModules(["Array"]).then(function() {
    class YText extends Y.Array.typeDefinition["class"] {
      constructor(os, _model, _content, shouldInitializeByWebsckets) {
        super(os, _model, _content);
        this.textfields = [];
        this.aceInstances = [];
        this.codeMirrorInstances = [];
        this.monacoInstances = [];
        this.shouldInitializeByWebsckets = shouldInitializeByWebsckets;
        this.isInitialized = false;
      }
      toString() {
        return this._content
          .map(function(c) {
            return c.val;
          })
          .join("");
      }
      insert(pos, content) {
        var arr = content.split("");
        for (var i = 0; i < arr.length; i++) {
          if (/[\uD800-\uDFFF]/.test(arr[i])) {
            // is surrogate pair
            arr[i] = arr[i] + arr[i + 1];
            arr[i + 1] = "";
            i++;
          }
        }
        super.insert(pos, arr);
      }
      delete(pos, length) {
        if (length == null) {
          length = 1;
        }
        if (typeof length !== "number") {
          throw new Error("length must be a number!");
        }
        if (typeof pos !== "number") {
          throw new Error("pos must be a number!");
        }
        if (pos + length > this._content.length || pos < 0 || length < 0) {
          throw new Error("The deletion range exceeds the range of the array!");
        }
        if (length === 0) {
          return;
        }
        // This is for the case that part of a surrogate pair is deleted
        // we store surrogate pairs like this: [.., '🐇', '', ..] (string, code)
        if (
          this._content.length > pos + length &&
          this._content[pos + length].val === "" &&
          this._content[pos + length - 1].val.length === 2
        ) {
          // case one. first part of the surrogate pair is deleted
          let token = this._content[pos + length - 1].val[0];
          super.delete(pos, length + 1);
          super.insert(pos, [token]);
        } else if (
          pos > 0 &&
          this._content[pos].val === "" &&
          this._content[pos - 1].val.length === 2
        ) {
          // case two. second part of the surrogate pair is deleted
          let token = this._content[pos - 1].val[1];
          super.delete(pos - 1, length + 1);
          super.insert(pos - 1, [token]);
        } else {
          super.delete(pos, length);
        }
      }
      unbindAll() {
        this.unbindTextareaAll();
        this.unbindAceAll();
        this.unbindCodeMirrorAll();
        this.unbindMonacoAll();
      }
      // Monaco implementation
      unbindMonaco(monacoInstance) {
        var i = this.monacoInstances.findIndex(function(binding) {
          return binding.editor === monacoInstance;
        });
        if (i >= 0) {
          var binding = this.monacoInstances[i];
          this.unobserve(binding.yCallback);
          binding.disposeBinding();
          this.monacoInstances.splice(i, 1);
        }
      }
      unbindMonacoAll() {
        for (let i = this.monacoInstances.length - 1; i >= 0; i--) {
          this.unbindMonaco(this.monacoInstances[i].editor);
        }
      }
      // NOTE: initializeEditorItself is responsible for setting the initial value of the file
      // donwloaded from BE.
      bindMonaco(
        monacoInstance,
        initializeEditorItself,
        id,
        forceLocalInitialization
      ) {
        if (forceLocalInitialization) this.shouldInitializeByWebsckets = false;
        return new Promise(resolve => {
          var self = this;

          // this function makes sure that either the
          // monaco event is executed, or the yjs observer is executed
          var token = true;
          function mutualExcluse(f) {
            if (token) {
              token = false;
              try {
                f();
              } catch (e) {
                token = true;
                throw new Error(e);
              }
              token = true;
            }
          }

          var disposeBinding = monacoInstance.onDidChangeModelContent(e =>
            monacoCallback(e)
          ).dispose;

          if (this.shouldInitializeByWebsckets) {
            console.log(`Initializing editor '${id}' by remote value`);
            monacoInstance.setValue(this.toString());
          } else {
            console.log(`Initializing editor '${id}' by editor initial value`);
            initializeEditorItself();
          }

          function monacoCallback(event) {
            // console.log(event, self);
            mutualExcluse(function() {
              // compute start.. (col+row -> index position)
              // We shouldn't compute the offset on the old model..
              //    var start = monacoInstance.getModel().getOffsetAt({column: event.range.startColumn, lineNumber: event.range.startLineNumber})
              // So we compute the offset using the _content of this type
              //console.log(event, "event");

              // if this callback is a result of remote initialization, we do not want to propagate
              // changes as they are already on other remotes
              if (self.shouldInitializeByWebsckets && !self.isInitialized) {
                self.isInitialized = true;
                return;
              }

              event.changes.forEach(change => {
                for (
                  var i = 0, line = 1;
                  line < change.range.startLineNumber;
                  i++
                ) {
                  //console.log("HUESTON", self._content, self._content[i])
                  if (self._content[i].val === "\n") {
                    line++;
                  }
                }
                var start = i + change.range.startColumn - 1;

                // apply the delete operation first
                if (change.rangeLength > 0) {
                  self.delete(start, change.rangeLength);
                }
                // apply insert operation
                self.insert(start, change.text);
              });
            });
          }

          function yCallback(event) {
            mutualExcluse(function() {
              //console.log("Model: ", monacoInstance.getModel(), monacoInstance);
              let start = monacoInstance.getModel().getPositionAt(event.index);
              var end, text;
              if (event.type === "insert") {
                end = start;
                text = event.values.join("");
              } else if (event.type === "delete") {
                end = monacoInstance
                  .getModel()
                  .modifyPosition(start, event.length);
                text = "";
              }
              var range = {
                startLineNumber: start.lineNumber,
                startColumn: start.column,
                endLineNumber: end.lineNumber,
                endColumn: end.column
              };
              var id = {
                major: monacoIdentifierTemplate.major,
                minor: monacoIdentifierTemplate.minor++
              };
              monacoInstance.executeEdits("Yjs", [
                {
                  id: id,
                  range: range,
                  text: text,
                  forceMoveMarkers: true
                }
              ]);
            });
          }

          this.observe(yCallback);
          this.monacoInstances.push({
            editor: monacoInstance,
            yCallback: yCallback,
            monacoCallback: monacoCallback,
            disposeBinding: disposeBinding
          });

          resolve();
        });
      }
      // CodeMirror implementation..
      unbindCodeMirror(codeMirrorInstance) {
        var i = this.codeMirrorInstances.findIndex(function(binding) {
          return binding.editor === codeMirrorInstance;
        });
        if (i >= 0) {
          var binding = this.codeMirrorInstances[i];
          this.unobserve(binding.yCallback);
          binding.editor.off("changes", binding.codeMirrorCallback);
          this.codeMirrorInstances.splice(i, 1);
        }
      }
      unbindCodeMirrorAll() {
        for (let i = this.codeMirrorInstances.length - 1; i >= 0; i--) {
          this.unbindCodeMirror(this.codeMirrorInstances[i].editor);
        }
      }
      bindCodeMirror(codeMirrorInstance, options) {
        var self = this;
        options = options || {};

        // this function makes sure that either the
        // codemirror event is executed, or the yjs observer is executed
        var token = true;
        function mutualExcluse(f) {
          if (token) {
            token = false;
            try {
              f();
            } catch (e) {
              token = true;
              throw new Error(e);
            }
            token = true;
          }
        }
        codeMirrorInstance.setValue(this.toString());

        function codeMirrorCallback(cm, deltas) {
          mutualExcluse(function() {
            for (var i = 0; i < deltas.length; i++) {
              var delta = deltas[i];
              var start = codeMirrorInstance.indexFromPos(delta.from);
              // apply the delete operation first
              if (delta.removed.length > 0) {
                var delLength = 0;
                for (var j = 0; j < delta.removed.length; j++) {
                  delLength += delta.removed[j].length;
                }
                // "enter" is also a character in our case
                delLength += delta.removed.length - 1;
                self.delete(start, delLength);
              }
              // apply insert operation
              self.insert(start, delta.text.join("\n"));
            }
          });
        }
        codeMirrorInstance.on("changes", codeMirrorCallback);

        function yCallback(event) {
          mutualExcluse(function() {
            let from = codeMirrorInstance.posFromIndex(event.index);
            if (event.type === "insert") {
              let to = from;
              codeMirrorInstance.replaceRange(event.values.join(""), from, to);
            } else if (event.type === "delete") {
              let to = codeMirrorInstance.posFromIndex(
                event.index + event.length
              );
              codeMirrorInstance.replaceRange("", from, to);
            }
          });
        }
        this.observe(yCallback);
        this.codeMirrorInstances.push({
          editor: codeMirrorInstance,
          yCallback: yCallback,
          codeMirrorCallback: codeMirrorCallback
        });
      }
      unbindAce(aceInstance) {
        var i = this.aceInstances.findIndex(function(binding) {
          return binding.editor === aceInstance;
        });
        if (i >= 0) {
          var binding = this.aceInstances[i];
          this.unobserve(binding.yCallback);
          binding.editor.off("change", binding.aceCallback);
          this.aceInstances.splice(i, 1);
        }
      }
      unbindAceAll() {
        for (let i = this.aceInstances.length - 1; i >= 0; i--) {
          this.unbindAce(this.aceInstances[i].editor);
        }
      }
      bindAce(aceInstance, options) {
        var self = this;
        options = options || {};

        // this function makes sure that either the
        // ace event is executed, or the yjs observer is executed
        var token = true;
        function mutualExcluse(f) {
          if (token) {
            token = false;
            try {
              f();
            } catch (e) {
              token = true;
              throw new Error(e);
            }
            token = true;
          }
        }
        aceInstance.setValue(this.toString());

        function aceCallback(delta) {
          mutualExcluse(function() {
            var start;
            var length;

            var aceDocument = aceInstance.getSession().getDocument();
            if (delta.action === "insert") {
              start = aceDocument.positionToIndex(delta.start, 0);
              self.insert(start, delta.lines.join("\n"));
            } else if (delta.action === "remove") {
              start = aceDocument.positionToIndex(delta.start, 0);
              length = delta.lines.join("\n").length;
              self.delete(start, length);
            }
          });
        }
        aceInstance.on("change", aceCallback);

        aceInstance.selection.clearSelection();

        // We don't that ace is a global variable
        // see #2
        var aceClass;
        if (typeof ace !== "undefined" && options.aceClass == null) {
          aceClass = ace; // eslint-disable-line
        } else {
          aceClass = options.aceClass;
        }
        var aceRequire = options.aceRequire || aceClass.require;
        var Range = aceRequire("ace/range").Range;

        function yCallback(event) {
          var aceDocument = aceInstance.getSession().getDocument();
          mutualExcluse(function() {
            if (event.type === "insert") {
              let start = aceDocument.indexToPosition(event.index, 0);
              aceDocument.insert(start, event.values.join(""));
            } else if (event.type === "delete") {
              let start = aceDocument.indexToPosition(event.index, 0);
              let end = aceDocument.indexToPosition(
                event.index + event.length,
                0
              );
              var range = new Range(
                start.row,
                start.column,
                end.row,
                end.column
              );
              aceDocument.remove(range);
            }
          });
        }
        this.observe(yCallback);
        this.aceInstances.push({
          editor: aceInstance,
          yCallback: yCallback,
          aceCallback: aceCallback
        });
      }
      bind() {
        var e = arguments[0];
        if (e instanceof Element) {
          this.bindTextarea.apply(this, arguments);
        } else if (
          e != null &&
          e.session != null &&
          e.getSession != null &&
          e.setValue != null
        ) {
          this.bindAce.apply(this, arguments);
        } else if (
          e != null &&
          e.posFromIndex != null &&
          e.replaceRange != null
        ) {
          this.bindCodeMirror.apply(this, arguments);
        } else if (e != null && e.onDidChangeModelContent != null) {
          this.bindMonaco.apply(this, arguments);
        } else {
          console.error("Cannot bind, unsupported editor!");
        }
      }
      unbindTextarea(textarea) {
        var i = this.textfields.findIndex(function(binding) {
          return binding.editor === textarea;
        });
        if (i >= 0) {
          var binding = this.textfields[i];
          this.unobserve(binding.yCallback);
          var e = binding.editor;
          e.removeEventListener("input", binding.eventListener);
          this.textfields.splice(i, 1);
        }
      }
      unbindTextareaAll() {
        for (let i = this.textfields.length - 1; i >= 0; i--) {
          this.unbindTextarea(this.textfields[i].editor);
        }
      }
      bindTextarea(textfield, domRoot) {
        domRoot = domRoot || window; // eslint-disable-line
        if (domRoot.getSelection == null) {
          domRoot = window; // eslint-disable-line
        }

        // don't duplicate!
        for (var t = 0; t < this.textfields.length; t++) {
          if (this.textfields[t].editor === textfield) {
            return;
          }
        }
        // this function makes sure that either the
        // textfieldt event is executed, or the yjs observer is executed
        var token = true;
        function mutualExcluse(f) {
          if (token) {
            token = false;
            try {
              f();
            } catch (e) {
              token = true;
              throw new Error(e);
            }
            token = true;
          }
        }

        var self = this;
        textfield.value = this.toString();

        var createRange, writeRange, writeContent, getContent;
        if (
          textfield.selectionStart != null &&
          textfield.setSelectionRange != null
        ) {
          createRange = function(fix) {
            var left = textfield.selectionStart;
            var right = textfield.selectionEnd;
            if (fix != null) {
              left = fix(left);
              right = fix(right);
            }
            return {
              left: left,
              right: right
            };
          };
          writeRange = function(range) {
            writeContent(self.toString());
            textfield.setSelectionRange(range.left, range.right);
          };
          writeContent = function(content) {
            textfield.value = content;
          };
          getContent = function() {
            return textfield.value;
          };
        } else {
          createRange = function(fix) {
            var range = {};
            var s = domRoot.getSelection();
            var clength = textfield.textContent.length;
            range.left = Math.min(s.anchorOffset, clength);
            range.right = Math.min(s.focusOffset, clength);
            if (fix != null) {
              range.left = fix(range.left);
              range.right = fix(range.right);
            }
            var editedElement = s.focusNode;
            if (
              editedElement === textfield ||
              editedElement === textfield.childNodes[0]
            ) {
              range.isReal = true;
            } else {
              range.isReal = false;
            }
            return range;
          };

          writeRange = function(range) {
            writeContent(self.toString());
            var textnode = textfield.childNodes[0];
            if (range.isReal && textnode != null) {
              if (range.left < 0) {
                range.left = 0;
              }
              range.right = Math.max(range.left, range.right);
              if (range.right > textnode.length) {
                range.right = textnode.length;
              }
              range.left = Math.min(range.left, range.right);
              var r = document.createRange(); // eslint-disable-line
              r.setStart(textnode, range.left);
              r.setEnd(textnode, range.right);
              var s = domRoot.getSelection(); // eslint-disable-line
              s.removeAllRanges();
              s.addRange(r);
            }
          };
          writeContent = function(content) {
            textfield.innerText = content;
            /*
            var contentArray = content.replace(new RegExp('\n', 'g'), ' ').split(' '); // eslint-disable-line
            textfield.innerText = ''
            for (var i = 0; i < contentArray.length; i++) {
              var c = contentArray[i]
              textfield.innerText += c
              if (i !== contentArray.length - 1) {
                textfield.innerHTML += '&nbsp;'
              }
            }
            */
          };
          getContent = function() {
            return textfield.innerText;
          };
        }
        writeContent(this.toString());

        function yCallback(event) {
          mutualExcluse(() => {
            var oPos, fix;
            if (event.type === "insert") {
              oPos = event.index;
              fix = function(cursor) {
                // eslint-disable-line
                if (cursor <= oPos) {
                  return cursor;
                } else {
                  cursor += 1;
                  return cursor;
                }
              };
              var r = createRange(fix);
              writeRange(r);
            } else if (event.type === "delete") {
              oPos = event.index;
              fix = function(cursor) {
                // eslint-disable-line
                if (cursor < oPos) {
                  return cursor;
                } else {
                  cursor -= 1;
                  return cursor;
                }
              };
              r = createRange(fix);
              writeRange(r);
            }
          });
        }
        this.observe(yCallback);

        var textfieldObserver = function textfieldObserver() {
          mutualExcluse(function() {
            var r = createRange(function(x) {
              return x;
            });
            var oldContent = self.toString();
            var content = getContent();
            var diffs = diff(oldContent, content, r.left);
            var pos = 0;
            for (var i = 0; i < diffs.length; i++) {
              var d = diffs[i];
              if (d[0] === 0) {
                // EQUAL
                pos += d[1].length;
              } else if (d[0] === -1) {
                // DELETE
                self.delete(pos, d[1].length);
              } else {
                // INSERT
                self.insert(pos, d[1]);
                pos += d[1].length;
              }
            }
          });
        };
        textfield.addEventListener("input", textfieldObserver);
        this.textfields.push({
          editor: textfield,
          yCallback: yCallback,
          eventListener: textfieldObserver
        });
      }
      _destroy() {
        this.unbindAll();
        this.textfields = null;
        this.aceInstances = null;
        super._destroy();
      }
    }
    Y.extend(
      "Text",
      new Y.utils.CustomTypeDefinition({
        name: "Text",
        class: YText,
        struct: "List",
        initType: function* YTextInitializer(os, model) {
          var _content = [];
          let shouldInitializeByWebsckets = false;
          yield* Y.Struct.List.map.call(this, model, function(op) {
            shouldInitializeByWebsckets = true;
            if (op.hasOwnProperty("opContent")) {
              throw new Error("Text must not contain types!");
            } else {
              op.content.forEach(function(c, i) {
                _content.push({
                  id: [op.id[0], op.id[1] + i],
                  val: op.content[i]
                });
              });
            }
          });
          return new YText(os, model.id, _content, shouldInitializeByWebsckets);
        },
        createType: function YTextCreator(os, model) {
          return new YText(os, model.id, [], false);
        }
      })
    );
  });
}

export default extend;
